/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.binder.internal;

import android.os.Binder;
import android.os.IBinder;
import android.os.Parcel;
import android.os.RemoteException;
import io.grpc.binder.internal.ParcelHolder;
import io.grpc.internal.SerializingExecutor;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class OneWayBinderProxy {
    private static final Logger logger = Logger.getLogger(OneWayBinderProxy.class.getName());
    protected final IBinder delegate;

    private OneWayBinderProxy(IBinder iBinder) {
        this.delegate = iBinder;
    }

    public static OneWayBinderProxy wrap(IBinder iBinder, Executor inProcessThreadHopExecutor) {
        return iBinder instanceof Binder ? new InProcessImpl(iBinder, inProcessThreadHopExecutor) : new OutOfProcessImpl(iBinder);
    }

    public abstract void transact(int var1, ParcelHolder var2) throws RemoteException;

    public IBinder getDelegate() {
        return this.delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean transactAndRecycleParcel(int code, Parcel data) throws RemoteException {
        try {
            boolean bl = this.delegate.transact(code, data, null, 1);
            return bl;
        }
        finally {
            data.recycle();
        }
    }

    static class InProcessImpl
    extends OneWayBinderProxy {
        private final SerializingExecutor executor;

        InProcessImpl(IBinder binder, Executor executor) {
            super(binder);
            this.executor = new SerializingExecutor(executor);
        }

        @Override
        public void transact(int code, ParcelHolder wrappedParcel) {
            Parcel parcel = wrappedParcel.get();
            this.executor.execute(() -> {
                try {
                    if (!this.transactAndRecycleParcel(code, parcel)) {
                        logger.log(Level.FINEST, "A oneway transaction was not understood - ignoring");
                    }
                }
                catch (Exception e) {
                    logger.log(Level.FINEST, "A oneway transaction threw - ignoring", e);
                }
            });
            wrappedParcel.release();
        }
    }

    static class OutOfProcessImpl
    extends OneWayBinderProxy {
        OutOfProcessImpl(IBinder iBinder) {
            super(iBinder);
        }

        @Override
        public void transact(int code, ParcelHolder data) throws RemoteException {
            if (!this.transactAndRecycleParcel(code, data.release())) {
                throw new RemoteException("BinderProxy#transact(" + code + ", FLAG_ONEWAY) returned false");
            }
        }
    }
}

