/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.binder.internal;

import android.os.Parcel;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import javax.annotation.Nullable;

class ParcelHolder
implements Closeable {
    @Nullable
    private Parcel parcel;

    public static ParcelHolder obtain() {
        return new ParcelHolder(Parcel.obtain());
    }

    public ParcelHolder(Parcel parcel) {
        this.parcel = parcel;
    }

    public Parcel get() {
        Preconditions.checkState((this.parcel != null ? 1 : 0) != 0, (Object)"get() after close()/release()");
        return this.parcel;
    }

    public Parcel release() {
        Parcel result = this.get();
        this.parcel = null;
        return result;
    }

    @Override
    public void close() {
        if (this.parcel != null) {
            this.parcel.recycle();
            this.parcel = null;
        }
    }

    @VisibleForTesting
    public boolean isEmpty() {
        return this.parcel == null;
    }
}

