/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.binder.internal;

import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.Status;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;

final class PendingAuthListener<ReqT, RespT>
extends ServerCall.Listener<ReqT> {
    private final ConcurrentLinkedQueue<ListenerConsumer<ReqT>> pendingSteps = new ConcurrentLinkedQueue();
    private final AtomicReference<ServerCall.Listener<ReqT>> delegateRef = new AtomicReference<Object>(null);

    PendingAuthListener() {
    }

    void startCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        ServerCall.Listener delegate;
        try {
            delegate = next.startCall(call, headers);
        }
        catch (RuntimeException e) {
            call.close(Status.INTERNAL.withCause((Throwable)e).withDescription("Failed to start server call after authorization check"), new Metadata());
            return;
        }
        this.delegateRef.set(delegate);
        this.maybeRunPendingSteps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeRunPendingSteps() {
        ServerCall.Listener<ReqT> delegate = this.delegateRef.get();
        if (delegate == null) {
            return;
        }
        PendingAuthListener pendingAuthListener = this;
        synchronized (pendingAuthListener) {
            ListenerConsumer<ReqT> nextStep;
            while ((nextStep = this.pendingSteps.poll()) != null) {
                nextStep.accept(delegate);
            }
        }
    }

    public void onCancel() {
        this.pendingSteps.offer(ServerCall.Listener::onCancel);
        this.maybeRunPendingSteps();
    }

    public void onComplete() {
        this.pendingSteps.offer(ServerCall.Listener::onComplete);
        this.maybeRunPendingSteps();
    }

    public void onHalfClose() {
        this.pendingSteps.offer(ServerCall.Listener::onHalfClose);
        this.maybeRunPendingSteps();
    }

    public void onMessage(ReqT message) {
        this.pendingSteps.offer(delegate -> delegate.onMessage(message));
        this.maybeRunPendingSteps();
    }

    public void onReady() {
        this.pendingSteps.offer(ServerCall.Listener::onReady);
        this.maybeRunPendingSteps();
    }

    private static interface ListenerConsumer<ReqT> {
        public void accept(ServerCall.Listener<ReqT> var1);
    }
}

