/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.binder.internal;

import android.app.admin.DevicePolicyManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.UserHandle;
import androidx.annotation.AnyThread;
import androidx.annotation.MainThread;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.Status;
import io.grpc.binder.BinderChannelCredentials;
import io.grpc.binder.internal.Bindable;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class ServiceBinding
implements Bindable,
ServiceConnection {
    private static final Logger logger = Logger.getLogger(ServiceBinding.class.getName());
    private final BinderChannelCredentials channelCredentials;
    private final Intent bindIntent;
    @Nullable
    private final UserHandle targetUserHandle;
    private final int bindFlags;
    private final Bindable.Observer observer;
    private final Executor mainThreadExecutor;
    @GuardedBy(value="this")
    private State state;
    @Nullable
    private Context sourceContext;
    private State reportedState;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    ServiceBinding(Executor mainThreadExecutor, Context sourceContext, BinderChannelCredentials channelCredentials, Intent bindIntent, @Nullable UserHandle targetUserHandle, int bindFlags, Bindable.Observer observer) {
        ServiceBinding serviceBinding = this;
        synchronized (serviceBinding) {
            this.bindIntent = bindIntent;
            this.bindFlags = bindFlags;
            this.observer = observer;
            this.sourceContext = sourceContext;
            this.mainThreadExecutor = mainThreadExecutor;
            this.channelCredentials = channelCredentials;
            this.targetUserHandle = targetUserHandle;
            this.state = State.NOT_BINDING;
            this.reportedState = State.NOT_BINDING;
        }
    }

    @MainThread
    private void notifyBound(IBinder binder) {
        if (this.reportedState == State.NOT_BINDING) {
            this.reportedState = State.BOUND;
            logger.log(Level.FINEST, "notify bound - notifying");
            this.observer.onBound(binder);
        }
    }

    @MainThread
    private void notifyUnbound(Status reason) {
        logger.log(Level.FINEST, "notify unbound ", reason);
        this.clearReferences();
        if (this.reportedState != State.UNBOUND) {
            this.reportedState = State.UNBOUND;
            logger.log(Level.FINEST, "notify unbound - notifying");
            this.observer.onUnbound(reason);
        }
    }

    @Override
    @AnyThread
    public synchronized void bind() {
        if (this.state == State.NOT_BINDING) {
            this.state = State.BINDING;
            Status bindResult = ServiceBinding.bindInternal(this.sourceContext, this.bindIntent, this, this.bindFlags, this.channelCredentials, this.targetUserHandle);
            if (!bindResult.isOk()) {
                ServiceBinding.handleBindServiceFailure(this.sourceContext, this);
                this.state = State.UNBOUND;
                this.mainThreadExecutor.execute(() -> this.notifyUnbound(bindResult));
            }
        }
    }

    private static Status bindInternal(Context context, Intent bindIntent, ServiceConnection conn, int flags, BinderChannelCredentials channelCredentials, @Nullable UserHandle targetUserHandle) {
        BindMethodType bindMethodType = BindMethodType.BIND_SERVICE;
        try {
            if (targetUserHandle == null) {
                Preconditions.checkState((channelCredentials.getDevicePolicyAdminComponentName() == null ? 1 : 0) != 0, (Object)"BindingChannelCredentials is expected to have null devicePolicyAdmin when targetUserHandle is not set");
            } else {
                bindMethodType = channelCredentials.getDevicePolicyAdminComponentName() != null ? BindMethodType.DEVICE_POLICY_BIND_SEVICE_ADMIN : BindMethodType.BIND_SERVICE_AS_USER;
            }
            boolean bindResult = false;
            switch (bindMethodType) {
                case BIND_SERVICE: {
                    bindResult = context.bindService(bindIntent, conn, flags);
                    break;
                }
                case BIND_SERVICE_AS_USER: {
                    bindResult = context.bindServiceAsUser(bindIntent, conn, flags, targetUserHandle);
                    break;
                }
                case DEVICE_POLICY_BIND_SEVICE_ADMIN: {
                    DevicePolicyManager devicePolicyManager = (DevicePolicyManager)context.getSystemService("device_policy");
                    bindResult = devicePolicyManager.bindDeviceAdminServiceAsUser(channelCredentials.getDevicePolicyAdminComponentName(), bindIntent, conn, flags, targetUserHandle);
                }
            }
            if (!bindResult) {
                return Status.UNIMPLEMENTED.withDescription(bindMethodType.methodName() + "(" + bindIntent + ") returned false");
            }
            return Status.OK;
        }
        catch (SecurityException e) {
            return Status.PERMISSION_DENIED.withCause((Throwable)e).withDescription("SecurityException from " + bindMethodType.methodName());
        }
        catch (RuntimeException e) {
            return Status.INTERNAL.withCause((Throwable)e).withDescription("RuntimeException from " + bindMethodType.methodName());
        }
    }

    private static void handleBindServiceFailure(Context context, ServiceConnection conn) {
        try {
            context.unbindService(conn);
        }
        catch (RuntimeException e) {
            logger.log(Level.FINE, "Could not clean up after bindService() failure.", e);
        }
    }

    @Override
    @AnyThread
    public void unbind() {
        this.unbindInternal(Status.CANCELLED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    void unbindInternal(Status reason) {
        Context unbindFrom = null;
        ServiceBinding serviceBinding = this;
        synchronized (serviceBinding) {
            if (this.state == State.BINDING || this.state == State.BOUND) {
                unbindFrom = this.sourceContext;
            }
            this.state = State.UNBOUND;
        }
        this.mainThreadExecutor.execute(() -> this.notifyUnbound(reason));
        if (unbindFrom != null) {
            unbindFrom.unbindService((ServiceConnection)this);
        }
    }

    @MainThread
    private void clearReferences() {
        this.sourceContext = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public void onServiceConnected(ComponentName className, IBinder binder) {
        boolean bound = false;
        ServiceBinding serviceBinding = this;
        synchronized (serviceBinding) {
            if (this.state == State.BINDING) {
                this.state = State.BOUND;
                bound = true;
            }
        }
        if (bound) {
            this.notifyBound(binder);
        }
    }

    @MainThread
    public void onServiceDisconnected(ComponentName name) {
        this.unbindInternal(Status.UNAVAILABLE.withDescription("onServiceDisconnected: " + name));
    }

    @MainThread
    public void onNullBinding(ComponentName name) {
        this.unbindInternal(Status.UNIMPLEMENTED.withDescription("onNullBinding: " + name));
    }

    @MainThread
    public void onBindingDied(ComponentName name) {
        this.unbindInternal(Status.UNAVAILABLE.withDescription("onBindingDied: " + name));
    }

    @VisibleForTesting
    synchronized boolean isSourceContextCleared() {
        return this.sourceContext == null;
    }

    private static enum BindMethodType {
        BIND_SERVICE("bindService"),
        BIND_SERVICE_AS_USER("bindServiceAsUser"),
        DEVICE_POLICY_BIND_SEVICE_ADMIN("DevicePolicyManager.bindDeviceAdminServiceAsUser");

        private final String methodName;

        private BindMethodType(String methodName) {
            this.methodName = methodName;
        }

        public String methodName() {
            return this.methodName;
        }
    }

    private static enum State {
        NOT_BINDING,
        BINDING,
        BOUND,
        UNBOUND;

    }
}

