/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.binder.internal;

import android.os.Parcel;
import io.grpc.Status;
import javax.annotation.Nullable;

final class TransactionUtils {
    static final int FLAG_PREFIX = 1;
    static final int FLAG_MESSAGE_DATA = 2;
    static final int FLAG_SUFFIX = 4;
    static final int FLAG_OUT_OF_BAND_CLOSE = 8;
    static final int FLAG_EXPECT_SINGLE_MESSAGE = 16;
    static final int FLAG_STATUS_DESCRIPTION = 32;
    static final int FLAG_MESSAGE_DATA_IS_PARCELABLE = 64;
    static final int FLAG_MESSAGE_DATA_IS_PARTIAL = 128;
    static final int STATUS_CODE_SHIFT = 16;
    static final int STATUS_CODE_MASK = 0xFF0000;
    private static final int MAX_STATUS_DESCRIPTION_LENGTH = 1000;

    private TransactionUtils() {
    }

    static boolean hasFlag(int flags, int flag) {
        return (flags & flag) != 0;
    }

    @Nullable
    private static String getTruncatedDescription(Status status) {
        String desc = status.getDescription();
        if (desc != null && desc.length() > 1000) {
            desc = desc.substring(0, 1000);
        }
        return desc;
    }

    static Status readStatus(int flags, Parcel parcel) {
        Status status = Status.fromCodeValue((int)((flags & 0xFF0000) >> 16));
        if ((flags & 0x20) != 0) {
            status = status.withDescription(parcel.readString());
        }
        return status;
    }

    static int writeStatus(Parcel parcel, Status status) {
        int flags = status.getCode().value() << 16;
        String desc = TransactionUtils.getTruncatedDescription(status);
        if (desc != null) {
            flags |= 0x20;
            parcel.writeString(desc);
        }
        return flags;
    }

    static void fillInFlags(Parcel parcel, int flags) {
        int pos = parcel.dataPosition();
        parcel.setDataPosition(0);
        parcel.writeInt(flags);
        parcel.setDataPosition(pos);
    }
}

