/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import com.google.common.base.Supplier;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.grpc.Attributes;
import io.grpc.EquivalentAddressGroup;
import io.grpc.LoadBalancer;
import io.grpc.RequestKey;
import io.grpc.ResolvedServerInfo;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.TransportManager;
import io.grpc.internal.BlankFutureProvider;
import io.grpc.internal.ClientTransport;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public final class SimpleLoadBalancerFactory
extends LoadBalancer.Factory {
    private static final SimpleLoadBalancerFactory instance = new SimpleLoadBalancerFactory();

    private SimpleLoadBalancerFactory() {
    }

    public static SimpleLoadBalancerFactory getInstance() {
        return instance;
    }

    @Override
    public LoadBalancer newLoadBalancer(String serviceName, TransportManager tm) {
        return new SimpleLoadBalancer(tm);
    }

    private static class SimpleLoadBalancer
    extends LoadBalancer {
        private final Object lock = new Object();
        @GuardedBy(value="lock")
        private EquivalentAddressGroup addresses;
        @GuardedBy(value="lock")
        private final BlankFutureProvider<ClientTransport> pendingPicks = new BlankFutureProvider();
        @GuardedBy(value="lock")
        private StatusException nameResolutionError;
        private final TransportManager tm;

        private SimpleLoadBalancer(TransportManager tm) {
            this.tm = tm;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ListenableFuture<ClientTransport> pickTransport(@Nullable RequestKey requestKey) {
            EquivalentAddressGroup addressesCopy;
            Object object = this.lock;
            synchronized (object) {
                addressesCopy = this.addresses;
                if (addressesCopy == null) {
                    if (this.nameResolutionError != null) {
                        return Futures.immediateFailedFuture((Throwable)this.nameResolutionError);
                    }
                    return this.pendingPicks.newBlankFuture();
                }
            }
            return this.tm.getTransport(addressesCopy);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleResolvedAddresses(List<ResolvedServerInfo> updatedServers, Attributes config) {
            BlankFutureProvider.FulfillmentBatch<ClientTransport> pendingPicksFulfillmentBatch;
            EquivalentAddressGroup newAddresses;
            Object object = this.lock;
            synchronized (object) {
                ArrayList<SocketAddress> newAddressList = new ArrayList<SocketAddress>(updatedServers.size());
                for (ResolvedServerInfo server : updatedServers) {
                    newAddressList.add(server.getAddress());
                }
                newAddresses = new EquivalentAddressGroup(newAddressList);
                if (newAddresses.equals(this.addresses)) {
                    return;
                }
                this.addresses = newAddresses;
                this.nameResolutionError = null;
                pendingPicksFulfillmentBatch = this.pendingPicks.createFulfillmentBatch();
            }
            pendingPicksFulfillmentBatch.link(new Supplier<ListenableFuture<ClientTransport>>(){

                public ListenableFuture<ClientTransport> get() {
                    return SimpleLoadBalancer.this.tm.getTransport(newAddresses);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleNameResolutionError(Status error) {
            BlankFutureProvider.FulfillmentBatch<ClientTransport> pendingPicksFulfillmentBatch;
            StatusException statusException = error.augmentDescription("Name resolution failed").asException();
            Object object = this.lock;
            synchronized (object) {
                pendingPicksFulfillmentBatch = this.pendingPicks.createFulfillmentBatch();
                this.nameResolutionError = statusException;
            }
            pendingPicksFulfillmentBatch.fail(statusException);
        }
    }
}

