/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.grpc.EquivalentAddressGroup;
import io.grpc.LoadBalancer;
import io.grpc.Status;
import io.grpc.internal.BackoffPolicy;
import io.grpc.internal.ClientTransport;
import io.grpc.internal.ClientTransportFactory;
import io.grpc.internal.DelayedClientTransport;
import io.grpc.internal.ManagedClientTransport;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class TransportSet {
    private static final Logger log = Logger.getLogger(TransportSet.class.getName());
    private final Object lock = new Object();
    private final EquivalentAddressGroup addressGroup;
    private final String authority;
    private final BackoffPolicy.Provider backoffPolicyProvider;
    private final Callback callback;
    private final ClientTransportFactory transportFactory;
    private final ScheduledExecutorService scheduledExecutor;
    @GuardedBy(value="lock")
    private int nextAddressIndex;
    @GuardedBy(value="lock")
    private BackoffPolicy reconnectPolicy;
    @GuardedBy(value="lock")
    private int headIndex = -1;
    @GuardedBy(value="lock")
    private final Stopwatch backoffWatch;
    @Nullable
    @GuardedBy(value="lock")
    private ScheduledFuture<?> reconnectTask;
    @GuardedBy(value="lock")
    private final Collection<ManagedClientTransport> transports = new ArrayList<ManagedClientTransport>();
    private final LoadBalancer<ClientTransport> loadBalancer;
    @GuardedBy(value="lock")
    private boolean shutdown;
    @Nullable
    private volatile ManagedClientTransport activeTransport;
    @Nullable
    @GuardedBy(value="lock")
    private DelayedClientTransport delayedTransport;

    TransportSet(EquivalentAddressGroup addressGroup, String authority, LoadBalancer<ClientTransport> loadBalancer, BackoffPolicy.Provider backoffPolicyProvider, ClientTransportFactory transportFactory, ScheduledExecutorService scheduledExecutor, Callback callback) {
        this(addressGroup, authority, loadBalancer, backoffPolicyProvider, transportFactory, scheduledExecutor, callback, Stopwatch.createUnstarted());
    }

    @VisibleForTesting
    TransportSet(EquivalentAddressGroup addressGroup, String authority, LoadBalancer<ClientTransport> loadBalancer, BackoffPolicy.Provider backoffPolicyProvider, ClientTransportFactory transportFactory, ScheduledExecutorService scheduledExecutor, Callback callback, Stopwatch backoffWatch) {
        this.addressGroup = (EquivalentAddressGroup)Preconditions.checkNotNull((Object)addressGroup, (Object)"addressGroup");
        this.authority = authority;
        this.loadBalancer = loadBalancer;
        this.backoffPolicyProvider = backoffPolicyProvider;
        this.transportFactory = transportFactory;
        this.scheduledExecutor = scheduledExecutor;
        this.callback = callback;
        this.backoffWatch = backoffWatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ListenableFuture<ClientTransport> obtainActiveTransport() {
        ManagedClientTransport savedTransport = this.activeTransport;
        if (savedTransport != null) {
            return Futures.immediateFuture((Object)savedTransport);
        }
        Callable<ClientTransport> immediateConnectionTask = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.activeTransport == null && !this.shutdown) {
                this.delayedTransport = new DelayedClientTransport();
                this.transports.add(this.delayedTransport);
                this.delayedTransport.start(new BaseTransportListener(this.delayedTransport));
                this.activeTransport = this.delayedTransport;
                immediateConnectionTask = this.scheduleConnection();
            }
            savedTransport = this.activeTransport;
        }
        if (immediateConnectionTask != null) {
            try {
                return Futures.immediateFuture(immediateConnectionTask.call());
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        return Futures.immediateFuture((Object)savedTransport);
    }

    @Nullable
    @GuardedBy(value="lock")
    private Callable<ClientTransport> scheduleConnection() {
        long delayMillis;
        Preconditions.checkState((this.reconnectTask == null || this.reconnectTask.isDone() ? 1 : 0) != 0, (Object)"previous reconnectTask is not done");
        final int currentAddressIndex = this.nextAddressIndex++;
        List<SocketAddress> addrs = this.addressGroup.getAddresses();
        final SocketAddress address = addrs.get(currentAddressIndex);
        if (this.nextAddressIndex >= addrs.size()) {
            this.nextAddressIndex = 0;
        }
        final Callable<ClientTransport> createTransportCallable = new Callable<ClientTransport>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ClientTransport call() {
                DelayedClientTransport savedDelayedTransport;
                ManagedClientTransport newActiveTransport;
                boolean savedShutdown;
                Object object = TransportSet.this.lock;
                synchronized (object) {
                    savedShutdown = TransportSet.this.shutdown;
                    TransportSet.this.reconnectTask = null;
                    if (currentAddressIndex == TransportSet.this.headIndex) {
                        TransportSet.this.backoffWatch.reset().start();
                    }
                    newActiveTransport = TransportSet.this.transportFactory.newClientTransport(address, TransportSet.this.authority);
                    log.log(Level.INFO, "Created transport {0} for {1}", new Object[]{newActiveTransport, address});
                    TransportSet.this.transports.add(newActiveTransport);
                    newActiveTransport.start(new TransportListener(newActiveTransport, address));
                    if (TransportSet.this.shutdown) {
                        Preconditions.checkState((TransportSet.this.activeTransport == null ? 1 : 0) != 0, (Object)"Unexpected non-null activeTransport");
                    } else {
                        TransportSet.this.activeTransport = newActiveTransport;
                    }
                    savedDelayedTransport = TransportSet.this.delayedTransport;
                    TransportSet.this.delayedTransport = null;
                }
                savedDelayedTransport.setTransport(newActiveTransport);
                savedDelayedTransport.shutdown();
                if (savedShutdown) {
                    newActiveTransport.shutdown();
                }
                return newActiveTransport;
            }
        };
        if (currentAddressIndex == this.headIndex) {
            delayMillis = this.reconnectPolicy.nextBackoffMillis() - this.backoffWatch.elapsed(TimeUnit.MILLISECONDS);
        } else {
            delayMillis = 0L;
            if (this.headIndex == -1) {
                this.headIndex = currentAddressIndex;
                this.reconnectPolicy = this.backoffPolicyProvider.get();
            }
        }
        if (delayMillis <= 0L) {
            this.reconnectTask = null;
            return createTransportCallable;
        }
        this.reconnectTask = this.scheduledExecutor.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    createTransportCallable.call();
                }
                catch (Exception e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        }, delayMillis, TimeUnit.MILLISECONDS);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void shutdown() {
        ManagedClientTransport savedActiveTransport;
        boolean runCallback = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
            savedActiveTransport = this.activeTransport;
            this.activeTransport = null;
            if (this.transports.isEmpty()) {
                runCallback = true;
                Preconditions.checkState((this.reconnectTask == null ? 1 : 0) != 0, (Object)"Should have no reconnectTask scheduled");
                Preconditions.checkState((this.delayedTransport == null ? 1 : 0) != 0, (Object)"Should have no delayedTransport");
            }
        }
        if (savedActiveTransport != null) {
            savedActiveTransport.shutdown();
        }
        if (runCallback) {
            this.callback.onTerminated();
        }
    }

    @GuardedBy(value="lock")
    private void cancelReconnectTask() {
        if (this.reconnectTask != null) {
            this.reconnectTask.cancel(false);
            this.reconnectTask = null;
        }
    }

    static interface Callback {
        public void onTerminated();
    }

    private class TransportListener
    extends BaseTransportListener {
        private final SocketAddress address;

        public TransportListener(ManagedClientTransport transport, SocketAddress address) {
            super(transport);
            this.address = address;
        }

        private boolean isAttachedToActiveTransport() {
            return TransportSet.this.activeTransport == this.transport;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transportReady() {
            log.log(Level.INFO, "Transport {0} for {1} is ready", new Object[]{this.transport, this.address});
            super.transportReady();
            Object object = TransportSet.this.lock;
            synchronized (object) {
                if (this.isAttachedToActiveTransport()) {
                    TransportSet.this.headIndex = -1;
                }
            }
            TransportSet.this.loadBalancer.transportReady(TransportSet.this.addressGroup, this.transport);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transportShutdown(Status s) {
            log.log(Level.INFO, "Transport {0} for {1} is being shutdown", new Object[]{this.transport, this.address});
            super.transportShutdown(s);
            Object object = TransportSet.this.lock;
            synchronized (object) {
                if (this.isAttachedToActiveTransport()) {
                    TransportSet.this.activeTransport = null;
                }
            }
            TransportSet.this.loadBalancer.transportShutdown(TransportSet.this.addressGroup, this.transport, s);
        }

        @Override
        public void transportTerminated() {
            log.log(Level.INFO, "Transport {0} for {1} is terminated", new Object[]{this.transport, this.address});
            super.transportTerminated();
            Preconditions.checkState((!this.isAttachedToActiveTransport() ? 1 : 0) != 0, (Object)"Listener is still attached to activeTransport. Seems transportTerminated was not called.");
        }
    }

    private class BaseTransportListener
    implements ManagedClientTransport.Listener {
        protected final ManagedClientTransport transport;

        public BaseTransportListener(ManagedClientTransport transport) {
            this.transport = transport;
        }

        @Override
        public void transportReady() {
        }

        @Override
        public void transportShutdown(Status status) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transportTerminated() {
            boolean runCallback = false;
            Object object = TransportSet.this.lock;
            synchronized (object) {
                TransportSet.this.transports.remove(this.transport);
                if (TransportSet.this.shutdown && TransportSet.this.transports.isEmpty()) {
                    runCallback = true;
                    TransportSet.this.cancelReconnectTask();
                }
            }
            if (runCallback) {
                TransportSet.this.callback.onTerminated();
            }
        }
    }
}

