/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import io.grpc.Attributes;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.CompressorRegistry;
import io.grpc.DecompressorRegistry;
import io.grpc.EquivalentAddressGroup;
import io.grpc.LoadBalancer;
import io.grpc.ManagedChannel;
import io.grpc.MethodDescriptor;
import io.grpc.NameResolver;
import io.grpc.ResolvedServerInfo;
import io.grpc.Status;
import io.grpc.TransportManager;
import io.grpc.internal.BackoffPolicy;
import io.grpc.internal.ClientCallImpl;
import io.grpc.internal.ClientTransport;
import io.grpc.internal.ClientTransportFactory;
import io.grpc.internal.DelayedClientTransport;
import io.grpc.internal.FailingClientTransport;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.ManagedClientTransport;
import io.grpc.internal.SharedResourceHolder;
import io.grpc.internal.SingleTransportChannel;
import io.grpc.internal.TransportSet;
import io.grpc.internal.WithLogId;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class ManagedChannelImpl
extends ManagedChannel
implements WithLogId {
    private static final Logger log = Logger.getLogger(ManagedChannelImpl.class.getName());
    private static final Pattern URI_PATTERN = Pattern.compile("[a-zA-Z][a-zA-Z0-9+-.]*:/.*");
    private static final ClientTransport SHUTDOWN_TRANSPORT = new FailingClientTransport(Status.UNAVAILABLE.withDescription("Channel is shutdown"));
    private final ClientTransportFactory transportFactory;
    private final Executor executor;
    private final boolean usingSharedExecutor;
    private final String userAgent;
    private final Object lock = new Object();
    private final DecompressorRegistry decompressorRegistry;
    private final CompressorRegistry compressorRegistry;
    private ScheduledExecutorService scheduledExecutor;
    private final BackoffPolicy.Provider backoffPolicyProvider;
    private final Channel interceptorChannel;
    private final NameResolver nameResolver;
    private final LoadBalancer<ClientTransport> loadBalancer;
    @GuardedBy(value="lock")
    private final Map<EquivalentAddressGroup, TransportSet> transports = new HashMap<EquivalentAddressGroup, TransportSet>();
    @GuardedBy(value="lock")
    private final HashSet<DelayedClientTransport> delayedTransports = new HashSet();
    @GuardedBy(value="lock")
    private boolean shutdown;
    @GuardedBy(value="lock")
    private boolean terminated;
    private final ClientCallImpl.ClientTransportProvider transportProvider = new ClientCallImpl.ClientTransportProvider(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ClientTransport get(CallOptions callOptions) {
            Object object = ManagedChannelImpl.this.lock;
            synchronized (object) {
                if (ManagedChannelImpl.this.shutdown) {
                    return SHUTDOWN_TRANSPORT;
                }
            }
            return (ClientTransport)ManagedChannelImpl.this.loadBalancer.pickTransport(callOptions.getAffinity());
        }
    };
    private final TransportManager<ClientTransport> tm = new TransportManager<ClientTransport>(){

        @Override
        public void updateRetainedTransports(Collection<EquivalentAddressGroup> addrs) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ClientTransport getTransport(final EquivalentAddressGroup addressGroup) {
            TransportSet ts;
            Preconditions.checkNotNull((Object)addressGroup, (Object)"addressGroup");
            Object object = ManagedChannelImpl.this.lock;
            synchronized (object) {
                if (ManagedChannelImpl.this.shutdown) {
                    return SHUTDOWN_TRANSPORT;
                }
                ts = (TransportSet)ManagedChannelImpl.this.transports.get(addressGroup);
                if (ts == null) {
                    ts = new TransportSet(addressGroup, ManagedChannelImpl.this.authority(), ManagedChannelImpl.this.loadBalancer, ManagedChannelImpl.this.backoffPolicyProvider, ManagedChannelImpl.this.transportFactory, ManagedChannelImpl.this.scheduledExecutor, ManagedChannelImpl.this.executor, new TransportSet.Callback(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void onTerminated() {
                            Object object = ManagedChannelImpl.this.lock;
                            synchronized (object) {
                                ManagedChannelImpl.this.transports.remove(addressGroup);
                                ManagedChannelImpl.this.maybeTerminateChannel();
                            }
                        }

                        @Override
                        public void onAllAddressesFailed() {
                            ManagedChannelImpl.this.nameResolver.refresh();
                        }

                        @Override
                        public void onConnectionClosedByServer(Status status) {
                            ManagedChannelImpl.this.nameResolver.refresh();
                        }
                    });
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "[{0}] {1} created for {2}", new Object[]{ManagedChannelImpl.this.getLogId(), ts.getLogId(), addressGroup});
                    }
                    ManagedChannelImpl.this.transports.put(addressGroup, ts);
                }
            }
            return ts.obtainActiveTransport();
        }

        @Override
        public Channel makeChannel(ClientTransport transport) {
            return new SingleTransportChannel(transport, ManagedChannelImpl.this.executor, ManagedChannelImpl.this.scheduledExecutor, ManagedChannelImpl.this.authority());
        }

        @Override
        public ClientTransport createFailingTransport(Status error) {
            return new FailingClientTransport(error);
        }

        @Override
        public TransportManager.InterimTransport<ClientTransport> createInterimTransport() {
            return new InterimTransportImpl();
        }
    };

    ManagedChannelImpl(String target, BackoffPolicy.Provider backoffPolicyProvider, NameResolver.Factory nameResolverFactory, Attributes nameResolverParams, LoadBalancer.Factory loadBalancerFactory, ClientTransportFactory transportFactory, DecompressorRegistry decompressorRegistry, CompressorRegistry compressorRegistry, @Nullable Executor executor, @Nullable String userAgent, List<ClientInterceptor> interceptors) {
        if (executor == null) {
            this.usingSharedExecutor = true;
            this.executor = SharedResourceHolder.get(GrpcUtil.SHARED_CHANNEL_EXECUTOR);
        } else {
            this.usingSharedExecutor = false;
            this.executor = executor;
        }
        this.backoffPolicyProvider = backoffPolicyProvider;
        this.nameResolver = ManagedChannelImpl.getNameResolver(target, nameResolverFactory, nameResolverParams);
        this.loadBalancer = loadBalancerFactory.newLoadBalancer(this.nameResolver.getServiceAuthority(), this.tm);
        this.transportFactory = transportFactory;
        this.userAgent = userAgent;
        this.interceptorChannel = ClientInterceptors.intercept((Channel)new RealChannel(), interceptors);
        this.scheduledExecutor = SharedResourceHolder.get(GrpcUtil.TIMER_SERVICE);
        this.decompressorRegistry = decompressorRegistry;
        this.compressorRegistry = compressorRegistry;
        this.nameResolver.start(new NameResolver.Listener(){

            @Override
            public void onUpdate(List<ResolvedServerInfo> servers, Attributes config) {
                if (servers.isEmpty()) {
                    this.onError(Status.UNAVAILABLE.withDescription("NameResolver returned an empty list"));
                } else {
                    try {
                        ManagedChannelImpl.this.loadBalancer.handleResolvedAddresses(servers, config);
                    }
                    catch (Throwable e) {
                        this.onError(Status.INTERNAL.withCause(e).withDescription("Thrown from handleResolvedAddresses(): " + e));
                    }
                }
            }

            @Override
            public void onError(Status error) {
                Preconditions.checkArgument((!error.isOk() ? 1 : 0) != 0, (Object)"the error status must not be OK");
                ManagedChannelImpl.this.loadBalancer.handleNameResolutionError(error);
            }
        });
        if (log.isLoggable(Level.INFO)) {
            log.log(Level.INFO, "[{0}] Created with target {1}", new Object[]{this.getLogId(), target});
        }
    }

    @VisibleForTesting
    static NameResolver getNameResolver(String target, NameResolver.Factory nameResolverFactory, Attributes nameResolverParams) {
        NameResolver resolver;
        URI targetUri = null;
        StringBuilder uriSyntaxErrors = new StringBuilder();
        try {
            targetUri = new URI(target);
        }
        catch (URISyntaxException e) {
            uriSyntaxErrors.append(e.getMessage());
        }
        if (targetUri != null && (resolver = nameResolverFactory.newNameResolver(targetUri, nameResolverParams)) != null) {
            return resolver;
        }
        if (!URI_PATTERN.matcher(target).matches()) {
            try {
                targetUri = new URI(nameResolverFactory.getDefaultScheme(), null, "/" + target, null);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
            if (targetUri != null && (resolver = nameResolverFactory.newNameResolver(targetUri, nameResolverParams)) != null) {
                return resolver;
            }
        }
        throw new IllegalArgumentException(String.format("cannot find a NameResolver for %s%s", target, uriSyntaxErrors.length() > 0 ? " (" + uriSyntaxErrors + ")" : ""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ManagedChannelImpl shutdown() {
        ArrayList<TransportSet> transportsCopy = new ArrayList<TransportSet>();
        ArrayList<DelayedClientTransport> delayedTransportsCopy = new ArrayList<DelayedClientTransport>();
        Iterator iterator = this.lock;
        synchronized (iterator) {
            if (this.shutdown) {
                return this;
            }
            this.shutdown = true;
            this.scheduledExecutor = SharedResourceHolder.release(GrpcUtil.TIMER_SERVICE, this.scheduledExecutor);
            this.maybeTerminateChannel();
            if (!this.terminated) {
                transportsCopy.addAll(this.transports.values());
                delayedTransportsCopy.addAll(this.delayedTransports);
            }
        }
        this.loadBalancer.shutdown();
        this.nameResolver.shutdown();
        for (TransportSet ts : transportsCopy) {
            ts.shutdown();
        }
        for (DelayedClientTransport transport : delayedTransportsCopy) {
            transport.shutdown();
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "[{0}] Shutting down", this.getLogId());
        }
        return this;
    }

    @Override
    public ManagedChannelImpl shutdownNow() {
        this.shutdown();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isShutdown() {
        Object object = this.lock;
        synchronized (object) {
            return this.shutdown;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            long timeoutNanos = unit.toNanos(timeout);
            long endTimeNanos = System.nanoTime() + timeoutNanos;
            while (!this.terminated && (timeoutNanos = endTimeNanos - System.nanoTime()) > 0L) {
                TimeUnit.NANOSECONDS.timedWait(this.lock, timeoutNanos);
            }
            return this.terminated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTerminated() {
        Object object = this.lock;
        synchronized (object) {
            return this.terminated;
        }
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> newCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions) {
        return this.interceptorChannel.newCall(method, callOptions);
    }

    @Override
    public String authority() {
        return this.interceptorChannel.authority();
    }

    @GuardedBy(value="lock")
    private void maybeTerminateChannel() {
        if (this.terminated) {
            return;
        }
        if (this.shutdown && this.transports.isEmpty() && this.delayedTransports.isEmpty()) {
            if (log.isLoggable(Level.INFO)) {
                log.log(Level.INFO, "[{0}] Terminated", this.getLogId());
            }
            this.terminated = true;
            this.lock.notifyAll();
            if (this.usingSharedExecutor) {
                SharedResourceHolder.release(GrpcUtil.SHARED_CHANNEL_EXECUTOR, (ExecutorService)this.executor);
            }
            this.transportFactory.close();
        }
    }

    @Override
    public String getLogId() {
        return GrpcUtil.getLogId(this);
    }

    private class InterimTransportImpl
    implements TransportManager.InterimTransport<ClientTransport> {
        private final DelayedClientTransport delayedTransport;
        private boolean closed;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        InterimTransportImpl() {
            boolean savedShutdown;
            this.delayedTransport = new DelayedClientTransport(ManagedChannelImpl.this.executor);
            this.delayedTransport.start(new ManagedClientTransport.Listener(){

                @Override
                public void transportShutdown(Status status) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void transportTerminated() {
                    Object object = ManagedChannelImpl.this.lock;
                    synchronized (object) {
                        ManagedChannelImpl.this.delayedTransports.remove(InterimTransportImpl.this.delayedTransport);
                        ManagedChannelImpl.this.maybeTerminateChannel();
                    }
                }

                @Override
                public void transportReady() {
                }
            });
            Object object = ManagedChannelImpl.this.lock;
            synchronized (object) {
                ManagedChannelImpl.this.delayedTransports.add(this.delayedTransport);
                savedShutdown = ManagedChannelImpl.this.shutdown;
            }
            if (savedShutdown) {
                this.delayedTransport.setTransport(SHUTDOWN_TRANSPORT);
                this.delayedTransport.shutdown();
            }
        }

        @Override
        public ClientTransport transport() {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"already closed");
            return this.delayedTransport;
        }

        @Override
        public void closeWithRealTransports(Supplier<ClientTransport> realTransports) {
            this.delayedTransport.setTransportSupplier(realTransports);
            this.delayedTransport.shutdown();
        }

        @Override
        public void closeWithError(Status error) {
            this.delayedTransport.shutdownNow(error);
        }
    }

    private class RealChannel
    extends Channel {
        private RealChannel() {
        }

        public <ReqT, RespT> ClientCall<ReqT, RespT> newCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions) {
            Executor executor = callOptions.getExecutor();
            if (executor == null) {
                executor = ManagedChannelImpl.this.executor;
            }
            return new ClientCallImpl<ReqT, RespT>(method, executor, callOptions, ManagedChannelImpl.this.transportProvider, ManagedChannelImpl.this.scheduledExecutor).setUserAgent(ManagedChannelImpl.this.userAgent).setDecompressorRegistry(ManagedChannelImpl.this.decompressorRegistry).setCompressorRegistry(ManagedChannelImpl.this.compressorRegistry);
        }

        @Override
        public String authority() {
            String authority = ManagedChannelImpl.this.nameResolver.getServiceAuthority();
            return (String)Preconditions.checkNotNull((Object)authority, (Object)"authority");
        }
    }
}

