/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.internal.AbstractStream2;
import io.grpc.internal.MessageFramer;
import io.grpc.internal.ReadableBuffer;
import io.grpc.internal.ServerStream;
import io.grpc.internal.ServerStreamListener;
import io.grpc.internal.WritableBuffer;
import io.grpc.internal.WritableBufferAllocator;
import javax.annotation.Nullable;

public abstract class AbstractServerStream
extends AbstractStream2
implements ServerStream,
MessageFramer.Sink {
    private final MessageFramer framer;
    private boolean outboundClosed;
    private boolean headersSent;

    protected AbstractServerStream(WritableBufferAllocator bufferAllocator) {
        this.framer = new MessageFramer(this, bufferAllocator);
    }

    @Override
    protected abstract TransportState transportState();

    protected abstract Sink abstractServerStreamSink();

    @Override
    protected final MessageFramer framer() {
        return this.framer;
    }

    @Override
    public final void request(int numMessages) {
        this.abstractServerStreamSink().request(numMessages);
    }

    @Override
    public final void writeHeaders(Metadata headers) {
        Preconditions.checkNotNull((Object)headers, (Object)"headers");
        this.headersSent = true;
        this.abstractServerStreamSink().writeHeaders(headers);
    }

    @Override
    public final void deliverFrame(WritableBuffer frame, boolean endOfStream, boolean flush) {
        this.abstractServerStreamSink().writeFrame(frame, endOfStream ? false : flush);
    }

    @Override
    public final void close(Status status, Metadata trailers) {
        Preconditions.checkNotNull((Object)status, (Object)"status");
        Preconditions.checkNotNull((Object)trailers, (Object)"trailers");
        if (!this.outboundClosed) {
            this.outboundClosed = true;
            this.endOfMessages();
            this.addStatusToTrailers(trailers, status);
            this.abstractServerStreamSink().writeTrailers(trailers, this.headersSent);
        }
    }

    private void addStatusToTrailers(Metadata trailers, Status status) {
        trailers.removeAll(Status.CODE_KEY);
        trailers.removeAll(Status.MESSAGE_KEY);
        trailers.put(Status.CODE_KEY, status);
        if (status.getDescription() != null) {
            trailers.put(Status.MESSAGE_KEY, status.getDescription());
        }
    }

    @Override
    public final void cancel(Status status) {
        this.abstractServerStreamSink().cancel(status);
    }

    @Override
    public Attributes attributes() {
        return Attributes.EMPTY;
    }

    protected static abstract class TransportState
    extends AbstractStream2.TransportState {
        private boolean listenerClosed;
        private ServerStreamListener listener;

        protected TransportState(int maxMessageSize) {
            super(maxMessageSize);
        }

        public final void setListener(ServerStreamListener listener) {
            this.listener = (ServerStreamListener)Preconditions.checkNotNull((Object)listener);
            this.onStreamAllocated();
        }

        @Override
        public void deliveryStalled() {
        }

        @Override
        public void endOfStream() {
            this.closeDeframer();
            this.listener().halfClosed();
        }

        @Override
        protected ServerStreamListener listener() {
            return this.listener;
        }

        public void inboundDataReceived(ReadableBuffer frame, boolean endOfStream) {
            this.deframe(frame, endOfStream);
        }

        public final void transportReportStatus(Status status) {
            Preconditions.checkArgument((!status.isOk() ? 1 : 0) != 0, (Object)"status must not be OK");
            this.closeListener(status);
        }

        public void complete() {
            this.closeListener(Status.OK);
        }

        private void closeListener(Status newStatus) {
            if (!this.listenerClosed) {
                this.listenerClosed = true;
                this.closeDeframer();
                this.listener().closed(newStatus);
            }
        }
    }

    protected static interface Sink {
        public void writeHeaders(Metadata var1);

        public void writeFrame(@Nullable WritableBuffer var1, boolean var2);

        public void writeTrailers(Metadata var1, boolean var2);

        public void request(int var1);

        public void cancel(Status var1);
    }
}

