/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class Metadata {
    public static final String BINARY_HEADER_SUFFIX = "-bin";
    public static final AsciiMarshaller<String> ASCII_STRING_MARSHALLER = new AsciiMarshaller<String>(){

        @Override
        public String toAsciiString(String value) {
            return value;
        }

        @Override
        public String parseAsciiString(String serialized) {
            return serialized;
        }
    };
    public static final AsciiMarshaller<Integer> INTEGER_MARSHALLER = new AsciiMarshaller<Integer>(){

        @Override
        public String toAsciiString(Integer value) {
            return value.toString();
        }

        @Override
        public Integer parseAsciiString(String serialized) {
            return Integer.parseInt(serialized);
        }
    };
    private final ListMultimap<String, MetadataEntry> store = LinkedListMultimap.create();
    private final boolean serializable;

    private Metadata(byte[] ... binaryValues) {
        for (int i = 0; i < binaryValues.length; ++i) {
            String name = new String(binaryValues[i], Charsets.US_ASCII);
            this.store.put((Object)name, (Object)new MetadataEntry(name.endsWith(BINARY_HEADER_SUFFIX), binaryValues[++i]));
        }
        this.serializable = false;
    }

    private Metadata() {
        this.serializable = true;
    }

    public boolean containsKey(Key<?> key) {
        return this.store.containsKey((Object)((Key)key).name);
    }

    public <T> T get(Key<T> key) {
        if (this.containsKey(key)) {
            MetadataEntry metadataEntry = (MetadataEntry)Iterables.getLast((Iterable)this.store.get((Object)key.name()));
            return metadataEntry.getParsed(key);
        }
        return null;
    }

    public <T> Iterable<T> getAll(final Key<T> key) {
        if (this.containsKey(key)) {
            return Iterables.transform((Iterable)this.store.get((Object)key.name()), (Function)new Function<MetadataEntry, T>(){

                public T apply(MetadataEntry entry) {
                    return entry.getParsed(key);
                }
            });
        }
        return null;
    }

    public <T> void put(Key<T> key, T value) {
        this.store.put((Object)key.name(), (Object)new MetadataEntry(key, value));
    }

    public <T> boolean remove(Key<T> key, T value) {
        return this.store.remove((Object)key.name(), value);
    }

    public <T> List<T> removeAll(final Key<T> key) {
        return Lists.transform((List)this.store.removeAll((Object)key.name()), (Function)new Function<MetadataEntry, T>(){

            public T apply(MetadataEntry metadataEntry) {
                return metadataEntry.getParsed(key);
            }
        });
    }

    public boolean isSerializable() {
        return this.serializable;
    }

    public byte[][] serialize() {
        Preconditions.checkState((boolean)this.serializable, (Object)"Can't serialize raw metadata");
        byte[][] serialized = new byte[this.store.size() * 2][];
        int i = 0;
        for (Map.Entry entry : this.store.entries()) {
            serialized[i++] = ((MetadataEntry)entry.getValue()).key.asciiName();
            serialized[i++] = ((MetadataEntry)entry.getValue()).getSerialized();
        }
        return serialized;
    }

    public void merge(Metadata other) {
        Preconditions.checkNotNull((Object)other);
        if (this.serializable && !other.serializable) {
            throw new IllegalArgumentException("Cannot merge non-serializable metadata into serializable metadata without keys");
        }
        this.store.putAll(other.store);
    }

    public void merge(Metadata other, Set<Key<?>> keys) {
        Preconditions.checkNotNull((Object)other);
        for (Key<?> key : keys) {
            if (!other.containsKey(key)) continue;
            Iterable<?> values = other.getAll(key);
            for (Object value : values) {
                this.put(key, value);
            }
        }
    }

    private String toStringInternal() {
        return this.store.toString();
    }

    private static class MetadataEntry {
        Object parsed;
        Key key;
        boolean isBinary;
        byte[] serializedBinary;

        private MetadataEntry(Key<?> key, Object parsed) {
            this.parsed = Preconditions.checkNotNull((Object)parsed);
            this.key = (Key)Preconditions.checkNotNull(key);
            this.isBinary = key instanceof BinaryKey;
        }

        private MetadataEntry(boolean isBinary, byte[] serialized) {
            Preconditions.checkNotNull((Object)serialized);
            this.serializedBinary = serialized;
            this.isBinary = isBinary;
        }

        public <T> T getParsed(Key<T> key) {
            Object value = this.parsed;
            if (value != null) {
                if (this.key != key) {
                    this.serializedBinary = this.key.toBytes(value);
                } else {
                    return (T)value;
                }
            }
            this.key = key;
            if (this.serializedBinary != null) {
                value = key.parseBytes(this.serializedBinary);
            }
            this.parsed = value;
            return (T)value;
        }

        public byte[] getSerialized() {
            this.serializedBinary = this.serializedBinary == null ? this.key.toBytes(this.parsed) : this.serializedBinary;
            return this.serializedBinary;
        }

        public String toString() {
            if (!this.isBinary) {
                return new String(this.getSerialized(), Charsets.US_ASCII);
            }
            if (this.parsed != null) {
                return "" + this.parsed;
            }
            return Arrays.toString(this.serializedBinary);
        }
    }

    private static class AsciiKey<T>
    extends Key<T> {
        private final AsciiMarshaller<T> marshaller;

        private AsciiKey(String name, AsciiMarshaller<T> marshaller) {
            super(name);
            Preconditions.checkArgument((!name.endsWith(Metadata.BINARY_HEADER_SUFFIX) ? 1 : 0) != 0, (Object)("ASCII header is named " + name + ". It must not end with " + Metadata.BINARY_HEADER_SUFFIX));
            this.marshaller = (AsciiMarshaller)Preconditions.checkNotNull(marshaller);
        }

        @Override
        byte[] toBytes(T value) {
            return this.marshaller.toAsciiString(value).getBytes(Charsets.US_ASCII);
        }

        @Override
        T parseBytes(byte[] serialized) {
            return this.marshaller.parseAsciiString(new String(serialized, Charsets.US_ASCII));
        }
    }

    private static class BinaryKey<T>
    extends Key<T> {
        private final BinaryMarshaller<T> marshaller;

        private BinaryKey(String name, BinaryMarshaller<T> marshaller) {
            super(name);
            Preconditions.checkArgument((boolean)name.endsWith(Metadata.BINARY_HEADER_SUFFIX), (Object)("Binary header is named " + name + ". It must end with " + Metadata.BINARY_HEADER_SUFFIX));
            this.marshaller = (BinaryMarshaller)Preconditions.checkNotNull(marshaller);
        }

        @Override
        byte[] toBytes(T value) {
            return this.marshaller.toBytes(value);
        }

        @Override
        T parseBytes(byte[] serialized) {
            return this.marshaller.parseBytes(serialized);
        }
    }

    public static abstract class Key<T> {
        private final String name;
        private final byte[] asciiName;

        public static <T> Key<T> of(String name, BinaryMarshaller<T> marshaller) {
            return new BinaryKey(name, marshaller);
        }

        public static <T> Key<T> of(String name, AsciiMarshaller<T> marshaller) {
            return new AsciiKey(name, marshaller);
        }

        private Key(String name) {
            this.name = ((String)Preconditions.checkNotNull((Object)name, (Object)"name")).toLowerCase().intern();
            this.asciiName = this.name.getBytes(Charsets.US_ASCII);
        }

        public String name() {
            return this.name;
        }

        public byte[] asciiName() {
            return this.asciiName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return !(this.name == null ? key.name != null : !this.name.equals(key.name));
        }

        public int hashCode() {
            return this.name != null ? this.name.hashCode() : 0;
        }

        public String toString() {
            return "Key{name='" + this.name + "'}";
        }

        abstract byte[] toBytes(T var1);

        abstract T parseBytes(byte[] var1);
    }

    public static interface AsciiMarshaller<T> {
        public String toAsciiString(T var1);

        public T parseAsciiString(String var1);
    }

    public static interface BinaryMarshaller<T> {
        public byte[] toBytes(T var1);

        public T parseBytes(byte[] var1);
    }

    public static class Trailers
    extends Metadata {
        public Trailers(byte[] ... headers) {
            super(headers);
        }

        public Trailers() {
        }

        public String toString() {
            return "Trailers(" + ((Metadata)this).toStringInternal() + ")";
        }
    }

    public static class Headers
    extends Metadata {
        private String path;
        private String authority;

        public Headers(byte[] ... headers) {
            super(headers);
        }

        public Headers() {
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getAuthority() {
            return this.authority;
        }

        public void setAuthority(String authority) {
            this.authority = authority;
        }

        @Override
        public void merge(Metadata other) {
            super.merge(other);
            this.mergePathAndAuthority(other);
        }

        @Override
        public void merge(Metadata other, Set<Key<?>> keys) {
            super.merge(other, keys);
            this.mergePathAndAuthority(other);
        }

        private void mergePathAndAuthority(Metadata other) {
            if (other instanceof Headers) {
                Headers otherHeaders = (Headers)other;
                this.path = otherHeaders.path != null ? otherHeaders.path : this.path;
                this.authority = otherHeaders.authority != null ? otherHeaders.authority : this.authority;
            }
        }

        public String toString() {
            return "Headers(path=" + this.path + ",authority=" + this.authority + ",metadata=" + ((Metadata)this).toStringInternal() + ")";
        }
    }
}

