/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import io.grpc.HandlerRegistry;
import io.grpc.Metadata;
import io.grpc.SerializingExecutor;
import io.grpc.ServerCall;
import io.grpc.ServerMethodDefinition;
import io.grpc.Status;
import io.grpc.transport.Server;
import io.grpc.transport.ServerListener;
import io.grpc.transport.ServerStream;
import io.grpc.transport.ServerStreamListener;
import io.grpc.transport.ServerTransport;
import io.grpc.transport.ServerTransportListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public final class ServerImpl
extends io.grpc.Server {
    private static final ServerStreamListener NOOP_LISTENER = new NoopListener();
    private final Executor executor;
    private final HandlerRegistry registry;
    private boolean started;
    private boolean shutdown;
    private boolean terminated;
    private Runnable terminationRunnable;
    private final Server transportServer;
    private final Collection<ServerTransport> transports = new HashSet<ServerTransport>();

    public ServerImpl(Executor executor, HandlerRegistry registry, Server transportServer) {
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor, (Object)"executor");
        this.registry = (HandlerRegistry)Preconditions.checkNotNull((Object)registry, (Object)"registry");
        this.transportServer = (Server)Preconditions.checkNotNull((Object)transportServer, (Object)"transportServer");
    }

    synchronized void setTerminationRunnable(Runnable runnable) {
        this.terminationRunnable = runnable;
    }

    public synchronized ServerImpl start() throws IOException {
        if (this.started) {
            throw new IllegalStateException("Already started");
        }
        this.transportServer.start(new ServerListenerImpl());
        this.started = true;
        return this;
    }

    public synchronized ServerImpl shutdown() {
        if (this.shutdown) {
            return this;
        }
        this.transportServer.shutdown();
        this.shutdown = true;
        return this;
    }

    public synchronized ServerImpl shutdownNow() {
        this.shutdown();
        return this;
    }

    public synchronized boolean isShutdown() {
        return this.shutdown;
    }

    public synchronized boolean awaitTerminated(long timeout, TimeUnit unit) throws InterruptedException {
        long timeoutNanos = unit.toNanos(timeout);
        long endTimeNanos = System.nanoTime() + timeoutNanos;
        while (!this.terminated && (timeoutNanos = endTimeNanos - System.nanoTime()) > 0L) {
            TimeUnit.NANOSECONDS.timedWait(this, timeoutNanos);
        }
        return this.terminated;
    }

    public synchronized void awaitTerminated() throws InterruptedException {
        while (!this.terminated) {
            this.wait();
        }
    }

    public synchronized boolean isTerminated() {
        return this.terminated;
    }

    private synchronized void transportClosed(ServerTransport transport) {
        if (!this.transports.remove(transport)) {
            throw new AssertionError((Object)"Transport already removed");
        }
        this.checkForTermination();
    }

    private synchronized void checkForTermination() {
        if (this.shutdown && this.transports.isEmpty()) {
            this.terminated = true;
            this.notifyAll();
            if (this.terminationRunnable != null) {
                this.terminationRunnable.run();
            }
        }
    }

    private class ServerCallImpl<ReqT, RespT>
    extends ServerCall<RespT> {
        private final ServerStream stream;
        private final ServerMethodDefinition<ReqT, RespT> methodDef;
        private volatile boolean cancelled;

        public ServerCallImpl(ServerStream stream, ServerMethodDefinition<ReqT, RespT> methodDef) {
            this.stream = stream;
            this.methodDef = methodDef;
        }

        @Override
        public void request(int numMessages) {
            this.stream.request(numMessages);
        }

        @Override
        public void sendHeaders(Metadata.Headers headers) {
            this.stream.writeHeaders(headers);
        }

        @Override
        public void sendPayload(RespT payload) {
            try {
                InputStream message = this.methodDef.streamResponse(payload);
                this.stream.writeMessage(message, message.available());
                this.stream.flush();
            }
            catch (Throwable t) {
                this.close(Status.fromThrowable(t), new Metadata.Trailers());
                throw Throwables.propagate((Throwable)t);
            }
        }

        @Override
        public boolean isReady() {
            return this.stream.isReady();
        }

        @Override
        public void close(Status status, Metadata.Trailers trailers) {
            this.stream.close(status, trailers);
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        private ServerStreamListenerImpl newServerStreamListener(ServerCall.Listener<ReqT> listener) {
            return new ServerStreamListenerImpl(listener);
        }

        private class ServerStreamListenerImpl
        implements ServerStreamListener {
            private final ServerCall.Listener<ReqT> listener;

            public ServerStreamListenerImpl(ServerCall.Listener<ReqT> listener) {
                this.listener = (ServerCall.Listener)Preconditions.checkNotNull(listener, (Object)"listener must not be null");
            }

            @Override
            public void messageRead(InputStream message) {
                try {
                    if (ServerCallImpl.this.cancelled) {
                        return;
                    }
                    this.listener.onPayload(ServerCallImpl.this.methodDef.parseRequest(message));
                }
                finally {
                    try {
                        message.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }

            @Override
            public void halfClosed() {
                if (ServerCallImpl.this.cancelled) {
                    return;
                }
                this.listener.onHalfClose();
            }

            @Override
            public void closed(Status status) {
                if (status.isOk()) {
                    this.listener.onComplete();
                } else {
                    ServerCallImpl.this.cancelled = true;
                    this.listener.onCancel();
                }
            }

            @Override
            public void onReady() {
                if (ServerCallImpl.this.cancelled) {
                    return;
                }
                this.listener.onReady();
            }
        }
    }

    private static class JumpToApplicationThreadServerStreamListener
    implements ServerStreamListener {
        private final SerializingExecutor callExecutor;
        private final ServerStream stream;
        private ServerStreamListener listener;

        public JumpToApplicationThreadServerStreamListener(SerializingExecutor executor, ServerStream stream) {
            this.callExecutor = executor;
            this.stream = stream;
        }

        private ServerStreamListener getListener() {
            if (this.listener == null) {
                throw new IllegalStateException("listener unset");
            }
            return this.listener;
        }

        private void setListener(ServerStreamListener listener) {
            Preconditions.checkNotNull((Object)listener, (Object)"listener must not be null");
            Preconditions.checkState((this.listener == null ? 1 : 0) != 0, (Object)"Listener already set");
            this.listener = listener;
        }

        private void internalClose(Status status, Metadata.Trailers trailers) {
            this.stream.close(status, trailers);
        }

        @Override
        public void messageRead(final InputStream message) {
            this.callExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        JumpToApplicationThreadServerStreamListener.this.getListener().messageRead(message);
                    }
                    catch (Throwable t) {
                        JumpToApplicationThreadServerStreamListener.this.internalClose(Status.fromThrowable(t), new Metadata.Trailers());
                        throw Throwables.propagate((Throwable)t);
                    }
                }
            });
        }

        @Override
        public void halfClosed() {
            this.callExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        JumpToApplicationThreadServerStreamListener.this.getListener().halfClosed();
                    }
                    catch (Throwable t) {
                        JumpToApplicationThreadServerStreamListener.this.internalClose(Status.fromThrowable(t), new Metadata.Trailers());
                        throw Throwables.propagate((Throwable)t);
                    }
                }
            });
        }

        @Override
        public void closed(final Status status) {
            this.callExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    JumpToApplicationThreadServerStreamListener.this.getListener().closed(status);
                }
            });
        }

        @Override
        public void onReady() {
            this.callExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    JumpToApplicationThreadServerStreamListener.this.getListener().onReady();
                }
            });
        }
    }

    private static class NoopListener
    implements ServerStreamListener {
        private NoopListener() {
        }

        @Override
        public void messageRead(InputStream value) {
            try {
                value.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void halfClosed() {
        }

        @Override
        public void closed(Status status) {
        }

        @Override
        public void onReady() {
        }
    }

    private class ServerTransportListenerImpl
    implements ServerTransportListener {
        private final ServerTransport transport;

        public ServerTransportListenerImpl(ServerTransport transport) {
            this.transport = transport;
        }

        @Override
        public void transportTerminated() {
            ServerImpl.this.transportClosed(this.transport);
        }

        @Override
        public ServerStreamListener streamCreated(final ServerStream stream, final String methodName, final Metadata.Headers headers) {
            SerializingExecutor serializingExecutor = new SerializingExecutor(ServerImpl.this.executor);
            final JumpToApplicationThreadServerStreamListener jumpListener = new JumpToApplicationThreadServerStreamListener(serializingExecutor, stream);
            serializingExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    ServerStreamListener listener = NOOP_LISTENER;
                    try {
                        HandlerRegistry.Method method = ServerImpl.this.registry.lookupMethod(methodName);
                        if (method == null) {
                            stream.close(Status.UNIMPLEMENTED.withDescription("Method not found: " + methodName), new Metadata.Trailers());
                            return;
                        }
                        listener = ServerTransportListenerImpl.this.startCall(stream, methodName, method.getMethodDefinition(), headers);
                    }
                    catch (Throwable t) {
                        stream.close(Status.fromThrowable(t), new Metadata.Trailers());
                        throw Throwables.propagate((Throwable)t);
                    }
                    finally {
                        jumpListener.setListener(listener);
                    }
                }
            });
            return jumpListener;
        }

        private <ReqT, RespT> ServerStreamListener startCall(ServerStream stream, String fullMethodName, ServerMethodDefinition<ReqT, RespT> methodDef, Metadata.Headers headers) {
            ServerCallImpl<ReqT, RespT> call = new ServerCallImpl<ReqT, RespT>(stream, methodDef);
            ServerCall.Listener<ReqT> listener = methodDef.getServerCallHandler().startCall(fullMethodName, call, headers);
            if (listener == null) {
                throw new NullPointerException("startCall() returned a null listener for method " + fullMethodName);
            }
            return ((ServerCallImpl)call).newServerStreamListener(listener);
        }
    }

    private class ServerListenerImpl
    implements ServerListener {
        private ServerListenerImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ServerTransportListener transportCreated(ServerTransport transport) {
            ServerImpl serverImpl = ServerImpl.this;
            synchronized (serverImpl) {
                ServerImpl.this.transports.add(transport);
            }
            return new ServerTransportListenerImpl(transport);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serverShutdown() {
            ServerImpl serverImpl = ServerImpl.this;
            synchronized (serverImpl) {
                for (ServerTransport transport : ServerImpl.this.transports.toArray(new ServerTransport[ServerImpl.this.transports.size()])) {
                    transport.shutdown();
                }
                ServerImpl.this.checkForTermination();
            }
        }
    }
}

