/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CallOptions {
    public static final CallOptions DEFAULT = new CallOptions();
    private Long deadlineNanoTime;

    public CallOptions withDeadlineNanoTime(@Nullable Long deadlineNanoTime) {
        CallOptions newOptions = new CallOptions(this);
        newOptions.deadlineNanoTime = deadlineNanoTime;
        return newOptions;
    }

    public CallOptions withDeadlineAfter(long duration, TimeUnit unit) {
        return this.withDeadlineNanoTime(System.nanoTime() + unit.toNanos(duration));
    }

    @Nullable
    public Long getDeadlineNanoTime() {
        return this.deadlineNanoTime;
    }

    private CallOptions() {
    }

    private CallOptions(CallOptions other) {
        this.deadlineNanoTime = other.deadlineNanoTime;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[deadlineNanoTime=").append(this.deadlineNanoTime);
        if (this.deadlineNanoTime != null) {
            buffer.append(" (").append(this.deadlineNanoTime - System.nanoTime()).append(" ns from now)");
        }
        buffer.append("]");
        return buffer.toString();
    }
}

