/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import io.grpc.CallOptions;
import io.grpc.ChannelImpl;
import io.grpc.ClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.internal.ClientStream;
import io.grpc.internal.ClientStreamListener;
import io.grpc.internal.ClientTransport;
import io.grpc.internal.HttpUtil;
import io.grpc.internal.SerializingExecutor;
import java.io.InputStream;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

final class ClientCallImpl<ReqT, RespT>
extends ClientCall<ReqT, RespT> {
    private final MethodDescriptor<ReqT, RespT> method;
    private final SerializingExecutor callExecutor;
    private final boolean unaryRequest;
    private final CallOptions callOptions;
    private ClientStream stream;
    private volatile ScheduledFuture<?> deadlineCancellationFuture;
    private boolean cancelCalled;
    private boolean halfCloseCalled;
    private ClientTransportProvider clientTransportProvider;
    private String userAgent;
    private ScheduledExecutorService deadlineCancellationExecutor;

    ClientCallImpl(MethodDescriptor<ReqT, RespT> method, SerializingExecutor executor, CallOptions callOptions, ClientTransportProvider clientTransportProvider, ScheduledExecutorService deadlineCancellationExecutor) {
        this.method = method;
        this.callExecutor = executor;
        this.unaryRequest = method.getType() == MethodDescriptor.MethodType.UNARY || method.getType() == MethodDescriptor.MethodType.SERVER_STREAMING;
        this.callOptions = callOptions;
        this.clientTransportProvider = clientTransportProvider;
        this.deadlineCancellationExecutor = deadlineCancellationExecutor;
    }

    ClientCallImpl<ReqT, RespT> setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    @Override
    public void start(ClientCall.Listener<RespT> observer, Metadata.Headers headers) {
        ClientTransport transport;
        Preconditions.checkState((this.stream == null ? 1 : 0) != 0, (Object)"Already started");
        Long deadlineNanoTime = this.callOptions.getDeadlineNanoTime();
        ClientStreamListenerImpl listener = new ClientStreamListenerImpl(observer, deadlineNanoTime);
        try {
            transport = this.clientTransportProvider.get();
        }
        catch (RuntimeException ex) {
            this.closeCallPrematurely(listener, Status.fromThrowable(ex));
            return;
        }
        if (transport == null) {
            this.closeCallPrematurely(listener, Status.UNAVAILABLE.withDescription("Channel is shutdown"));
            return;
        }
        headers.removeAll(ChannelImpl.TIMEOUT_KEY);
        long timeoutMicros = 0L;
        if (deadlineNanoTime != null) {
            timeoutMicros = TimeUnit.NANOSECONDS.toMicros(deadlineNanoTime - System.nanoTime());
            if (timeoutMicros <= 0L) {
                this.closeCallPrematurely(listener, Status.DEADLINE_EXCEEDED);
                return;
            }
            headers.put(ChannelImpl.TIMEOUT_KEY, timeoutMicros);
        }
        headers.removeAll(HttpUtil.USER_AGENT_KEY);
        if (this.userAgent != null) {
            headers.put(HttpUtil.USER_AGENT_KEY, this.userAgent);
        }
        try {
            this.stream = transport.newStream(this.method, headers, listener);
        }
        catch (IllegalStateException ex) {
            this.closeCallPrematurely(listener, Status.fromThrowable(ex));
        }
        if (deadlineNanoTime != null) {
            this.deadlineCancellationFuture = this.startDeadlineTimer(timeoutMicros);
        }
    }

    @Override
    public void request(int numMessages) {
        Preconditions.checkState((this.stream != null ? 1 : 0) != 0, (Object)"Not started");
        this.stream.request(numMessages);
    }

    @Override
    public void cancel() {
        this.cancelCalled = true;
        if (this.stream != null) {
            this.stream.cancel(Status.CANCELLED);
        }
    }

    @Override
    public void halfClose() {
        Preconditions.checkState((this.stream != null ? 1 : 0) != 0, (Object)"Not started");
        Preconditions.checkState((!this.cancelCalled ? 1 : 0) != 0, (Object)"call was cancelled");
        Preconditions.checkState((!this.halfCloseCalled ? 1 : 0) != 0, (Object)"call already half-closed");
        this.halfCloseCalled = true;
        this.stream.halfClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessage(ReqT message) {
        Preconditions.checkState((this.stream != null ? 1 : 0) != 0, (Object)"Not started");
        Preconditions.checkState((!this.cancelCalled ? 1 : 0) != 0, (Object)"call was cancelled");
        Preconditions.checkState((!this.halfCloseCalled ? 1 : 0) != 0, (Object)"call was half-closed");
        boolean failed = true;
        try {
            InputStream messageIs = this.method.streamRequest(message);
            this.stream.writeMessage(messageIs);
            failed = false;
        }
        finally {
            if (failed) {
                this.cancel();
            }
        }
        if (!this.unaryRequest) {
            this.stream.flush();
        }
    }

    @Override
    public boolean isReady() {
        return this.stream.isReady();
    }

    private void closeCallPrematurely(ClientStreamListener listener, Status status) {
        Preconditions.checkState((this.stream == null ? 1 : 0) != 0, (Object)"Stream already created");
        this.stream = new NoopClientStream();
        listener.closed(status, new Metadata.Trailers());
    }

    private ScheduledFuture<?> startDeadlineTimer(long timeoutMicros) {
        return this.deadlineCancellationExecutor.schedule(new Runnable(){

            @Override
            public void run() {
                ClientCallImpl.this.stream.cancel(Status.DEADLINE_EXCEEDED);
            }
        }, timeoutMicros, TimeUnit.MICROSECONDS);
    }

    static class NoopClientStream
    implements ClientStream {
        NoopClientStream() {
        }

        @Override
        public void writeMessage(InputStream message) {
        }

        @Override
        public void flush() {
        }

        @Override
        public void cancel(Status reason) {
        }

        @Override
        public void halfClose() {
        }

        @Override
        public void request(int numMessages) {
        }

        @Override
        public boolean isReady() {
            return false;
        }
    }

    private class ClientStreamListenerImpl
    implements ClientStreamListener {
        private final ClientCall.Listener<RespT> observer;
        private final Long deadlineNanoTime;
        private boolean closed;

        public ClientStreamListenerImpl(ClientCall.Listener<RespT> observer, Long deadlineNanoTime) {
            Preconditions.checkNotNull(observer);
            this.observer = observer;
            this.deadlineNanoTime = deadlineNanoTime;
        }

        @Override
        public void headersRead(final Metadata.Headers headers) {
            ClientCallImpl.this.callExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (ClientStreamListenerImpl.this.closed) {
                            return;
                        }
                        ClientStreamListenerImpl.this.observer.onHeaders(headers);
                    }
                    catch (Throwable t) {
                        ClientCallImpl.this.cancel();
                        throw Throwables.propagate((Throwable)t);
                    }
                }
            });
        }

        @Override
        public void messageRead(final InputStream message) {
            ClientCallImpl.this.callExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (ClientStreamListenerImpl.this.closed) {
                            return;
                        }
                        try {
                            ClientStreamListenerImpl.this.observer.onMessage(ClientCallImpl.this.method.parseResponse(message));
                        }
                        finally {
                            message.close();
                        }
                    }
                    catch (Throwable t) {
                        ClientCallImpl.this.cancel();
                        throw Throwables.propagate((Throwable)t);
                    }
                }
            });
        }

        @Override
        public void closed(Status status, Metadata.Trailers trailers) {
            if (status.getCode() == Status.Code.CANCELLED && this.deadlineNanoTime != null && this.deadlineNanoTime <= System.nanoTime()) {
                status = Status.DEADLINE_EXCEEDED;
                trailers = new Metadata.Trailers();
            }
            final Status savedStatus = status;
            final Metadata.Trailers savedTrailers = trailers;
            ClientCallImpl.this.callExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    ClientStreamListenerImpl.this.closed = true;
                    ScheduledFuture future = ClientCallImpl.this.deadlineCancellationFuture;
                    if (future != null) {
                        future.cancel(false);
                    }
                    ClientStreamListenerImpl.this.observer.onClose(savedStatus, savedTrailers);
                }
            });
        }

        @Override
        public void onReady() {
            ClientCallImpl.this.callExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    ClientStreamListenerImpl.this.observer.onReady();
                }
            });
        }
    }

    static interface ClientTransportProvider {
        public ClientTransport get();
    }
}

