/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCallHandler;
import io.grpc.ServerMethodDefinition;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class ServerServiceDefinition {
    private final String name;
    private final ImmutableMap<String, ServerMethodDefinition<?, ?>> methods;

    public static Builder builder(String serviceName) {
        return new Builder(serviceName);
    }

    private ServerServiceDefinition(String name, Map<String, ServerMethodDefinition<?, ?>> methods) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.methods = ImmutableMap.copyOf(methods);
    }

    public String getName() {
        return this.name;
    }

    public Collection<ServerMethodDefinition<?, ?>> getMethods() {
        return this.methods.values();
    }

    ServerMethodDefinition<?, ?> getMethod(String name) {
        return (ServerMethodDefinition)this.methods.get((Object)name);
    }

    public static final class Builder {
        private final String serviceName;
        private final Map<String, ServerMethodDefinition<?, ?>> methods = new HashMap();

        private Builder(String serviceName) {
            this.serviceName = serviceName;
        }

        public <ReqT, RespT> Builder addMethod(MethodDescriptor<ReqT, RespT> method, ServerCallHandler<ReqT, RespT> handler) {
            Preconditions.checkArgument((boolean)this.serviceName.equals(MethodDescriptor.extractFullServiceName(method.getFullMethodName())), (String)"Service name mismatch. Expected service name: '%s'. Actual method name: '%s'.", (Object[])new Object[]{this.serviceName, method.getFullMethodName()});
            return this.addMethod(new ServerMethodDefinition((MethodDescriptor)Preconditions.checkNotNull(method, (Object)"method must not be null"), (ServerCallHandler)Preconditions.checkNotNull(handler, (Object)"handler must not be null")));
        }

        public <ReqT, RespT> Builder addMethod(ServerMethodDefinition<ReqT, RespT> def) {
            String name = def.getMethodDescriptor().getFullMethodName();
            Preconditions.checkState((!this.methods.containsKey(name) ? 1 : 0) != 0, (String)"Method by same name already registered: %s", (Object[])new Object[]{name});
            this.methods.put(name, def);
            return this;
        }

        public ServerServiceDefinition build() {
            return new ServerServiceDefinition(this.serviceName, this.methods);
        }
    }
}

