/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import io.grpc.Metadata;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Status {
    private static List<Status> STATUS_LIST;
    public static final Status OK;
    public static final Status CANCELLED;
    public static final Status UNKNOWN;
    public static final Status INVALID_ARGUMENT;
    public static final Status DEADLINE_EXCEEDED;
    public static final Status NOT_FOUND;
    public static final Status ALREADY_EXISTS;
    public static final Status PERMISSION_DENIED;
    public static final Status UNAUTHENTICATED;
    public static final Status RESOURCE_EXHAUSTED;
    public static final Status FAILED_PRECONDITION;
    public static final Status ABORTED;
    public static final Status OUT_OF_RANGE;
    public static final Status UNIMPLEMENTED;
    public static final Status INTERNAL;
    public static final Status UNAVAILABLE;
    public static final Status DATA_LOSS;
    public static final Metadata.Key<Status> CODE_KEY;
    public static final Metadata.Key<String> MESSAGE_KEY;
    private final Code code;
    private final String description;
    private final Throwable cause;

    public static Status fromCodeValue(int codeValue) {
        if (codeValue < 0 || codeValue > STATUS_LIST.size()) {
            return UNKNOWN.withDescription("Unknown code " + codeValue);
        }
        return STATUS_LIST.get(codeValue);
    }

    public static Status fromThrowable(Throwable t) {
        for (Throwable cause : Throwables.getCausalChain((Throwable)t)) {
            if (cause instanceof StatusException) {
                return ((StatusException)cause).getStatus();
            }
            if (!(cause instanceof StatusRuntimeException)) continue;
            return ((StatusRuntimeException)cause).getStatus();
        }
        return UNKNOWN.withCause(t);
    }

    static String formatThrowableMessage(Status status) {
        if (status.description == null) {
            return status.code.toString();
        }
        return (Object)((Object)status.code) + ": " + status.description;
    }

    private Status(Code code) {
        this(code, null, null);
    }

    private Status(Code code, @Nullable String description, @Nullable Throwable cause) {
        this.code = (Code)((Object)Preconditions.checkNotNull((Object)((Object)code)));
        this.description = description;
        this.cause = cause;
    }

    public Status withCause(Throwable cause) {
        if (Objects.equal((Object)this.cause, (Object)cause)) {
            return this;
        }
        return new Status(this.code, this.description, cause);
    }

    public Status withDescription(String description) {
        if (Objects.equal((Object)this.description, (Object)description)) {
            return this;
        }
        return new Status(this.code, description, this.cause);
    }

    public Status augmentDescription(String additionalDetail) {
        if (additionalDetail == null) {
            return this;
        }
        if (this.description == null) {
            return new Status(this.code, additionalDetail, this.cause);
        }
        return new Status(this.code, this.description + "\n" + additionalDetail, this.cause);
    }

    public Code getCode() {
        return this.code;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public Throwable getCause() {
        return this.cause;
    }

    public boolean isOk() {
        return Code.OK == this.code;
    }

    public StatusRuntimeException asRuntimeException() {
        return new StatusRuntimeException(this);
    }

    public StatusException asException() {
        return new StatusException(this);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("code", (Object)this.code.name()).add("description", (Object)this.description).add("cause", (Object)this.cause).toString();
    }

    static {
        TreeMap<Integer, Status> canonicalizer = new TreeMap<Integer, Status>();
        for (Code code : Code.values()) {
            Status replaced = canonicalizer.put(code.value(), new Status(code));
            if (replaced == null) continue;
            throw new IllegalStateException("Code value duplication between " + replaced.getCode().name() + " & " + code.name());
        }
        STATUS_LIST = new ArrayList(canonicalizer.values());
        OK = Code.OK.status();
        CANCELLED = Code.CANCELLED.status();
        UNKNOWN = Code.UNKNOWN.status();
        INVALID_ARGUMENT = Code.INVALID_ARGUMENT.status();
        DEADLINE_EXCEEDED = Code.DEADLINE_EXCEEDED.status();
        NOT_FOUND = Code.NOT_FOUND.status();
        ALREADY_EXISTS = Code.ALREADY_EXISTS.status();
        PERMISSION_DENIED = Code.PERMISSION_DENIED.status();
        UNAUTHENTICATED = Code.UNAUTHENTICATED.status();
        RESOURCE_EXHAUSTED = Code.RESOURCE_EXHAUSTED.status();
        FAILED_PRECONDITION = Code.FAILED_PRECONDITION.status();
        ABORTED = Code.ABORTED.status();
        OUT_OF_RANGE = Code.OUT_OF_RANGE.status();
        UNIMPLEMENTED = Code.UNIMPLEMENTED.status();
        INTERNAL = Code.INTERNAL.status();
        UNAVAILABLE = Code.UNAVAILABLE.status();
        DATA_LOSS = Code.DATA_LOSS.status();
        CODE_KEY = Metadata.Key.of("grpc-status", new StatusCodeMarshaller());
        MESSAGE_KEY = Metadata.Key.of("grpc-message", Metadata.ASCII_STRING_MARSHALLER);
    }

    private static class StatusCodeMarshaller
    implements Metadata.AsciiMarshaller<Status> {
        private StatusCodeMarshaller() {
        }

        @Override
        public String toAsciiString(Status status) {
            return status.getCode().valueAscii();
        }

        @Override
        public Status parseAsciiString(String serialized) {
            return Status.fromCodeValue(Integer.valueOf(serialized));
        }
    }

    public static enum Code {
        OK(0),
        CANCELLED(1),
        UNKNOWN(2),
        INVALID_ARGUMENT(3),
        DEADLINE_EXCEEDED(4),
        NOT_FOUND(5),
        ALREADY_EXISTS(6),
        PERMISSION_DENIED(7),
        RESOURCE_EXHAUSTED(8),
        FAILED_PRECONDITION(9),
        ABORTED(10),
        OUT_OF_RANGE(11),
        UNIMPLEMENTED(12),
        INTERNAL(13),
        UNAVAILABLE(14),
        DATA_LOSS(15),
        UNAUTHENTICATED(16);

        private final int value;
        private final String valueAscii;

        private Code(int value) {
            this.value = value;
            this.valueAscii = Integer.toString(value);
        }

        public int value() {
            return this.value;
        }

        private Status status() {
            return (Status)STATUS_LIST.get(this.value);
        }

        private String valueAscii() {
            return this.valueAscii;
        }
    }
}

