/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.inprocess;

import com.google.common.base.Preconditions;
import io.grpc.AbstractChannelBuilder;
import io.grpc.inprocess.InProcessTransport;
import io.grpc.internal.ClientTransport;
import io.grpc.internal.ClientTransportFactory;

public class InProcessChannelBuilder
extends AbstractChannelBuilder<InProcessChannelBuilder> {
    private final String name;

    public static InProcessChannelBuilder forName(String name) {
        return new InProcessChannelBuilder(name);
    }

    private InProcessChannelBuilder(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
    }

    @Override
    protected AbstractChannelBuilder.ChannelEssentials buildEssentials() {
        final String name = this.name;
        ClientTransportFactory transportFactory = new ClientTransportFactory(){

            @Override
            public ClientTransport newClientTransport() {
                return new InProcessTransport(name);
            }
        };
        return new AbstractChannelBuilder.ChannelEssentials(transportFactory, null);
    }
}

