/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import io.grpc.Codec;
import io.grpc.Compressor;
import io.grpc.Drainable;
import io.grpc.KnownLength;
import io.grpc.internal.WritableBuffer;
import io.grpc.internal.WritableBufferAllocator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class MessageFramer {
    private static final int HEADER_LENGTH = 5;
    private static final byte UNCOMPRESSED = 0;
    private static final byte COMPRESSED = 1;
    private final Sink sink;
    private WritableBuffer buffer;
    private Compressor compressor;
    private final OutputStreamAdapter outputStreamAdapter = new OutputStreamAdapter();
    private final byte[] headerScratch = new byte[5];
    private final WritableBufferAllocator bufferAllocator;
    private boolean closed;

    public MessageFramer(Sink sink, WritableBufferAllocator bufferAllocator) {
        this(sink, bufferAllocator, Codec.Identity.NONE);
    }

    public MessageFramer(Sink sink, WritableBufferAllocator bufferAllocator, Compressor compressor) {
        this.sink = (Sink)Preconditions.checkNotNull((Object)sink, (Object)"sink");
        this.bufferAllocator = bufferAllocator;
        this.compressor = (Compressor)Preconditions.checkNotNull((Object)compressor, (Object)"compressor");
    }

    public void setCompressor(Compressor compressor) {
        this.compressor = (Compressor)Preconditions.checkNotNull((Object)compressor, (Object)"Can't pass an empty compressor");
    }

    public void writePayload(InputStream message) {
        this.verifyNotClosed();
        try {
            if (this.compressor != Codec.Identity.NONE) {
                this.writeCompressed(message);
            } else {
                this.writeUncompressed(message);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void writeUncompressed(InputStream message) throws IOException {
        int messageLength = this.getKnownLength(message);
        if (messageLength != -1) {
            this.writeKnownLength(message, messageLength, false);
        } else {
            BufferChainOutputStream bufferChain = new BufferChainOutputStream();
            MessageFramer.writeToOutputStream(message, bufferChain);
            this.writeBufferChain(bufferChain, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCompressed(InputStream message) throws IOException {
        BufferChainOutputStream bufferChain = new BufferChainOutputStream();
        int messageLength = -1;
        if (message instanceof KnownLength) {
            messageLength = message.available();
        }
        OutputStream compressingStream = this.compressor.compress(bufferChain);
        try {
            long written = MessageFramer.writeToOutputStream(message, compressingStream);
            if (messageLength != -1 && (long)messageLength != written) {
                throw new RuntimeException("Message length was inaccurate");
            }
        }
        finally {
            compressingStream.close();
        }
        this.writeBufferChain(bufferChain, true);
    }

    private int getKnownLength(InputStream inputStream) throws IOException {
        if (inputStream instanceof KnownLength || inputStream instanceof ByteArrayInputStream) {
            return inputStream.available();
        }
        return -1;
    }

    private void writeKnownLength(InputStream message, int messageLength, boolean compressed) throws IOException {
        ByteBuffer header = ByteBuffer.wrap(this.headerScratch);
        header.put(compressed ? (byte)1 : 0);
        header.putInt(messageLength);
        if (this.buffer == null) {
            this.buffer = this.bufferAllocator.allocate(header.position() + messageLength);
        }
        this.writeRaw(this.headerScratch, 0, header.position());
        long written = MessageFramer.writeToOutputStream(message, this.outputStreamAdapter);
        if ((long)messageLength != written) {
            throw new RuntimeException("Message length was inaccurate");
        }
    }

    private void writeBufferChain(BufferChainOutputStream bufferChain, boolean compressed) {
        ByteBuffer header = ByteBuffer.wrap(this.headerScratch);
        header.put(compressed ? (byte)1 : 0);
        int messageLength = bufferChain.readableBytes();
        header.putInt(messageLength);
        WritableBuffer writeableHeader = this.bufferAllocator.allocate(5);
        writeableHeader.write(this.headerScratch, 0, header.position());
        if (messageLength == 0) {
            this.buffer = writeableHeader;
            return;
        }
        this.sink.deliverFrame(writeableHeader, false, false);
        List bufferList = bufferChain.bufferList;
        for (int i = 0; i < bufferList.size() - 1; ++i) {
            this.sink.deliverFrame((WritableBuffer)bufferList.get(i), false, false);
        }
        this.buffer = (WritableBuffer)bufferList.get(bufferList.size() - 1);
    }

    private static long writeToOutputStream(InputStream message, OutputStream outputStream) throws IOException {
        if (message instanceof Drainable) {
            return ((Drainable)((Object)message)).drainTo(outputStream);
        }
        return ByteStreams.copy((InputStream)message, (OutputStream)outputStream);
    }

    private void writeRaw(byte[] b, int off, int len) {
        while (len > 0) {
            if (this.buffer != null && this.buffer.writableBytes() == 0) {
                this.commitToSink(false, false);
            }
            if (this.buffer == null) {
                this.buffer = this.bufferAllocator.allocate(len);
            }
            int toWrite = Math.min(len, this.buffer.writableBytes());
            this.buffer.write(b, off, toWrite);
            off += toWrite;
            len -= toWrite;
        }
    }

    public void flush() {
        if (this.buffer != null && this.buffer.readableBytes() > 0) {
            this.commitToSink(false, true);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        if (!this.isClosed()) {
            this.closed = true;
            if (this.buffer != null && this.buffer.readableBytes() == 0) {
                this.buffer.release();
                this.buffer = null;
            }
            this.commitToSink(true, true);
        }
    }

    public void dispose() {
        this.closed = true;
        if (this.buffer != null) {
            this.buffer.release();
            this.buffer = null;
        }
    }

    private void commitToSink(boolean endOfStream, boolean flush) {
        this.sink.deliverFrame(this.buffer, endOfStream, flush);
        this.buffer = null;
    }

    private void verifyNotClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException("Framer already closed");
        }
    }

    private class BufferChainOutputStream
    extends OutputStream {
        private final byte[] singleByte = new byte[1];
        private List<WritableBuffer> bufferList = new ArrayList<WritableBuffer>();
        private WritableBuffer current;

        private BufferChainOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            this.singleByte[0] = (byte)b;
            this.write(this.singleByte, 0, 1);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.current == null) {
                this.current = MessageFramer.this.bufferAllocator.allocate(len);
                this.bufferList.add(this.current);
            }
            while (len > 0) {
                int canWrite = Math.min(len, this.current.writableBytes());
                if (canWrite == 0) {
                    this.current = MessageFramer.this.bufferAllocator.allocate(this.current.readableBytes() * 2);
                    this.bufferList.add(this.current);
                    continue;
                }
                this.current.write(b, off, canWrite);
                off += canWrite;
                len -= canWrite;
            }
        }

        private int readableBytes() {
            int readable = 0;
            for (WritableBuffer writableBuffer : this.bufferList) {
                readable += writableBuffer.readableBytes();
            }
            return readable;
        }
    }

    private class OutputStreamAdapter
    extends OutputStream {
        private final byte[] singleByte = new byte[1];

        private OutputStreamAdapter() {
        }

        @Override
        public void write(int b) {
            this.singleByte[0] = (byte)b;
            this.write(this.singleByte, 0, 1);
        }

        @Override
        public void write(byte[] b, int off, int len) {
            MessageFramer.this.writeRaw(b, off, len);
        }
    }

    public static interface Sink {
        public void deliverFrame(WritableBuffer var1, boolean var2, boolean var3);
    }
}

