/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.internal.AbstractStream;
import io.grpc.internal.ClientStream;
import io.grpc.internal.ClientStreamListener;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.ReadableBuffer;
import io.grpc.internal.ReadableBuffers;
import io.grpc.internal.WritableBuffer;
import io.grpc.internal.WritableBufferAllocator;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractClientStream<IdT>
extends AbstractStream<IdT>
implements ClientStream {
    private static final Logger log = Logger.getLogger(AbstractClientStream.class.getName());
    private final ClientStreamListener listener;
    private boolean listenerClosed;
    private Status status;
    private Metadata trailers;
    private Runnable closeListenerTask;

    protected AbstractClientStream(WritableBufferAllocator bufferAllocator, ClientStreamListener listener, int maxMessageSize) {
        super(bufferAllocator, maxMessageSize);
        this.listener = (ClientStreamListener)Preconditions.checkNotNull((Object)listener);
    }

    @Override
    protected final ClientStreamListener listener() {
        return this.listener;
    }

    @Override
    protected void receiveMessage(InputStream is) {
        if (!this.listenerClosed) {
            this.listener.messageRead(is);
        }
    }

    protected void inboundTransportError(Status errorStatus) {
        if (this.inboundPhase() == AbstractStream.Phase.STATUS) {
            log.log(Level.INFO, "Received transport error on closed stream {0} {1}", new Object[]{this.id(), errorStatus});
            return;
        }
        this.transportReportStatus(errorStatus, false, new Metadata());
    }

    protected void inboundHeadersReceived(Metadata headers) {
        if (this.inboundPhase() == AbstractStream.Phase.STATUS) {
            log.log(Level.INFO, "Received headers on closed stream {0} {1}", new Object[]{this.id(), headers});
        }
        if (headers.containsKey(GrpcUtil.MESSAGE_ENCODING_KEY)) {
            String messageEncoding = headers.get(GrpcUtil.MESSAGE_ENCODING_KEY);
            try {
                this.setDecompressor(messageEncoding);
            }
            catch (IllegalArgumentException e) {
                Status status = Status.INTERNAL.withDescription("Unable to decompress message from server.").withCause(e);
                this.inboundTransportError(status);
                this.sendCancel(status);
                return;
            }
        }
        this.inboundPhase(AbstractStream.Phase.MESSAGE);
        this.listener.headersRead(headers);
    }

    protected void inboundDataReceived(ReadableBuffer frame) {
        Preconditions.checkNotNull((Object)frame, (Object)"frame");
        boolean needToCloseFrame = true;
        try {
            if (this.inboundPhase() == AbstractStream.Phase.STATUS) {
                return;
            }
            if (this.inboundPhase() == AbstractStream.Phase.HEADERS) {
                this.inboundTransportError(Status.INTERNAL.withDescription("headers not received before payload"));
                return;
            }
            this.inboundPhase(AbstractStream.Phase.MESSAGE);
            needToCloseFrame = false;
            this.deframe(frame, false);
        }
        finally {
            if (needToCloseFrame) {
                frame.close();
            }
        }
    }

    @Override
    protected void inboundDeliveryPaused() {
        this.runCloseListenerTask();
    }

    @Override
    protected final void deframeFailed(Throwable cause) {
        this.cancel(Status.INTERNAL.withDescription("Exception deframing message").withCause(cause));
    }

    protected void inboundTrailersReceived(Metadata trailers, Status status) {
        Preconditions.checkNotNull((Object)trailers, (Object)"trailers");
        if (this.inboundPhase() == AbstractStream.Phase.STATUS) {
            log.log(Level.INFO, "Received trailers on closed stream {0}\n {1}\n {2}", new Object[]{this.id(), status, trailers});
        }
        this.status = status;
        this.trailers = trailers;
        this.deframe(ReadableBuffers.empty(), true);
    }

    @Override
    protected void remoteEndClosed() {
        this.transportReportStatus(this.status, true, this.trailers);
    }

    @Override
    protected final void internalSendFrame(WritableBuffer frame, boolean endOfStream, boolean flush) {
        Preconditions.checkArgument((frame != null || endOfStream ? 1 : 0) != 0, (Object)"null frame before EOS");
        this.sendFrame(frame, endOfStream, flush);
    }

    protected abstract void sendFrame(WritableBuffer var1, boolean var2, boolean var3);

    public void transportReportStatus(Status newStatus, boolean stopDelivery, Metadata trailers) {
        boolean closingLater;
        Preconditions.checkNotNull((Object)newStatus, (Object)"newStatus");
        boolean bl = closingLater = this.closeListenerTask != null && !stopDelivery;
        if (this.listenerClosed || closingLater) {
            return;
        }
        this.inboundPhase(AbstractStream.Phase.STATUS);
        this.status = newStatus;
        this.closeListenerTask = null;
        boolean deliveryStalled = this.isDeframerStalled();
        if (stopDelivery || deliveryStalled) {
            this.closeListener(newStatus, trailers);
        } else {
            this.closeListenerTask = this.newCloseListenerTask(newStatus, trailers);
        }
    }

    private Runnable newCloseListenerTask(final Status status, final Metadata trailers) {
        return new Runnable(){

            @Override
            public void run() {
                AbstractClientStream.this.closeListener(status, trailers);
            }
        };
    }

    private void closeListener(Status newStatus, Metadata trailers) {
        if (!this.listenerClosed) {
            this.listenerClosed = true;
            this.closeDeframer();
            this.listener.closed(newStatus, trailers);
        }
    }

    private void runCloseListenerTask() {
        if (this.closeListenerTask != null) {
            this.closeListenerTask.run();
            this.closeListenerTask = null;
        }
    }

    @Override
    public final void halfClose() {
        if (this.outboundPhase(AbstractStream.Phase.STATUS) != AbstractStream.Phase.STATUS) {
            this.closeFramer();
        }
    }

    @Override
    public final void cancel(Status reason) {
        Preconditions.checkArgument((boolean)GrpcUtil.CANCEL_REASONS.contains((Object)reason.getCode()), (Object)"Invalid cancellation reason");
        this.outboundPhase(AbstractStream.Phase.STATUS);
        this.sendCancel(reason);
        this.dispose();
    }

    protected abstract void sendCancel(Status var1);

    @Override
    protected Objects.ToStringHelper toStringHelper() {
        Objects.ToStringHelper toStringHelper = super.toStringHelper();
        if (this.status != null) {
            toStringHelper.add("status", (Object)this.status);
        }
        return toStringHelper;
    }

    @Override
    public boolean isClosed() {
        return super.isClosed() || this.listenerClosed;
    }
}

