/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.util;

import com.google.common.base.Supplier;
import io.grpc.Attributes;
import io.grpc.LoadBalancer;
import io.grpc.ResolvedServerInfo;
import io.grpc.Status;
import io.grpc.TransportManager;
import io.grpc.internal.RoundRobinServerList;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;

public final class RoundRobinLoadBalancerFactory
extends LoadBalancer.Factory {
    private static final RoundRobinLoadBalancerFactory instance = new RoundRobinLoadBalancerFactory();

    private RoundRobinLoadBalancerFactory() {
    }

    public static RoundRobinLoadBalancerFactory getInstance() {
        return instance;
    }

    @Override
    public <T> LoadBalancer<T> newLoadBalancer(String serviceName, TransportManager<T> tm) {
        return new RoundRobinLoadBalancer(tm);
    }

    private static class RoundRobinLoadBalancer<T>
    extends LoadBalancer<T> {
        private static final Status SHUTDOWN_STATUS = Status.UNAVAILABLE.augmentDescription("RoundRobinLoadBalancer has shut down");
        private final Object lock = new Object();
        @GuardedBy(value="lock")
        private RoundRobinServerList<T> addresses;
        @GuardedBy(value="lock")
        private TransportManager.InterimTransport<T> interimTransport;
        @GuardedBy(value="lock")
        private Status nameResolutionError;
        @GuardedBy(value="lock")
        private boolean closed;
        private final TransportManager<T> tm;

        private RoundRobinLoadBalancer(TransportManager<T> tm) {
            this.tm = tm;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T pickTransport(Attributes affinity) {
            RoundRobinServerList<T> addressesCopy;
            Object object = this.lock;
            synchronized (object) {
                if (this.closed) {
                    return this.tm.createFailingTransport(SHUTDOWN_STATUS);
                }
                if (this.addresses == null) {
                    if (this.nameResolutionError != null) {
                        return this.tm.createFailingTransport(this.nameResolutionError);
                    }
                    if (this.interimTransport == null) {
                        this.interimTransport = this.tm.createInterimTransport();
                    }
                    return this.interimTransport.transport();
                }
                addressesCopy = this.addresses;
            }
            return addressesCopy.getTransportForNextServer();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleResolvedAddresses(List<? extends List<ResolvedServerInfo>> updatedServers, Attributes config) {
            TransportManager.InterimTransport<T> savedInterimTransport;
            RoundRobinServerList<T> addressesCopy;
            Object object = this.lock;
            synchronized (object) {
                if (this.closed) {
                    return;
                }
                RoundRobinServerList.Builder<T> listBuilder = new RoundRobinServerList.Builder<T>(this.tm);
                for (List<ResolvedServerInfo> list : updatedServers) {
                    if (list.isEmpty()) continue;
                    ArrayList<SocketAddress> socketAddresses = new ArrayList<SocketAddress>(list.size());
                    for (ResolvedServerInfo server : list) {
                        socketAddresses.add(server.getAddress());
                    }
                    listBuilder.addList(socketAddresses);
                }
                addressesCopy = this.addresses = listBuilder.build();
                this.nameResolutionError = null;
                savedInterimTransport = this.interimTransport;
                this.interimTransport = null;
            }
            if (savedInterimTransport != null) {
                savedInterimTransport.closeWithRealTransports(new Supplier<T>(){

                    public T get() {
                        return addressesCopy.getTransportForNextServer();
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleNameResolutionError(Status error) {
            TransportManager.InterimTransport<T> savedInterimTransport;
            Object object = this.lock;
            synchronized (object) {
                if (this.closed) {
                    return;
                }
                error = error.augmentDescription("Name resolution failed");
                savedInterimTransport = this.interimTransport;
                this.interimTransport = null;
                this.nameResolutionError = error;
            }
            if (savedInterimTransport != null) {
                savedInterimTransport.closeWithError(error);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void shutdown() {
            TransportManager.InterimTransport<T> savedInterimTransport;
            Object object = this.lock;
            synchronized (object) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                savedInterimTransport = this.interimTransport;
                this.interimTransport = null;
            }
            if (savedInterimTransport != null) {
                savedInterimTransport.closeWithError(SHUTDOWN_STATUS);
            }
        }
    }
}

