/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.base.MoreObjects;
import com.google.common.util.concurrent.MoreExecutors;
import io.grpc.BindableService;
import io.grpc.CompressorRegistry;
import io.grpc.Context;
import io.grpc.DecompressorRegistry;
import io.grpc.HandlerRegistry;
import io.grpc.ServerBuilder;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import io.grpc.internal.InternalHandlerRegistry;
import io.grpc.internal.InternalServer;
import io.grpc.internal.ServerImpl;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

public abstract class AbstractServerImplBuilder<T extends AbstractServerImplBuilder<T>>
extends ServerBuilder<T> {
    private static final HandlerRegistry EMPTY_FALLBACK_REGISTRY = new HandlerRegistry(){

        @Override
        public ServerMethodDefinition<?, ?> lookupMethod(String methodName, @Nullable String authority) {
            return null;
        }
    };
    private final InternalHandlerRegistry.Builder registryBuilder = new InternalHandlerRegistry.Builder();
    @Nullable
    private HandlerRegistry fallbackRegistry;
    @Nullable
    private Executor executor;
    @Nullable
    private DecompressorRegistry decompressorRegistry;
    @Nullable
    private CompressorRegistry compressorRegistry;

    @Override
    public final T directExecutor() {
        return (T)this.executor(MoreExecutors.directExecutor());
    }

    @Override
    public final T executor(@Nullable Executor executor) {
        this.executor = executor;
        return this.thisT();
    }

    @Override
    public final T addService(ServerServiceDefinition service) {
        this.registryBuilder.addService(service);
        return this.thisT();
    }

    @Override
    public final T addService(BindableService bindableService) {
        return (T)this.addService(bindableService.bindService());
    }

    @Override
    public final T fallbackHandlerRegistry(HandlerRegistry registry) {
        this.fallbackRegistry = registry;
        return this.thisT();
    }

    @Override
    public final T decompressorRegistry(DecompressorRegistry registry) {
        this.decompressorRegistry = registry;
        return this.thisT();
    }

    @Override
    public final T compressorRegistry(CompressorRegistry registry) {
        this.compressorRegistry = registry;
        return this.thisT();
    }

    @Override
    public ServerImpl build() {
        InternalServer transportServer = this.buildTransportServer();
        return new ServerImpl(this.executor, this.registryBuilder.build(), (HandlerRegistry)MoreObjects.firstNonNull((Object)this.fallbackRegistry, (Object)EMPTY_FALLBACK_REGISTRY), transportServer, Context.ROOT, (DecompressorRegistry)MoreObjects.firstNonNull((Object)this.decompressorRegistry, (Object)DecompressorRegistry.getDefaultInstance()), (CompressorRegistry)MoreObjects.firstNonNull((Object)this.compressorRegistry, (Object)CompressorRegistry.getDefaultInstance()));
    }

    protected abstract InternalServer buildTransportServer();

    private T thisT() {
        AbstractServerImplBuilder thisT = this;
        return (T)thisT;
    }
}

