/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import java.util.HashSet;
import javax.annotation.CheckReturnValue;
import javax.annotation.concurrent.GuardedBy;

abstract class InUseStateAggregator<T> {
    @GuardedBy(value="getLock()")
    private final HashSet<T> inUseObjects = new HashSet();

    InUseStateAggregator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckReturnValue
    final Runnable updateObjectInUse(T object, boolean inUse) {
        Runnable runnable = null;
        Object object2 = this.getLock();
        synchronized (object2) {
            int origSize = this.inUseObjects.size();
            if (inUse) {
                this.inUseObjects.add(object);
                if (origSize == 0) {
                    runnable = this.handleInUse();
                }
            } else {
                boolean removed = this.inUseObjects.remove(object);
                if (removed && origSize == 1) {
                    this.handleNotInUse();
                }
            }
        }
        return runnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckReturnValue
    final boolean isInUse() {
        Object object = this.getLock();
        synchronized (object) {
            return !this.inUseObjects.isEmpty();
        }
    }

    abstract Object getLock();

    @GuardedBy(value="getLock()")
    abstract Runnable handleInUse();

    @GuardedBy(value="getLock()")
    abstract void handleNotInUse();
}

