/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.instrumentation.stats.Stats;
import com.google.instrumentation.stats.StatsContextFactory;
import io.grpc.Attributes;
import io.grpc.ClientInterceptor;
import io.grpc.CompressorRegistry;
import io.grpc.DecompressorRegistry;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancer2;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.NameResolver;
import io.grpc.NameResolverProvider;
import io.grpc.PickFirstBalancerFactory;
import io.grpc.ResolvedServerInfo;
import io.grpc.ResolvedServerInfoGroup;
import io.grpc.internal.ClientTransportFactory;
import io.grpc.internal.ConnectionClientTransport;
import io.grpc.internal.ExponentialBackoffPolicy;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.ManagedChannelImpl;
import io.grpc.internal.ManagedChannelImpl2;
import io.grpc.internal.NoopStatsContextFactory;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.SharedResourcePool;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public abstract class AbstractManagedChannelImplBuilder<T extends AbstractManagedChannelImplBuilder<T>>
extends ManagedChannelBuilder<T> {
    private static final String DIRECT_ADDRESS_SCHEME = "directaddress";
    @VisibleForTesting
    static final long IDLE_MODE_MAX_TIMEOUT_DAYS = 30L;
    @VisibleForTesting
    static final long IDLE_MODE_DEFAULT_TIMEOUT_MILLIS = TimeUnit.MINUTES.toMillis(30L);
    @VisibleForTesting
    static final long IDLE_MODE_MIN_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(1L);
    @Nullable
    private Executor executor;
    private final List<ClientInterceptor> interceptors = new ArrayList<ClientInterceptor>();
    private final String target;
    @Nullable
    private final SocketAddress directServerAddress;
    @Nullable
    private String userAgent;
    @Nullable
    private String authorityOverride;
    @Nullable
    private NameResolver.Factory nameResolverFactory;
    private LoadBalancer.Factory loadBalancerFactory;
    @Nullable
    private ChannelFactory channelFactory;
    @Nullable
    private DecompressorRegistry decompressorRegistry;
    @Nullable
    private CompressorRegistry compressorRegistry;
    private long idleTimeoutMillis = IDLE_MODE_DEFAULT_TIMEOUT_MILLIS;
    private int maxInboundMessageSize = 0x400000;
    @Nullable
    private StatsContextFactory statsFactory;

    @Override
    public T maxInboundMessageSize(int max) {
        Preconditions.checkArgument((max >= 0 ? 1 : 0) != 0, (Object)"negative max");
        this.maxInboundMessageSize = max;
        return this.thisT();
    }

    protected final int maxInboundMessageSize() {
        return this.maxInboundMessageSize;
    }

    protected AbstractManagedChannelImplBuilder(String target) {
        this.target = (String)Preconditions.checkNotNull((Object)target, (Object)"target");
        this.directServerAddress = null;
    }

    @VisibleForTesting
    static String makeTargetStringForDirectAddress(SocketAddress address) {
        try {
            return new URI(DIRECT_ADDRESS_SCHEME, "", "/" + address, null).toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected AbstractManagedChannelImplBuilder(SocketAddress directServerAddress, String authority) {
        this.target = AbstractManagedChannelImplBuilder.makeTargetStringForDirectAddress(directServerAddress);
        this.directServerAddress = directServerAddress;
        this.nameResolverFactory = new DirectAddressNameResolverFactory(directServerAddress, authority);
    }

    @Override
    public final T directExecutor() {
        return (T)this.executor(MoreExecutors.directExecutor());
    }

    @Override
    public final T executor(Executor executor) {
        this.executor = executor;
        return this.thisT();
    }

    @Override
    public final T intercept(List<ClientInterceptor> interceptors) {
        this.interceptors.addAll(interceptors);
        return this.thisT();
    }

    @Override
    public final T intercept(ClientInterceptor ... interceptors) {
        return (T)this.intercept((List)Arrays.asList(interceptors));
    }

    @Override
    public final T nameResolverFactory(NameResolver.Factory resolverFactory) {
        Preconditions.checkState((this.directServerAddress == null ? 1 : 0) != 0, (String)"directServerAddress is set (%s), which forbids the use of NameResolverFactory", (Object)this.directServerAddress);
        this.nameResolverFactory = resolverFactory;
        return this.thisT();
    }

    @Override
    public final T loadBalancerFactory(LoadBalancer.Factory loadBalancerFactory) {
        Preconditions.checkState((this.directServerAddress == null ? 1 : 0) != 0, (String)"directServerAddress is set (%s), which forbids the use of LoadBalancerFactory", (Object)this.directServerAddress);
        this.loadBalancerFactory = loadBalancerFactory;
        this.channelFactory = null;
        return this.thisT();
    }

    @Override
    public final T loadBalancerFactory(final LoadBalancer2.Factory loadBalancerFactory) {
        Preconditions.checkState((this.directServerAddress == null ? 1 : 0) != 0, (String)"directServerAddress is set (%s), which forbids the use of LoadBalancerFactory", (Object)this.directServerAddress);
        this.channelFactory = new ChannelFactory(){

            @Override
            public ManagedChannel create(ClientTransportFactory transportFactory) {
                return new ManagedChannelImpl2(AbstractManagedChannelImplBuilder.this.target, new ExponentialBackoffPolicy.Provider(), AbstractManagedChannelImplBuilder.this.nameResolverFactory, AbstractManagedChannelImplBuilder.this.getNameResolverParams(), loadBalancerFactory, transportFactory, (DecompressorRegistry)MoreObjects.firstNonNull((Object)AbstractManagedChannelImplBuilder.this.decompressorRegistry, (Object)DecompressorRegistry.getDefaultInstance()), (CompressorRegistry)MoreObjects.firstNonNull((Object)AbstractManagedChannelImplBuilder.this.compressorRegistry, (Object)CompressorRegistry.getDefaultInstance()), SharedResourcePool.forResource(GrpcUtil.TIMER_SERVICE), AbstractManagedChannelImplBuilder.getExecutorPool(AbstractManagedChannelImplBuilder.this.executor), SharedResourcePool.forResource(GrpcUtil.SHARED_CHANNEL_EXECUTOR), GrpcUtil.STOPWATCH_SUPPLIER, AbstractManagedChannelImplBuilder.this.idleTimeoutMillis, AbstractManagedChannelImplBuilder.this.userAgent, AbstractManagedChannelImplBuilder.this.interceptors, (StatsContextFactory)MoreObjects.firstNonNull((Object)AbstractManagedChannelImplBuilder.this.statsFactory, (Object)MoreObjects.firstNonNull((Object)Stats.getStatsContextFactory(), (Object)NoopStatsContextFactory.INSTANCE)));
            }
        };
        return this.thisT();
    }

    @Override
    public final T decompressorRegistry(DecompressorRegistry registry) {
        this.decompressorRegistry = registry;
        return this.thisT();
    }

    @Override
    public final T compressorRegistry(CompressorRegistry registry) {
        this.compressorRegistry = registry;
        return this.thisT();
    }

    @Override
    public final T userAgent(@Nullable String userAgent) {
        this.userAgent = userAgent;
        return this.thisT();
    }

    @Override
    public final T overrideAuthority(String authority) {
        this.authorityOverride = this.checkAuthority(authority);
        return this.thisT();
    }

    @Override
    public final T idleTimeout(long value, TimeUnit unit) {
        Preconditions.checkArgument((value > 0L ? 1 : 0) != 0, (String)"idle timeout is %s, but must be positive", (long)value);
        this.idleTimeoutMillis = unit.toDays(value) >= 30L ? -1L : Math.max(unit.toMillis(value), IDLE_MODE_MIN_TIMEOUT_MILLIS);
        return this.thisT();
    }

    @VisibleForTesting
    protected T statsContextFactory(StatsContextFactory statsFactory) {
        this.statsFactory = statsFactory;
        return this.thisT();
    }

    @VisibleForTesting
    final long getIdleTimeoutMillis() {
        return this.idleTimeoutMillis;
    }

    protected String checkAuthority(String authority) {
        return GrpcUtil.checkAuthority(authority);
    }

    @Override
    public ManagedChannel build() {
        NameResolver.Factory nameResolverFactory;
        ClientTransportFactory transportFactory = this.buildTransportFactory();
        if (this.authorityOverride != null) {
            transportFactory = new AuthorityOverridingTransportFactory(transportFactory, this.authorityOverride);
        }
        if ((nameResolverFactory = this.nameResolverFactory) == null) {
            nameResolverFactory = NameResolverProvider.asFactory();
        }
        if (this.channelFactory != null) {
            return this.channelFactory.create(transportFactory);
        }
        return new ManagedChannelImpl(this.target, new ExponentialBackoffPolicy.Provider(), nameResolverFactory, this.getNameResolverParams(), (LoadBalancer.Factory)MoreObjects.firstNonNull((Object)this.loadBalancerFactory, (Object)PickFirstBalancerFactory.getInstance()), transportFactory, (DecompressorRegistry)MoreObjects.firstNonNull((Object)this.decompressorRegistry, (Object)DecompressorRegistry.getDefaultInstance()), (CompressorRegistry)MoreObjects.firstNonNull((Object)this.compressorRegistry, (Object)CompressorRegistry.getDefaultInstance()), GrpcUtil.TIMER_SERVICE, GrpcUtil.STOPWATCH_SUPPLIER, this.idleTimeoutMillis, this.executor, this.userAgent, this.interceptors, (StatsContextFactory)MoreObjects.firstNonNull((Object)this.statsFactory, (Object)MoreObjects.firstNonNull((Object)Stats.getStatsContextFactory(), (Object)NoopStatsContextFactory.INSTANCE)));
    }

    protected abstract ClientTransportFactory buildTransportFactory();

    protected Attributes getNameResolverParams() {
        return Attributes.EMPTY;
    }

    private static ObjectPool<? extends Executor> getExecutorPool(final @Nullable Executor executor) {
        if (executor != null) {
            return new ObjectPool<Executor>(){

                @Override
                public Executor getObject() {
                    return executor;
                }

                @Override
                public Executor returnObject(Object returned) {
                    return null;
                }
            };
        }
        return SharedResourcePool.forResource(GrpcUtil.SHARED_CHANNEL_EXECUTOR);
    }

    private T thisT() {
        AbstractManagedChannelImplBuilder thisT = this;
        return (T)thisT;
    }

    private static interface ChannelFactory {
        public ManagedChannel create(ClientTransportFactory var1);
    }

    private static class DirectAddressNameResolverFactory
    extends NameResolver.Factory {
        final SocketAddress address;
        final String authority;

        DirectAddressNameResolverFactory(SocketAddress address, String authority) {
            this.address = address;
            this.authority = authority;
        }

        @Override
        public NameResolver newNameResolver(URI notUsedUri, Attributes params) {
            return new NameResolver(){

                @Override
                public String getServiceAuthority() {
                    return DirectAddressNameResolverFactory.this.authority;
                }

                @Override
                public void start(NameResolver.Listener listener) {
                    listener.onUpdate(Collections.singletonList(ResolvedServerInfoGroup.builder().add(new ResolvedServerInfo(DirectAddressNameResolverFactory.this.address)).build()), Attributes.EMPTY);
                }

                @Override
                public void shutdown() {
                }
            };
        }

        @Override
        public String getDefaultScheme() {
            return AbstractManagedChannelImplBuilder.DIRECT_ADDRESS_SCHEME;
        }
    }

    private static class AuthorityOverridingTransportFactory
    implements ClientTransportFactory {
        final ClientTransportFactory factory;
        final String authorityOverride;

        AuthorityOverridingTransportFactory(ClientTransportFactory factory, String authorityOverride) {
            this.factory = (ClientTransportFactory)Preconditions.checkNotNull((Object)factory, (Object)"factory should not be null");
            this.authorityOverride = (String)Preconditions.checkNotNull((Object)authorityOverride, (Object)"authorityOverride should not be null");
        }

        @Override
        public ConnectionClientTransport newClientTransport(SocketAddress serverAddress, String authority, @Nullable String userAgent) {
            return this.factory.newClientTransport(serverAddress, this.authorityOverride, userAgent);
        }

        @Override
        public void close() {
            this.factory.close();
        }
    }
}

