/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import com.google.common.annotations.VisibleForTesting;
import io.grpc.Attributes;
import io.grpc.ConnectivityState;
import io.grpc.ConnectivityStateInfo;
import io.grpc.EquivalentAddressGroup;
import io.grpc.LoadBalancer2;
import io.grpc.Metadata;
import io.grpc.ResolvedServerInfo;
import io.grpc.ResolvedServerInfoGroup;
import io.grpc.Status;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;

public final class PickFirstBalancerFactory2
extends LoadBalancer2.Factory {
    private static final PickFirstBalancerFactory2 INSTANCE = new PickFirstBalancerFactory2();

    private PickFirstBalancerFactory2() {
    }

    public static PickFirstBalancerFactory2 getInstance() {
        return INSTANCE;
    }

    @Override
    public LoadBalancer2 newLoadBalancer(LoadBalancer2.Helper helper) {
        return new PickFirstBalancer(helper);
    }

    @VisibleForTesting
    static class Picker
    extends LoadBalancer2.SubchannelPicker {
        private final LoadBalancer2.PickResult result;

        Picker(LoadBalancer2.PickResult result) {
            this.result = result;
        }

        @Override
        public LoadBalancer2.PickResult pickSubchannel(Attributes affinity, Metadata headers) {
            return this.result;
        }
    }

    @VisibleForTesting
    static class PickFirstBalancer
    extends LoadBalancer2 {
        private final LoadBalancer2.Helper helper;
        private LoadBalancer2.Subchannel subchannel;

        public PickFirstBalancer(LoadBalancer2.Helper helper) {
            this.helper = helper;
        }

        @Override
        public void handleResolvedAddresses(List<ResolvedServerInfoGroup> servers, Attributes attributes) {
            EquivalentAddressGroup newEag = PickFirstBalancer.flattenResolvedServerInfoGroupsIntoEquivalentAddressGroup(servers);
            if (this.subchannel == null || !newEag.equals(this.subchannel.getAddresses())) {
                if (this.subchannel != null) {
                    this.subchannel.shutdown();
                }
                this.subchannel = this.helper.createSubchannel(newEag, Attributes.EMPTY);
                this.helper.updatePicker(new Picker(LoadBalancer2.PickResult.withSubchannel(this.subchannel)));
            }
        }

        @Override
        public void handleNameResolutionError(Status error) {
            if (this.subchannel != null) {
                this.subchannel.shutdown();
                this.subchannel = null;
            }
            this.helper.updatePicker(new Picker(LoadBalancer2.PickResult.withError(error)));
        }

        @Override
        public void handleSubchannelState(LoadBalancer2.Subchannel subchannel, ConnectivityStateInfo stateInfo) {
            LoadBalancer2.PickResult pickResult;
            ConnectivityState currentState = stateInfo.getState();
            if (subchannel != this.subchannel || currentState == ConnectivityState.SHUTDOWN) {
                return;
            }
            switch (currentState) {
                case CONNECTING: {
                    pickResult = LoadBalancer2.PickResult.withNoResult();
                    break;
                }
                case READY: 
                case IDLE: {
                    pickResult = LoadBalancer2.PickResult.withSubchannel(subchannel);
                    break;
                }
                case TRANSIENT_FAILURE: {
                    pickResult = LoadBalancer2.PickResult.withError(stateInfo.getStatus());
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            this.helper.updatePicker(new Picker(pickResult));
        }

        @Override
        public void shutdown() {
            if (this.subchannel != null) {
                this.subchannel.shutdown();
            }
        }

        private static EquivalentAddressGroup flattenResolvedServerInfoGroupsIntoEquivalentAddressGroup(List<ResolvedServerInfoGroup> groupList) {
            ArrayList<SocketAddress> addrs = new ArrayList<SocketAddress>();
            for (ResolvedServerInfoGroup group : groupList) {
                for (ResolvedServerInfo srv : group.getResolvedServerInfoList()) {
                    addrs.add(srv.getAddress());
                }
            }
            return new EquivalentAddressGroup(addrs);
        }
    }
}

