/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.instrumentation.stats.StatsContextFactory;
import io.grpc.Attributes;
import io.grpc.CompressorRegistry;
import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.DecompressorRegistry;
import io.grpc.HandlerRegistry;
import io.grpc.Metadata;
import io.grpc.Server;
import io.grpc.ServerCall;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServerTransportFilter;
import io.grpc.Status;
import io.grpc.internal.ContextRunnable;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.InternalHandlerRegistry;
import io.grpc.internal.InternalServer;
import io.grpc.internal.LogId;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.SerializeReentrantCallsDirectExecutor;
import io.grpc.internal.SerializingExecutor;
import io.grpc.internal.ServerCallImpl;
import io.grpc.internal.ServerListener;
import io.grpc.internal.ServerStream;
import io.grpc.internal.ServerStreamListener;
import io.grpc.internal.ServerTransport;
import io.grpc.internal.ServerTransportListener;
import io.grpc.internal.StatsTraceContext;
import io.grpc.internal.WithLogId;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;

public final class ServerImpl
extends Server
implements WithLogId {
    private static final ServerStreamListener NOOP_LISTENER = new NoopListener();
    private final LogId logId = LogId.allocate(this.getClass().getName());
    private final ObjectPool<? extends Executor> executorPool;
    private Executor executor;
    private final InternalHandlerRegistry registry;
    private final HandlerRegistry fallbackRegistry;
    private final List<ServerTransportFilter> transportFilters;
    private final StatsContextFactory statsFactory;
    @GuardedBy(value="lock")
    private boolean started;
    @GuardedBy(value="lock")
    private boolean shutdown;
    @GuardedBy(value="lock")
    private Status shutdownNowStatus;
    @GuardedBy(value="lock")
    private boolean serverShutdownCallbackInvoked;
    @GuardedBy(value="lock")
    private boolean terminated;
    private final InternalServer transportServer;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private boolean transportServerTerminated;
    @GuardedBy(value="lock")
    private final Collection<ServerTransport> transports = new HashSet<ServerTransport>();
    private final ObjectPool<ScheduledExecutorService> timeoutServicePool;
    private ScheduledExecutorService timeoutService;
    private final Context rootContext;
    private final DecompressorRegistry decompressorRegistry;
    private final CompressorRegistry compressorRegistry;
    private final Supplier<Stopwatch> stopwatchSupplier;

    ServerImpl(ObjectPool<? extends Executor> executorPool, ObjectPool<ScheduledExecutorService> timeoutServicePool, InternalHandlerRegistry registry, HandlerRegistry fallbackRegistry, InternalServer transportServer, Context rootContext, DecompressorRegistry decompressorRegistry, CompressorRegistry compressorRegistry, List<ServerTransportFilter> transportFilters, StatsContextFactory statsFactory, Supplier<Stopwatch> stopwatchSupplier) {
        this.executorPool = (ObjectPool)Preconditions.checkNotNull(executorPool, (Object)"executorPool");
        this.timeoutServicePool = (ObjectPool)Preconditions.checkNotNull(timeoutServicePool, (Object)"timeoutServicePool");
        this.registry = (InternalHandlerRegistry)Preconditions.checkNotNull((Object)registry, (Object)"registry");
        this.fallbackRegistry = (HandlerRegistry)Preconditions.checkNotNull((Object)fallbackRegistry, (Object)"fallbackRegistry");
        this.transportServer = (InternalServer)Preconditions.checkNotNull((Object)transportServer, (Object)"transportServer");
        this.rootContext = ((Context)Preconditions.checkNotNull((Object)rootContext, (Object)"rootContext")).fork();
        this.decompressorRegistry = decompressorRegistry;
        this.compressorRegistry = compressorRegistry;
        this.transportFilters = Collections.unmodifiableList(new ArrayList<ServerTransportFilter>(transportFilters));
        this.statsFactory = (StatsContextFactory)Preconditions.checkNotNull((Object)statsFactory, (Object)"statsFactory");
        this.stopwatchSupplier = (Supplier)Preconditions.checkNotNull(stopwatchSupplier, (Object)"stopwatchSupplier");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServerImpl start() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((!this.started ? 1 : 0) != 0, (Object)"Already started");
            Preconditions.checkState((!this.shutdown ? 1 : 0) != 0, (Object)"Shutting down");
            this.transportServer.start(new ServerListenerImpl());
            this.timeoutService = (ScheduledExecutorService)Preconditions.checkNotNull((Object)this.timeoutServicePool.getObject(), (Object)"timeoutService");
            this.executor = (Executor)Preconditions.checkNotNull((Object)this.executorPool.getObject(), (Object)"executor");
            this.started = true;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPort() {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((boolean)this.started, (Object)"Not started");
            Preconditions.checkState((!this.terminated ? 1 : 0) != 0, (Object)"Already terminated");
            return this.transportServer.getPort();
        }
    }

    @Override
    public List<ServerServiceDefinition> getServices() {
        List<ServerServiceDefinition> fallbackServices = this.fallbackRegistry.getServices();
        if (fallbackServices.isEmpty()) {
            return this.registry.getServices();
        }
        List<ServerServiceDefinition> registryServices = this.registry.getServices();
        int servicesCount = registryServices.size() + fallbackServices.size();
        ArrayList<ServerServiceDefinition> services = new ArrayList<ServerServiceDefinition>(servicesCount);
        services.addAll(registryServices);
        services.addAll(fallbackServices);
        return Collections.unmodifiableList(services);
    }

    @Override
    public List<ServerServiceDefinition> getImmutableServices() {
        return this.registry.getServices();
    }

    @Override
    public List<ServerServiceDefinition> getMutableServices() {
        return Collections.unmodifiableList(this.fallbackRegistry.getServices());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServerImpl shutdown() {
        boolean shutdownTransportServer;
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                return this;
            }
            this.shutdown = true;
            shutdownTransportServer = this.started;
            if (!shutdownTransportServer) {
                this.transportServerTerminated = true;
                this.checkForTermination();
            }
        }
        if (shutdownTransportServer) {
            this.transportServer.shutdown();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServerImpl shutdownNow() {
        boolean savedServerShutdownCallbackInvoked;
        ArrayList<ServerTransport> transportsCopy;
        this.shutdown();
        Status nowStatus = Status.UNAVAILABLE.withDescription("Server shutdownNow invoked");
        Iterator iterator = this.lock;
        synchronized (iterator) {
            if (this.shutdownNowStatus != null) {
                return this;
            }
            this.shutdownNowStatus = nowStatus;
            transportsCopy = new ArrayList<ServerTransport>(this.transports);
            savedServerShutdownCallbackInvoked = this.serverShutdownCallbackInvoked;
        }
        if (savedServerShutdownCallbackInvoked) {
            for (ServerTransport transport : transportsCopy) {
                transport.shutdownNow(nowStatus);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isShutdown() {
        Object object = this.lock;
        synchronized (object) {
            return this.shutdown;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            long timeoutNanos = unit.toNanos(timeout);
            long endTimeNanos = System.nanoTime() + timeoutNanos;
            while (!this.terminated && (timeoutNanos = endTimeNanos - System.nanoTime()) > 0L) {
                TimeUnit.NANOSECONDS.timedWait(this.lock, timeoutNanos);
            }
            return this.terminated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitTermination() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            while (!this.terminated) {
                this.lock.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTerminated() {
        Object object = this.lock;
        synchronized (object) {
            return this.terminated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transportClosed(ServerTransport transport) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.transports.remove(transport)) {
                throw new AssertionError((Object)"Transport already removed");
            }
            this.checkForTermination();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForTermination() {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown && this.transports.isEmpty() && this.transportServerTerminated) {
                if (this.terminated) {
                    throw new AssertionError((Object)"Server already terminated");
                }
                this.terminated = true;
                if (this.timeoutService != null) {
                    this.timeoutService = this.timeoutServicePool.returnObject(this.timeoutService);
                }
                if (this.executor != null) {
                    this.executor = this.executorPool.returnObject(this.executor);
                }
                this.lock.notifyAll();
            }
        }
    }

    @Override
    public LogId getLogId() {
        return this.logId;
    }

    @VisibleForTesting
    static class JumpToApplicationThreadServerStreamListener
    implements ServerStreamListener {
        private final Executor callExecutor;
        private final Context.CancellableContext context;
        private final ServerStream stream;
        private ServerStreamListener listener;

        public JumpToApplicationThreadServerStreamListener(Executor executor, ServerStream stream, Context.CancellableContext context) {
            this.callExecutor = executor;
            this.stream = stream;
            this.context = context;
        }

        private ServerStreamListener getListener() {
            if (this.listener == null) {
                throw new IllegalStateException("listener unset");
            }
            return this.listener;
        }

        @VisibleForTesting
        void setListener(ServerStreamListener listener) {
            Preconditions.checkNotNull((Object)listener, (Object)"listener must not be null");
            Preconditions.checkState((this.listener == null ? 1 : 0) != 0, (Object)"Listener already set");
            this.listener = listener;
        }

        private void internalClose(Status status, Metadata trailers) {
            this.stream.close(status, trailers);
        }

        @Override
        public void messageRead(final InputStream message) {
            this.callExecutor.execute(new ContextRunnable((Context)this.context){

                @Override
                public void runInContext() {
                    try {
                        JumpToApplicationThreadServerStreamListener.this.getListener().messageRead(message);
                    }
                    catch (RuntimeException e) {
                        JumpToApplicationThreadServerStreamListener.this.internalClose(Status.fromThrowable(e), new Metadata());
                        throw e;
                    }
                    catch (Error e) {
                        JumpToApplicationThreadServerStreamListener.this.internalClose(Status.fromThrowable(e), new Metadata());
                        throw e;
                    }
                }
            });
        }

        @Override
        public void halfClosed() {
            this.callExecutor.execute(new ContextRunnable((Context)this.context){

                @Override
                public void runInContext() {
                    try {
                        JumpToApplicationThreadServerStreamListener.this.getListener().halfClosed();
                    }
                    catch (RuntimeException e) {
                        JumpToApplicationThreadServerStreamListener.this.internalClose(Status.fromThrowable(e), new Metadata());
                        throw e;
                    }
                    catch (Error e) {
                        JumpToApplicationThreadServerStreamListener.this.internalClose(Status.fromThrowable(e), new Metadata());
                        throw e;
                    }
                }
            });
        }

        @Override
        public void closed(final Status status) {
            this.callExecutor.execute(new ContextRunnable((Context)this.context){

                @Override
                public void runInContext() {
                    try {
                        JumpToApplicationThreadServerStreamListener.this.getListener().closed(status);
                    }
                    finally {
                        JumpToApplicationThreadServerStreamListener.this.context.cancel(status.getCause());
                    }
                }
            });
        }

        @Override
        public void onReady() {
            this.callExecutor.execute(new ContextRunnable((Context)this.context){

                @Override
                public void runInContext() {
                    try {
                        JumpToApplicationThreadServerStreamListener.this.getListener().onReady();
                    }
                    catch (RuntimeException e) {
                        JumpToApplicationThreadServerStreamListener.this.internalClose(Status.fromThrowable(e), new Metadata());
                        throw e;
                    }
                    catch (Error e) {
                        JumpToApplicationThreadServerStreamListener.this.internalClose(Status.fromThrowable(e), new Metadata());
                        throw e;
                    }
                }
            });
        }
    }

    private static class NoopListener
    implements ServerStreamListener {
        private NoopListener() {
        }

        @Override
        public void messageRead(InputStream value) {
            try {
                value.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void halfClosed() {
        }

        @Override
        public void closed(Status status) {
        }

        @Override
        public void onReady() {
        }
    }

    private class ServerTransportListenerImpl
    implements ServerTransportListener {
        private final ServerTransport transport;
        private Attributes attributes;

        public ServerTransportListenerImpl(ServerTransport transport) {
            this.transport = transport;
        }

        @Override
        public Attributes transportReady(Attributes attributes) {
            for (ServerTransportFilter filter : ServerImpl.this.transportFilters) {
                attributes = (Attributes)Preconditions.checkNotNull((Object)filter.transportReady(attributes), (String)"Filter %s returned null", (Object)filter);
            }
            this.attributes = attributes;
            return attributes;
        }

        @Override
        public void transportTerminated() {
            for (ServerTransportFilter filter : ServerImpl.this.transportFilters) {
                filter.transportTerminated(this.attributes);
            }
            ServerImpl.this.transportClosed(this.transport);
        }

        @Override
        public StatsTraceContext methodDetermined(String methodName, Metadata headers) {
            return StatsTraceContext.newServerContext(methodName, ServerImpl.this.statsFactory, headers, (Supplier<Stopwatch>)ServerImpl.this.stopwatchSupplier);
        }

        @Override
        public void streamCreated(final ServerStream stream, final String methodName, final Metadata headers) {
            final StatsTraceContext statsTraceCtx = (StatsTraceContext)Preconditions.checkNotNull((Object)stream.statsTraceContext(), (Object)"statsTraceCtx not present from stream");
            final Context.CancellableContext context = this.createContext(stream, headers);
            Executor wrappedExecutor = ServerImpl.this.executor == MoreExecutors.directExecutor() ? new SerializeReentrantCallsDirectExecutor() : new SerializingExecutor(ServerImpl.this.executor);
            final JumpToApplicationThreadServerStreamListener jumpListener = new JumpToApplicationThreadServerStreamListener(wrappedExecutor, stream, context);
            stream.setListener(jumpListener);
            wrappedExecutor.execute(new ContextRunnable((Context)context){

                @Override
                public void runInContext() {
                    ServerStreamListener listener = NOOP_LISTENER;
                    try {
                        ServerMethodDefinition<?, ?> method = ServerImpl.this.registry.lookupMethod(methodName);
                        if (method == null) {
                            method = ServerImpl.this.fallbackRegistry.lookupMethod(methodName);
                        }
                        if (method == null) {
                            Status status = Status.UNIMPLEMENTED.withDescription("Method not found: " + methodName);
                            stream.close(status, new Metadata());
                            statsTraceCtx.callEnded(status);
                            context.cancel(null);
                            return;
                        }
                        listener = ServerTransportListenerImpl.this.startCall(stream, methodName, method, headers, context);
                    }
                    catch (RuntimeException e) {
                        stream.close(Status.fromThrowable(e), new Metadata());
                        context.cancel(null);
                        throw e;
                    }
                    catch (Error e) {
                        stream.close(Status.fromThrowable(e), new Metadata());
                        context.cancel(null);
                        throw e;
                    }
                    finally {
                        jumpListener.setListener(listener);
                    }
                }
            });
        }

        private Context.CancellableContext createContext(final ServerStream stream, Metadata headers) {
            Long timeoutNanos = headers.get(GrpcUtil.TIMEOUT_KEY);
            Context baseContext = ServerImpl.this.rootContext;
            if (timeoutNanos == null) {
                return baseContext.withCancellation();
            }
            Context.CancellableContext context = baseContext.withDeadlineAfter(timeoutNanos.longValue(), TimeUnit.NANOSECONDS, ServerImpl.this.timeoutService);
            context.addListener(new Context.CancellationListener(){

                public void cancelled(Context context) {
                    Status status = Contexts.statusFromCancelled(context);
                    if (Status.DEADLINE_EXCEEDED.getCode().equals((Object)status.getCode())) {
                        stream.cancel(status);
                    }
                }
            }, MoreExecutors.directExecutor());
            return context;
        }

        private <ReqT, RespT> ServerStreamListener startCall(ServerStream stream, String fullMethodName, ServerMethodDefinition<ReqT, RespT> methodDef, Metadata headers, Context.CancellableContext context) {
            ServerCallImpl<ReqT, RespT> call = new ServerCallImpl<ReqT, RespT>(stream, methodDef.getMethodDescriptor(), headers, context, stream.statsTraceContext(), ServerImpl.this.decompressorRegistry, ServerImpl.this.compressorRegistry);
            ServerCall.Listener<ReqT> listener = methodDef.getServerCallHandler().startCall(call, headers);
            if (listener == null) {
                throw new NullPointerException("startCall() returned a null listener for method " + fullMethodName);
            }
            return call.newServerStreamListener(listener);
        }
    }

    private class ServerListenerImpl
    implements ServerListener {
        private ServerListenerImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ServerTransportListener transportCreated(ServerTransport transport) {
            Object object = ServerImpl.this.lock;
            synchronized (object) {
                ServerImpl.this.transports.add(transport);
            }
            return new ServerTransportListenerImpl(transport);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serverShutdown() {
            Status shutdownNowStatusCopy;
            ArrayList copiedTransports;
            Object object = ServerImpl.this.lock;
            synchronized (object) {
                copiedTransports = new ArrayList(ServerImpl.this.transports);
                shutdownNowStatusCopy = ServerImpl.this.shutdownNowStatus;
                ServerImpl.this.serverShutdownCallbackInvoked = true;
            }
            for (ServerTransport transport : copiedTransports) {
                if (shutdownNowStatusCopy == null) {
                    transport.shutdown();
                    continue;
                }
                transport.shutdownNow(shutdownNowStatusCopy);
            }
            object = ServerImpl.this.lock;
            synchronized (object) {
                ServerImpl.this.transportServerTerminated = true;
                ServerImpl.this.checkForTermination();
            }
        }
    }
}

