/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.ConnectivityState;
import io.grpc.ConnectivityStateInfo;
import io.grpc.EquivalentAddressGroup;
import io.grpc.LoadBalancer2;
import io.grpc.Metadata;
import io.grpc.ResolvedServerInfo;
import io.grpc.ResolvedServerInfoGroup;
import io.grpc.Status;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public class RoundRobinLoadBalancerFactory2
extends LoadBalancer2.Factory {
    private static final RoundRobinLoadBalancerFactory2 INSTANCE = new RoundRobinLoadBalancerFactory2();

    private RoundRobinLoadBalancerFactory2() {
    }

    public static RoundRobinLoadBalancerFactory2 getInstance() {
        return INSTANCE;
    }

    @Override
    public LoadBalancer2 newLoadBalancer(LoadBalancer2.Helper helper) {
        return new RoundRobinLoadBalancer(helper);
    }

    @VisibleForTesting
    static class Picker
    extends LoadBalancer2.SubchannelPicker {
        @Nullable
        private final Status status;
        private final List<LoadBalancer2.Subchannel> list;
        private final int size;
        @GuardedBy(value="this")
        private int index = 0;

        Picker(List<LoadBalancer2.Subchannel> list, @Nullable Status status) {
            this.list = Collections.unmodifiableList(list);
            this.size = list.size();
            this.status = status;
        }

        @Override
        public LoadBalancer2.PickResult pickSubchannel(Attributes affinity, Metadata headers) {
            if (this.size > 0) {
                return LoadBalancer2.PickResult.withSubchannel(this.nextSubchannel());
            }
            if (this.status != null) {
                return LoadBalancer2.PickResult.withError(this.status);
            }
            return LoadBalancer2.PickResult.withNoResult();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LoadBalancer2.Subchannel nextSubchannel() {
            if (this.size == 0) {
                throw new NoSuchElementException();
            }
            Picker picker = this;
            synchronized (picker) {
                LoadBalancer2.Subchannel val = this.list.get(this.index);
                ++this.index;
                if (this.index >= this.size) {
                    this.index = 0;
                }
                return val;
            }
        }

        @VisibleForTesting
        List<LoadBalancer2.Subchannel> getList() {
            return this.list;
        }

        @VisibleForTesting
        Status getStatus() {
            return this.status;
        }
    }

    @VisibleForTesting
    static class RoundRobinLoadBalancer
    extends LoadBalancer2 {
        private final LoadBalancer2.Helper helper;
        private final Map<EquivalentAddressGroup, LoadBalancer2.Subchannel> subchannels = new HashMap<EquivalentAddressGroup, LoadBalancer2.Subchannel>();
        @VisibleForTesting
        static final Attributes.Key<AtomicReference<ConnectivityStateInfo>> STATE_INFO = Attributes.Key.of("state-info");

        public RoundRobinLoadBalancer(LoadBalancer2.Helper helper) {
            this.helper = helper;
        }

        @Override
        public void handleResolvedAddresses(List<ResolvedServerInfoGroup> servers, Attributes attributes) {
            LoadBalancer2.Subchannel subchannel;
            Set<EquivalentAddressGroup> currentAddrs = this.subchannels.keySet();
            Set<EquivalentAddressGroup> latestAddrs = RoundRobinLoadBalancer.resolvedServerInfoGroupToEquivalentAddressGroup(servers);
            Set<EquivalentAddressGroup> addedAddrs = RoundRobinLoadBalancer.setsDifference(latestAddrs, currentAddrs);
            Set<EquivalentAddressGroup> removedAddrs = RoundRobinLoadBalancer.setsDifference(currentAddrs, latestAddrs);
            Attributes subchannelAttrs = Attributes.newBuilder().set(STATE_INFO, new AtomicReference<ConnectivityStateInfo>(ConnectivityStateInfo.forNonError(ConnectivityState.IDLE))).build();
            for (EquivalentAddressGroup addressGroup : addedAddrs) {
                subchannel = (LoadBalancer2.Subchannel)Preconditions.checkNotNull((Object)this.helper.createSubchannel(addressGroup, subchannelAttrs), (Object)"subchannel");
                this.subchannels.put(addressGroup, subchannel);
                subchannel.requestConnection();
            }
            for (EquivalentAddressGroup addressGroup : removedAddrs) {
                subchannel = this.subchannels.remove(addressGroup);
                subchannel.shutdown();
            }
            this.updatePicker(this.getAggregatedError());
        }

        @Override
        public void handleNameResolutionError(Status error) {
            this.updatePicker(error);
        }

        @Override
        public void handleSubchannelState(LoadBalancer2.Subchannel subchannel, ConnectivityStateInfo stateInfo) {
            if (!this.subchannels.containsValue(subchannel)) {
                return;
            }
            if (stateInfo.getState() == ConnectivityState.IDLE) {
                subchannel.requestConnection();
            }
            RoundRobinLoadBalancer.getSubchannelStateInfoRef(subchannel).set(stateInfo);
            this.updatePicker(this.getAggregatedError());
        }

        @Override
        public void shutdown() {
            for (LoadBalancer2.Subchannel subchannel : this.getSubchannels()) {
                subchannel.shutdown();
            }
        }

        private void updatePicker(@Nullable Status error) {
            List<LoadBalancer2.Subchannel> activeList = RoundRobinLoadBalancer.filterNonFailingSubchannels(this.getSubchannels());
            this.helper.updatePicker(new Picker(activeList, error));
        }

        private static List<LoadBalancer2.Subchannel> filterNonFailingSubchannels(Collection<LoadBalancer2.Subchannel> subchannels) {
            ArrayList<LoadBalancer2.Subchannel> readySubchannels = new ArrayList<LoadBalancer2.Subchannel>(subchannels.size());
            for (LoadBalancer2.Subchannel subchannel : subchannels) {
                if (RoundRobinLoadBalancer.getSubchannelStateInfoRef(subchannel).get().getState() != ConnectivityState.READY) continue;
                readySubchannels.add(subchannel);
            }
            return readySubchannels;
        }

        private static Set<EquivalentAddressGroup> resolvedServerInfoGroupToEquivalentAddressGroup(List<ResolvedServerInfoGroup> groupList) {
            HashSet<EquivalentAddressGroup> addrs = new HashSet<EquivalentAddressGroup>();
            for (ResolvedServerInfoGroup group : groupList) {
                for (ResolvedServerInfo server : group.getResolvedServerInfoList()) {
                    addrs.add(new EquivalentAddressGroup(server.getAddress()));
                }
            }
            return addrs;
        }

        @Nullable
        private Status getAggregatedError() {
            Status status = null;
            for (LoadBalancer2.Subchannel subchannel : this.getSubchannels()) {
                ConnectivityStateInfo stateInfo = RoundRobinLoadBalancer.getSubchannelStateInfoRef(subchannel).get();
                if (stateInfo.getState() != ConnectivityState.TRANSIENT_FAILURE) {
                    return null;
                }
                status = stateInfo.getStatus();
            }
            return status;
        }

        @VisibleForTesting
        Collection<LoadBalancer2.Subchannel> getSubchannels() {
            return this.subchannels.values();
        }

        private static AtomicReference<ConnectivityStateInfo> getSubchannelStateInfoRef(LoadBalancer2.Subchannel subchannel) {
            return (AtomicReference)Preconditions.checkNotNull(subchannel.getAttributes().get(STATE_INFO), (Object)"STATE_INFO");
        }

        private static <T> Set<T> setsDifference(Set<T> a, Set<T> b) {
            HashSet<T> aCopy = new HashSet<T>(a);
            aCopy.removeAll(b);
            return aCopy;
        }
    }
}

