/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.annotations.VisibleForTesting;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.InternalClientInterceptors;
import io.grpc.InternalServerInterceptors;
import io.grpc.InternalServiceProviders;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.ServerMethodDefinition;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public abstract class BinaryLogProvider
implements Closeable {
    private static final Logger logger = Logger.getLogger(BinaryLogProvider.class.getName());
    private static final BinaryLogProvider PROVIDER = InternalServiceProviders.load(BinaryLogProvider.class, Collections.<Class<?>>emptyList(), BinaryLogProvider.class.getClassLoader(), new InternalServiceProviders.PriorityAccessor<BinaryLogProvider>(){

        @Override
        public boolean isAvailable(BinaryLogProvider provider) {
            return provider.isAvailable();
        }

        @Override
        public int getPriority(BinaryLogProvider provider) {
            return provider.priority();
        }
    });
    @VisibleForTesting
    static final MethodDescriptor.Marshaller<InputStream> IDENTITY_MARSHALLER = new IdentityMarshaller();
    private final ClientInterceptor binaryLogShim = new BinaryLogShim();

    @Nullable
    public static BinaryLogProvider provider() {
        return PROVIDER;
    }

    Channel wrapChannel(Channel channel) {
        return ClientInterceptors.intercept(channel, this.binaryLogShim);
    }

    private static MethodDescriptor<InputStream, InputStream> toInputStreamMethod(MethodDescriptor<?, ?> method) {
        return method.toBuilder(IDENTITY_MARSHALLER, IDENTITY_MARSHALLER).build();
    }

    final <ReqT, RespT> ServerMethodDefinition<?, ?> wrapMethodDefinition(ServerMethodDefinition<ReqT, RespT> oMethodDef) {
        ServerInterceptor binlogInterceptor = this.getServerInterceptor(oMethodDef.getMethodDescriptor().getFullMethodName());
        if (binlogInterceptor == null) {
            return oMethodDef;
        }
        MethodDescriptor<InputStream, InputStream> binMethod = BinaryLogProvider.toInputStreamMethod(oMethodDef.getMethodDescriptor());
        ServerMethodDefinition<InputStream, InputStream> binDef = InternalServerInterceptors.wrapMethod(oMethodDef, binMethod);
        ServerCallHandler<InputStream, InputStream> binlogHandler = InternalServerInterceptors.interceptCallHandler(binlogInterceptor, binDef.getServerCallHandler());
        return ServerMethodDefinition.create(binMethod, binlogHandler);
    }

    @Nullable
    public abstract ServerInterceptor getServerInterceptor(String var1);

    @Nullable
    public abstract ClientInterceptor getClientInterceptor(String var1);

    @Override
    public void close() throws IOException {
    }

    protected abstract int priority();

    protected abstract boolean isAvailable();

    private final class BinaryLogShim
    implements ClientInterceptor {
        private BinaryLogShim() {
        }

        @Override
        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
            ClientInterceptor binlogInterceptor = BinaryLogProvider.this.getClientInterceptor(method.getFullMethodName());
            if (binlogInterceptor == null) {
                return next.newCall(method, callOptions);
            }
            return InternalClientInterceptors.wrapClientInterceptor(binlogInterceptor, IDENTITY_MARSHALLER, IDENTITY_MARSHALLER).interceptCall(method, callOptions, next);
        }
    }

    private static final class IdentityMarshaller
    implements MethodDescriptor.Marshaller<InputStream> {
        private IdentityMarshaller() {
        }

        @Override
        public InputStream stream(InputStream value) {
            return value;
        }

        @Override
        public InputStream parse(InputStream stream) {
            return stream;
        }
    }
}

