/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.annotations.VisibleForTesting;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.Context;
import io.grpc.Internal;
import io.grpc.InternalClientInterceptors;
import io.grpc.InternalServerInterceptors;
import io.grpc.InternalServiceProviders;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerStreamTracer;
import io.grpc.internal.IoUtils;
import io.opencensus.trace.Span;
import io.opencensus.trace.Tracing;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public abstract class BinaryLogProvider
implements Closeable {
    @Internal
    public static final Context.Key<CallId> SERVER_CALL_ID_CONTEXT_KEY = Context.key((String)"binarylog-context-key");
    @Internal
    public static final CallOptions.Key<CallId> CLIENT_CALL_ID_CALLOPTION_KEY = CallOptions.Key.of("binarylog-calloptions-key", null);
    @VisibleForTesting
    public static final MethodDescriptor.Marshaller<byte[]> BYTEARRAY_MARSHALLER = new ByteArrayMarshaller();
    private static final Logger logger = Logger.getLogger(BinaryLogProvider.class.getName());
    private static final BinaryLogProvider PROVIDER = InternalServiceProviders.load(BinaryLogProvider.class, Collections.<Class<?>>emptyList(), BinaryLogProvider.class.getClassLoader(), new InternalServiceProviders.PriorityAccessor<BinaryLogProvider>(){

        @Override
        public boolean isAvailable(BinaryLogProvider provider) {
            return provider.isAvailable();
        }

        @Override
        public int getPriority(BinaryLogProvider provider) {
            return provider.priority();
        }
    });
    private final ClientInterceptor binaryLogShim = new BinaryLogShim();
    private static final ServerStreamTracer SERVER_CALLID_SETTER = new ServerStreamTracer(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Context filterContext(Context context) {
            Context toRestore = context.attach();
            try {
                Span span = Tracing.getTracer().getCurrentSpan();
                if (span == null) {
                    Context context2 = context;
                    return context2;
                }
                Context context3 = context.withValue(SERVER_CALL_ID_CONTEXT_KEY, (Object)CallId.fromCensusSpan(span));
                return context3;
            }
            finally {
                context.detach(toRestore);
            }
        }
    };
    private static final ServerStreamTracer.Factory SERVER_CALLID_SETTER_FACTORY = new ServerStreamTracer.Factory(){

        @Override
        public ServerStreamTracer newServerStreamTracer(String fullMethodName, Metadata headers) {
            return SERVER_CALLID_SETTER;
        }
    };
    private static final ClientInterceptor CLIENT_CALLID_SETTER = new ClientInterceptor(){

        @Override
        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
            Span span = Tracing.getTracer().getCurrentSpan();
            if (span == null) {
                return next.newCall(method, callOptions);
            }
            return next.newCall(method, callOptions.withOption(CLIENT_CALL_ID_CALLOPTION_KEY, CallId.fromCensusSpan(span)));
        }
    };

    @Nullable
    public static BinaryLogProvider provider() {
        return PROVIDER;
    }

    public final Channel wrapChannel(Channel channel) {
        return ClientInterceptors.intercept(channel, this.binaryLogShim);
    }

    private static MethodDescriptor<byte[], byte[]> toByteBufferMethod(MethodDescriptor<?, ?> method) {
        return method.toBuilder(BYTEARRAY_MARSHALLER, BYTEARRAY_MARSHALLER).build();
    }

    public final <ReqT, RespT> ServerMethodDefinition<?, ?> wrapMethodDefinition(ServerMethodDefinition<ReqT, RespT> oMethodDef) {
        ServerInterceptor binlogInterceptor = this.getServerInterceptor(oMethodDef.getMethodDescriptor().getFullMethodName());
        if (binlogInterceptor == null) {
            return oMethodDef;
        }
        MethodDescriptor<byte[], byte[]> binMethod = BinaryLogProvider.toByteBufferMethod(oMethodDef.getMethodDescriptor());
        ServerMethodDefinition<byte[], byte[]> binDef = InternalServerInterceptors.wrapMethod(oMethodDef, binMethod);
        ServerCallHandler<byte[], byte[]> binlogHandler = InternalServerInterceptors.interceptCallHandler(binlogInterceptor, binDef.getServerCallHandler());
        return ServerMethodDefinition.create(binMethod, binlogHandler);
    }

    @Nullable
    protected abstract ServerInterceptor getServerInterceptor(String var1);

    @Nullable
    protected abstract ClientInterceptor getClientInterceptor(String var1);

    @Override
    public void close() throws IOException {
    }

    public ServerStreamTracer.Factory getServerCallIdSetter() {
        return SERVER_CALLID_SETTER_FACTORY;
    }

    public ClientInterceptor getClientCallIdSetter() {
        return CLIENT_CALLID_SETTER;
    }

    protected abstract int priority();

    protected abstract boolean isAvailable();

    public static final class CallId {
        public final long hi;
        public final long lo;

        public CallId(long hi, long lo) {
            this.hi = hi;
            this.lo = lo;
        }

        static CallId fromCensusSpan(Span span) {
            return new CallId(0L, ByteBuffer.wrap(span.getContext().getSpanId().getBytes()).getLong());
        }
    }

    private final class BinaryLogShim
    implements ClientInterceptor {
        private BinaryLogShim() {
        }

        @Override
        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
            ClientInterceptor binlogInterceptor = BinaryLogProvider.this.getClientInterceptor(method.getFullMethodName());
            if (binlogInterceptor == null) {
                return next.newCall(method, callOptions);
            }
            return InternalClientInterceptors.wrapClientInterceptor(binlogInterceptor, BYTEARRAY_MARSHALLER, BYTEARRAY_MARSHALLER).interceptCall(method, callOptions, next);
        }
    }

    private static final class ByteArrayMarshaller
    implements MethodDescriptor.Marshaller<byte[]> {
        private ByteArrayMarshaller() {
        }

        @Override
        public InputStream stream(byte[] value) {
            return new ByteArrayInputStream(value);
        }

        @Override
        public byte[] parse(InputStream stream) {
            try {
                return this.parseHelper(stream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private byte[] parseHelper(InputStream stream) throws IOException {
            try {
                byte[] byArray = IoUtils.toByteArray(stream);
                return byArray;
            }
            finally {
                stream.close();
            }
        }
    }
}

