/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.instrumentation.stats.StatsContextFactory;
import io.grpc.Attributes;
import io.grpc.CallOptions;
import io.grpc.ClientCall;
import io.grpc.ConnectivityStateInfo;
import io.grpc.EquivalentAddressGroup;
import io.grpc.LoadBalancer;
import io.grpc.ManagedChannel;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.internal.ChannelExecutor;
import io.grpc.internal.ClientCallImpl;
import io.grpc.internal.ClientTransport;
import io.grpc.internal.DelayedClientTransport;
import io.grpc.internal.InternalSubchannel;
import io.grpc.internal.LogId;
import io.grpc.internal.ManagedClientTransport;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.StatsTraceContext;
import io.grpc.internal.SubchannelImpl;
import io.grpc.internal.WithLogId;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class OobChannel
extends ManagedChannel
implements WithLogId {
    private static final Logger log = Logger.getLogger(OobChannel.class.getName());
    private SubchannelImpl subchannelImpl;
    private LoadBalancer.SubchannelPicker subchannelPicker;
    private final LogId logId = LogId.allocate(this.getClass().getName());
    private final StatsContextFactory statsFactory;
    private final String authority;
    private final DelayedClientTransport delayedTransport;
    private final ObjectPool<? extends Executor> executorPool;
    private final Executor executor;
    private final ScheduledExecutorService deadlineCancellationExecutor;
    private final Supplier<Stopwatch> stopwatchSupplier;
    private final CountDownLatch terminatedLatch = new CountDownLatch(1);
    private volatile boolean shutdown;
    private final ClientCallImpl.ClientTransportProvider transportProvider = new ClientCallImpl.ClientTransportProvider(){

        @Override
        public ClientTransport get(LoadBalancer.PickSubchannelArgs args) {
            return OobChannel.this.delayedTransport;
        }
    };

    OobChannel(StatsContextFactory statsFactory, String authority, ObjectPool<? extends Executor> executorPool, ScheduledExecutorService deadlineCancellationExecutor, Supplier<Stopwatch> stopwatchSupplier, ChannelExecutor channelExecutor) {
        this.statsFactory = (StatsContextFactory)Preconditions.checkNotNull((Object)statsFactory, (Object)"statsFactory");
        this.authority = (String)Preconditions.checkNotNull((Object)authority, (Object)"authority");
        this.executorPool = (ObjectPool)Preconditions.checkNotNull(executorPool, (Object)"executorPool");
        this.executor = (Executor)Preconditions.checkNotNull((Object)executorPool.getObject(), (Object)"executor");
        this.deadlineCancellationExecutor = (ScheduledExecutorService)Preconditions.checkNotNull((Object)deadlineCancellationExecutor, (Object)"deadlineCancellationExecutor");
        this.stopwatchSupplier = (Supplier)Preconditions.checkNotNull(stopwatchSupplier, (Object)"stopwatchSupplier");
        this.delayedTransport = new DelayedClientTransport(this.executor, channelExecutor);
        this.delayedTransport.start(new ManagedClientTransport.Listener(){

            @Override
            public void transportShutdown(Status s) {
            }

            @Override
            public void transportTerminated() {
                OobChannel.this.subchannelImpl.shutdown();
            }

            @Override
            public void transportReady() {
            }

            @Override
            public void transportInUse(boolean inUse) {
            }
        });
    }

    void setSubchannel(final InternalSubchannel subchannel) {
        log.log(Level.FINE, "[{0}] Created with [{1}]", new Object[]{this, subchannel});
        this.subchannelImpl = new SubchannelImpl(){

            @Override
            public void shutdown() {
                subchannel.shutdown();
            }

            @Override
            ClientTransport obtainActiveTransport() {
                return subchannel.obtainActiveTransport();
            }

            @Override
            public void requestConnection() {
                subchannel.obtainActiveTransport();
            }

            @Override
            public EquivalentAddressGroup getAddresses() {
                return subchannel.getAddressGroup();
            }

            @Override
            public Attributes getAttributes() {
                return Attributes.EMPTY;
            }
        };
        this.subchannelPicker = new LoadBalancer.SubchannelPicker(){
            final LoadBalancer.PickResult result;
            {
                this.result = LoadBalancer.PickResult.withSubchannel(OobChannel.this.subchannelImpl);
            }

            @Override
            public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
                return this.result;
            }
        };
        this.delayedTransport.reprocess(this.subchannelPicker);
    }

    @Override
    public <RequestT, ResponseT> ClientCall<RequestT, ResponseT> newCall(MethodDescriptor<RequestT, ResponseT> methodDescriptor, CallOptions callOptions) {
        StatsTraceContext statsTraceCtx = StatsTraceContext.newClientContext(methodDescriptor.getFullMethodName(), this.statsFactory, this.stopwatchSupplier);
        return new ClientCallImpl<RequestT, ResponseT>(methodDescriptor, callOptions.getExecutor() == null ? this.executor : callOptions.getExecutor(), callOptions, statsTraceCtx, this.transportProvider, this.deadlineCancellationExecutor);
    }

    @Override
    public String authority() {
        return this.authority;
    }

    @Override
    public LogId getLogId() {
        return this.logId;
    }

    @Override
    public boolean isTerminated() {
        return this.terminatedLatch.getCount() == 0L;
    }

    @Override
    public boolean awaitTermination(long time, TimeUnit unit) throws InterruptedException {
        return this.terminatedLatch.await(time, unit);
    }

    @Override
    public ManagedChannel shutdown() {
        this.shutdown = true;
        this.delayedTransport.shutdown();
        return this;
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public ManagedChannel shutdownNow() {
        this.shutdown = true;
        this.delayedTransport.shutdownNow(Status.UNAVAILABLE.withDescription("OobChannel.shutdownNow() called"));
        return this;
    }

    void handleSubchannelStateChange(final ConnectivityStateInfo newState) {
        switch (newState.getState()) {
            case READY: 
            case IDLE: {
                this.delayedTransport.reprocess(this.subchannelPicker);
                break;
            }
            case TRANSIENT_FAILURE: {
                this.delayedTransport.reprocess(new LoadBalancer.SubchannelPicker(){
                    final LoadBalancer.PickResult errorResult;
                    {
                        this.errorResult = LoadBalancer.PickResult.withError(newState.getStatus());
                    }

                    @Override
                    public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
                        return this.errorResult;
                    }
                });
                break;
            }
        }
    }

    void handleSubchannelTerminated() {
        this.executorPool.returnObject(this.executor);
        this.terminatedLatch.countDown();
    }
}

