/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.ConnectivityState;
import io.grpc.ConnectivityStateInfo;
import io.grpc.EquivalentAddressGroup;
import io.grpc.LoadBalancer;
import io.grpc.Status;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.annotation.Nonnull;

final class RoundRobinLoadBalancer
extends LoadBalancer {
    @VisibleForTesting
    static final Attributes.Key<Ref<ConnectivityStateInfo>> STATE_INFO = Attributes.Key.create((String)"state-info");
    private final LoadBalancer.Helper helper;
    private final Map<EquivalentAddressGroup, LoadBalancer.Subchannel> subchannels = new HashMap<EquivalentAddressGroup, LoadBalancer.Subchannel>();
    private final Random random;
    private ConnectivityState currentState;
    private RoundRobinPicker currentPicker = new EmptyPicker(EMPTY_OK);
    private static final Status EMPTY_OK = Status.OK.withDescription("no subchannels ready");

    RoundRobinLoadBalancer(LoadBalancer.Helper helper) {
        this.helper = (LoadBalancer.Helper)Preconditions.checkNotNull((Object)helper, (Object)"helper");
        this.random = new Random();
    }

    public void handleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        List servers = resolvedAddresses.getAddresses();
        Set<EquivalentAddressGroup> currentAddrs = this.subchannels.keySet();
        Map<EquivalentAddressGroup, EquivalentAddressGroup> latestAddrs = RoundRobinLoadBalancer.stripAttrs(servers);
        Set<EquivalentAddressGroup> removedAddrs = RoundRobinLoadBalancer.setsDifference(currentAddrs, latestAddrs.keySet());
        for (Map.Entry<EquivalentAddressGroup, EquivalentAddressGroup> latestEntry : latestAddrs.entrySet()) {
            EquivalentAddressGroup strippedAddressGroup = latestEntry.getKey();
            EquivalentAddressGroup originalAddressGroup = latestEntry.getValue();
            LoadBalancer.Subchannel existingSubchannel = this.subchannels.get(strippedAddressGroup);
            if (existingSubchannel != null) {
                existingSubchannel.updateAddresses(Collections.singletonList(originalAddressGroup));
                continue;
            }
            Attributes.Builder subchannelAttrs = Attributes.newBuilder().set(STATE_INFO, new Ref<ConnectivityStateInfo>(ConnectivityStateInfo.forNonError((ConnectivityState)ConnectivityState.IDLE)));
            final LoadBalancer.Subchannel subchannel = (LoadBalancer.Subchannel)Preconditions.checkNotNull((Object)this.helper.createSubchannel(LoadBalancer.CreateSubchannelArgs.newBuilder().setAddresses(originalAddressGroup).setAttributes(subchannelAttrs.build()).build()), (Object)"subchannel");
            subchannel.start(new LoadBalancer.SubchannelStateListener(){

                public void onSubchannelState(ConnectivityStateInfo state) {
                    RoundRobinLoadBalancer.this.processSubchannelState(subchannel, state);
                }
            });
            this.subchannels.put(strippedAddressGroup, subchannel);
            subchannel.requestConnection();
        }
        ArrayList<LoadBalancer.Subchannel> removedSubchannels = new ArrayList<LoadBalancer.Subchannel>();
        for (EquivalentAddressGroup addressGroup : removedAddrs) {
            removedSubchannels.add(this.subchannels.remove(addressGroup));
        }
        this.updateBalancingState();
        for (LoadBalancer.Subchannel removedSubchannel : removedSubchannels) {
            this.shutdownSubchannel(removedSubchannel);
        }
    }

    public void handleNameResolutionError(Status error) {
        if (this.currentState != ConnectivityState.READY) {
            this.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, new EmptyPicker(error));
        }
    }

    private void processSubchannelState(LoadBalancer.Subchannel subchannel, ConnectivityStateInfo stateInfo) {
        if (this.subchannels.get(RoundRobinLoadBalancer.stripAttrs(subchannel.getAddresses())) != subchannel) {
            return;
        }
        if (stateInfo.getState() == ConnectivityState.IDLE) {
            subchannel.requestConnection();
        }
        Ref<ConnectivityStateInfo> subchannelStateRef = RoundRobinLoadBalancer.getSubchannelStateInfoRef(subchannel);
        if (((ConnectivityStateInfo)subchannelStateRef.value).getState().equals((Object)ConnectivityState.TRANSIENT_FAILURE) && (stateInfo.getState().equals((Object)ConnectivityState.CONNECTING) || stateInfo.getState().equals((Object)ConnectivityState.IDLE))) {
            return;
        }
        subchannelStateRef.value = stateInfo;
        this.updateBalancingState();
    }

    private void shutdownSubchannel(LoadBalancer.Subchannel subchannel) {
        subchannel.shutdown();
        RoundRobinLoadBalancer.getSubchannelStateInfoRef((LoadBalancer.Subchannel)subchannel).value = ConnectivityStateInfo.forNonError((ConnectivityState)ConnectivityState.SHUTDOWN);
    }

    public void shutdown() {
        for (LoadBalancer.Subchannel subchannel : this.getSubchannels()) {
            this.shutdownSubchannel(subchannel);
        }
        this.subchannels.clear();
    }

    private void updateBalancingState() {
        List<LoadBalancer.Subchannel> activeList = RoundRobinLoadBalancer.filterNonFailingSubchannels(this.getSubchannels());
        if (activeList.isEmpty()) {
            boolean isConnecting = false;
            Status aggStatus = EMPTY_OK;
            for (LoadBalancer.Subchannel subchannel : this.getSubchannels()) {
                ConnectivityStateInfo stateInfo = (ConnectivityStateInfo)RoundRobinLoadBalancer.getSubchannelStateInfoRef((LoadBalancer.Subchannel)subchannel).value;
                if (stateInfo.getState() == ConnectivityState.CONNECTING || stateInfo.getState() == ConnectivityState.IDLE) {
                    isConnecting = true;
                }
                if (aggStatus != EMPTY_OK && aggStatus.isOk()) continue;
                aggStatus = stateInfo.getStatus();
            }
            this.updateBalancingState(isConnecting ? ConnectivityState.CONNECTING : ConnectivityState.TRANSIENT_FAILURE, new EmptyPicker(aggStatus));
        } else {
            int startIndex = this.random.nextInt(activeList.size());
            this.updateBalancingState(ConnectivityState.READY, new ReadyPicker(activeList, startIndex));
        }
    }

    private void updateBalancingState(ConnectivityState state, RoundRobinPicker picker) {
        if (state != this.currentState || !picker.isEquivalentTo(this.currentPicker)) {
            this.helper.updateBalancingState(state, (LoadBalancer.SubchannelPicker)picker);
            this.currentState = state;
            this.currentPicker = picker;
        }
    }

    private static List<LoadBalancer.Subchannel> filterNonFailingSubchannels(Collection<LoadBalancer.Subchannel> subchannels) {
        ArrayList<LoadBalancer.Subchannel> readySubchannels = new ArrayList<LoadBalancer.Subchannel>(subchannels.size());
        for (LoadBalancer.Subchannel subchannel : subchannels) {
            if (!RoundRobinLoadBalancer.isReady(subchannel)) continue;
            readySubchannels.add(subchannel);
        }
        return readySubchannels;
    }

    private static Map<EquivalentAddressGroup, EquivalentAddressGroup> stripAttrs(List<EquivalentAddressGroup> groupList) {
        HashMap<EquivalentAddressGroup, EquivalentAddressGroup> addrs = new HashMap<EquivalentAddressGroup, EquivalentAddressGroup>(groupList.size() * 2);
        for (EquivalentAddressGroup group : groupList) {
            addrs.put(RoundRobinLoadBalancer.stripAttrs(group), group);
        }
        return addrs;
    }

    private static EquivalentAddressGroup stripAttrs(EquivalentAddressGroup eag) {
        return new EquivalentAddressGroup(eag.getAddresses());
    }

    @VisibleForTesting
    Collection<LoadBalancer.Subchannel> getSubchannels() {
        return this.subchannels.values();
    }

    private static Ref<ConnectivityStateInfo> getSubchannelStateInfoRef(LoadBalancer.Subchannel subchannel) {
        return (Ref)Preconditions.checkNotNull((Object)subchannel.getAttributes().get(STATE_INFO), (Object)"STATE_INFO");
    }

    static boolean isReady(LoadBalancer.Subchannel subchannel) {
        return ((ConnectivityStateInfo)RoundRobinLoadBalancer.getSubchannelStateInfoRef((LoadBalancer.Subchannel)subchannel).value).getState() == ConnectivityState.READY;
    }

    private static <T> Set<T> setsDifference(Set<T> a, Set<T> b) {
        HashSet<T> aCopy = new HashSet<T>(a);
        aCopy.removeAll(b);
        return aCopy;
    }

    @VisibleForTesting
    static final class Ref<T> {
        T value;

        Ref(T value) {
            this.value = value;
        }
    }

    @VisibleForTesting
    static final class EmptyPicker
    extends RoundRobinPicker {
        private final Status status;

        EmptyPicker(@Nonnull Status status) {
            this.status = (Status)Preconditions.checkNotNull((Object)status, (Object)"status");
        }

        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            return this.status.isOk() ? LoadBalancer.PickResult.withNoResult() : LoadBalancer.PickResult.withError((Status)this.status);
        }

        @Override
        boolean isEquivalentTo(RoundRobinPicker picker) {
            return picker instanceof EmptyPicker && (Objects.equal((Object)this.status, (Object)((EmptyPicker)picker).status) || this.status.isOk() && ((EmptyPicker)picker).status.isOk());
        }

        public String toString() {
            return MoreObjects.toStringHelper(EmptyPicker.class).add("status", (Object)this.status).toString();
        }
    }

    @VisibleForTesting
    static final class ReadyPicker
    extends RoundRobinPicker {
        private static final AtomicIntegerFieldUpdater<ReadyPicker> indexUpdater = AtomicIntegerFieldUpdater.newUpdater(ReadyPicker.class, "index");
        private final List<LoadBalancer.Subchannel> list;
        private volatile int index;

        ReadyPicker(List<LoadBalancer.Subchannel> list, int startIndex) {
            Preconditions.checkArgument((!list.isEmpty() ? 1 : 0) != 0, (Object)"empty list");
            this.list = list;
            this.index = startIndex - 1;
        }

        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            return LoadBalancer.PickResult.withSubchannel((LoadBalancer.Subchannel)this.nextSubchannel());
        }

        public String toString() {
            return MoreObjects.toStringHelper(ReadyPicker.class).add("list", this.list).toString();
        }

        private LoadBalancer.Subchannel nextSubchannel() {
            int size = this.list.size();
            int i = indexUpdater.incrementAndGet(this);
            if (i >= size) {
                int oldi = i;
                indexUpdater.compareAndSet(this, oldi, i %= size);
            }
            return this.list.get(i);
        }

        @VisibleForTesting
        List<LoadBalancer.Subchannel> getList() {
            return this.list;
        }

        @Override
        boolean isEquivalentTo(RoundRobinPicker picker) {
            if (!(picker instanceof ReadyPicker)) {
                return false;
            }
            ReadyPicker other = (ReadyPicker)picker;
            return other == this || this.list.size() == other.list.size() && new HashSet<LoadBalancer.Subchannel>(this.list).containsAll(other.list);
        }
    }

    private static abstract class RoundRobinPicker
    extends LoadBalancer.SubchannelPicker {
        private RoundRobinPicker() {
        }

        abstract boolean isEquivalentTo(RoundRobinPicker var1);
    }
}

