/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.cronet;

import android.util.Log;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.errorprone.annotations.DoNotCall;
import io.grpc.ChannelCredentials;
import io.grpc.ChannelLogger;
import io.grpc.ExperimentalApi;
import io.grpc.ForwardingChannelBuilder2;
import io.grpc.Internal;
import io.grpc.ManagedChannelBuilder;
import io.grpc.cronet.CronetClientTransport;
import io.grpc.internal.ClientTransportFactory;
import io.grpc.internal.ConnectionClientTransport;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.ManagedChannelImplBuilder;
import io.grpc.internal.SharedResourceHolder;
import io.grpc.internal.TransportTracer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;
import org.chromium.net.BidirectionalStream;
import org.chromium.net.CronetEngine;
import org.chromium.net.ExperimentalBidirectionalStream;
import org.chromium.net.ExperimentalCronetEngine;

@ExperimentalApi(value="There is no plan to make this API stable, given transport API instability")
public final class CronetChannelBuilder
extends ForwardingChannelBuilder2<CronetChannelBuilder> {
    private static final String LOG_TAG = "CronetChannelBuilder";
    @Nullable
    private ScheduledExecutorService scheduledExecutorService;
    private final CronetEngine cronetEngine;
    private final ManagedChannelImplBuilder managedChannelImplBuilder;
    private TransportTracer.Factory transportTracerFactory = TransportTracer.getDefaultFactory();
    private boolean alwaysUsePut = false;
    private int maxMessageSize = 0x400000;
    private final boolean useGetForSafeMethods = false;
    private final boolean usePutForIdempotentMethods = false;
    private boolean trafficStatsTagSet;
    private int trafficStatsTag;
    private boolean trafficStatsUidSet;
    private int trafficStatsUid;

    public static CronetChannelBuilder forAddress(String host, int port, CronetEngine cronetEngine) {
        Preconditions.checkNotNull((Object)cronetEngine, (Object)"cronetEngine");
        return new CronetChannelBuilder(host, port, cronetEngine);
    }

    @DoNotCall(value="Unsupported. Use forAddress(String, int, CronetEngine) instead")
    public static CronetChannelBuilder forTarget(String target) {
        throw new UnsupportedOperationException("call forAddress() instead");
    }

    @DoNotCall(value="Unsupported. Use forAddress(String, int, CronetEngine) instead")
    public static CronetChannelBuilder forAddress(String name, int port) {
        throw new UnsupportedOperationException("call forAddress(String, int, CronetEngine) instead");
    }

    private CronetChannelBuilder(String host, int port, CronetEngine cronetEngine) {
        final class CronetChannelTransportFactoryBuilder
        implements ManagedChannelImplBuilder.ClientTransportFactoryBuilder {
            CronetChannelTransportFactoryBuilder() {
            }

            public ClientTransportFactory buildClientTransportFactory() {
                return CronetChannelBuilder.this.buildTransportFactory();
            }
        }
        this.managedChannelImplBuilder = new ManagedChannelImplBuilder((SocketAddress)InetSocketAddress.createUnresolved(host, port), GrpcUtil.authorityFromHostAndPort((String)host, (int)port), (ManagedChannelImplBuilder.ClientTransportFactoryBuilder)new CronetChannelTransportFactoryBuilder(), null);
        this.cronetEngine = (CronetEngine)Preconditions.checkNotNull((Object)cronetEngine, (Object)"cronetEngine");
    }

    @Internal
    protected ManagedChannelBuilder<?> delegate() {
        return this.managedChannelImplBuilder;
    }

    public final CronetChannelBuilder maxMessageSize(int maxMessageSize) {
        Preconditions.checkArgument((maxMessageSize >= 0 ? 1 : 0) != 0, (Object)"maxMessageSize must be >= 0");
        this.maxMessageSize = maxMessageSize;
        return this;
    }

    public final CronetChannelBuilder alwaysUsePut(boolean enable) {
        this.alwaysUsePut = enable;
        return this;
    }

    final CronetChannelBuilder setTrafficStatsTag(int tag) {
        this.trafficStatsTagSet = true;
        this.trafficStatsTag = tag;
        return this;
    }

    final CronetChannelBuilder setTrafficStatsUid(int uid) {
        this.trafficStatsUidSet = true;
        this.trafficStatsUid = uid;
        return this;
    }

    public final CronetChannelBuilder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = (ScheduledExecutorService)Preconditions.checkNotNull((Object)scheduledExecutorService, (Object)"scheduledExecutorService");
        return this;
    }

    ClientTransportFactory buildTransportFactory() {
        return new CronetTransportFactory(new TaggingStreamFactory(this.cronetEngine, this.trafficStatsTagSet, this.trafficStatsTag, this.trafficStatsUidSet, this.trafficStatsUid), MoreExecutors.directExecutor(), this.scheduledExecutorService, this.maxMessageSize, this.alwaysUsePut, this.transportTracerFactory.create(), false, false);
    }

    private static class TaggingStreamFactory
    extends StreamBuilderFactory {
        private static volatile boolean loadSetTrafficStatsTagAttempted;
        private static volatile boolean loadSetTrafficStatsUidAttempted;
        private static volatile Method setTrafficStatsTagMethod;
        private static volatile Method setTrafficStatsUidMethod;
        private final CronetEngine cronetEngine;
        private final boolean trafficStatsTagSet;
        private final int trafficStatsTag;
        private final boolean trafficStatsUidSet;
        private final int trafficStatsUid;

        TaggingStreamFactory(CronetEngine cronetEngine, boolean trafficStatsTagSet, int trafficStatsTag, boolean trafficStatsUidSet, int trafficStatsUid) {
            this.cronetEngine = cronetEngine;
            this.trafficStatsTagSet = trafficStatsTagSet;
            this.trafficStatsTag = trafficStatsTag;
            this.trafficStatsUidSet = trafficStatsUidSet;
            this.trafficStatsUid = trafficStatsUid;
        }

        @Override
        public BidirectionalStream.Builder newBidirectionalStreamBuilder(String url, BidirectionalStream.Callback callback, Executor executor) {
            ExperimentalBidirectionalStream.Builder builder = ((ExperimentalCronetEngine)this.cronetEngine).newBidirectionalStreamBuilder(url, callback, executor);
            if (this.trafficStatsTagSet) {
                TaggingStreamFactory.setTrafficStatsTag(builder, this.trafficStatsTag);
            }
            if (this.trafficStatsUidSet) {
                TaggingStreamFactory.setTrafficStatsUid(builder, this.trafficStatsUid);
            }
            return builder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private static void setTrafficStatsTag(ExperimentalBidirectionalStream.Builder builder, int tag) {
            if (!loadSetTrafficStatsTagAttempted) {
                Class<TaggingStreamFactory> clazz = TaggingStreamFactory.class;
                // MONITORENTER : io.grpc.cronet.CronetChannelBuilder$TaggingStreamFactory.class
                if (!loadSetTrafficStatsTagAttempted) {
                    try {
                        setTrafficStatsTagMethod = ExperimentalBidirectionalStream.Builder.class.getMethod("setTrafficStatsTag", Integer.TYPE);
                    }
                    catch (NoSuchMethodException e) {
                        Log.w((String)CronetChannelBuilder.LOG_TAG, (String)"Failed to load method ExperimentalBidirectionalStream.Builder.setTrafficStatsTag", (Throwable)e);
                    }
                    finally {
                        loadSetTrafficStatsTagAttempted = true;
                    }
                }
                // MONITOREXIT : clazz
            }
            if (setTrafficStatsTagMethod == null) return;
            try {
                setTrafficStatsTagMethod.invoke((Object)builder, tag);
                return;
            }
            catch (InvocationTargetException e) {
                Throwable throwable;
                if (e.getCause() == null) {
                    throwable = e.getTargetException();
                    throw new RuntimeException(throwable);
                }
                throwable = e.getCause();
                throw new RuntimeException(throwable);
            }
            catch (IllegalAccessException e) {
                Log.w((String)CronetChannelBuilder.LOG_TAG, (String)("Failed to set traffic stats tag: " + tag), (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private static void setTrafficStatsUid(ExperimentalBidirectionalStream.Builder builder, int uid) {
            if (!loadSetTrafficStatsUidAttempted) {
                Class<TaggingStreamFactory> clazz = TaggingStreamFactory.class;
                // MONITORENTER : io.grpc.cronet.CronetChannelBuilder$TaggingStreamFactory.class
                if (!loadSetTrafficStatsUidAttempted) {
                    try {
                        setTrafficStatsUidMethod = ExperimentalBidirectionalStream.Builder.class.getMethod("setTrafficStatsUid", Integer.TYPE);
                    }
                    catch (NoSuchMethodException e) {
                        Log.w((String)CronetChannelBuilder.LOG_TAG, (String)"Failed to load method ExperimentalBidirectionalStream.Builder.setTrafficStatsUid", (Throwable)e);
                    }
                    finally {
                        loadSetTrafficStatsUidAttempted = true;
                    }
                }
                // MONITOREXIT : clazz
            }
            if (setTrafficStatsUidMethod == null) return;
            try {
                setTrafficStatsUidMethod.invoke((Object)builder, uid);
                return;
            }
            catch (InvocationTargetException e) {
                Throwable throwable;
                if (e.getCause() == null) {
                    throwable = e.getTargetException();
                    throw new RuntimeException(throwable);
                }
                throwable = e.getCause();
                throw new RuntimeException(throwable);
            }
            catch (IllegalAccessException e) {
                Log.w((String)CronetChannelBuilder.LOG_TAG, (String)("Failed to set traffic stats uid: " + uid), (Throwable)e);
            }
        }
    }

    @VisibleForTesting
    static class CronetTransportFactory
    implements ClientTransportFactory {
        private final ScheduledExecutorService timeoutService;
        private final Executor executor;
        private final int maxMessageSize;
        private final boolean alwaysUsePut;
        private final StreamBuilderFactory streamFactory;
        private final TransportTracer transportTracer;
        private final boolean usingSharedScheduler;
        private final boolean useGetForSafeMethods;
        private final boolean usePutForIdempotentMethods;

        private CronetTransportFactory(StreamBuilderFactory streamFactory, Executor executor, @Nullable ScheduledExecutorService timeoutService, int maxMessageSize, boolean alwaysUsePut, TransportTracer transportTracer, boolean useGetForSafeMethods, boolean usePutForIdempotentMethods) {
            this.usingSharedScheduler = timeoutService == null;
            this.timeoutService = this.usingSharedScheduler ? (ScheduledExecutorService)SharedResourceHolder.get((SharedResourceHolder.Resource)GrpcUtil.TIMER_SERVICE) : timeoutService;
            this.maxMessageSize = maxMessageSize;
            this.alwaysUsePut = alwaysUsePut;
            this.streamFactory = streamFactory;
            this.executor = (Executor)Preconditions.checkNotNull((Object)executor, (Object)"executor");
            this.transportTracer = (TransportTracer)Preconditions.checkNotNull((Object)transportTracer, (Object)"transportTracer");
            this.useGetForSafeMethods = useGetForSafeMethods;
            this.usePutForIdempotentMethods = usePutForIdempotentMethods;
        }

        public ConnectionClientTransport newClientTransport(SocketAddress addr, ClientTransportFactory.ClientTransportOptions options, ChannelLogger channelLogger) {
            InetSocketAddress inetSocketAddr = (InetSocketAddress)addr;
            return new CronetClientTransport(this.streamFactory, inetSocketAddr, options.getAuthority(), options.getUserAgent(), options.getEagAttributes(), this.executor, this.maxMessageSize, this.alwaysUsePut, this.transportTracer, this.useGetForSafeMethods, this.usePutForIdempotentMethods);
        }

        public ScheduledExecutorService getScheduledExecutorService() {
            return this.timeoutService;
        }

        public ClientTransportFactory.SwapChannelCredentialsResult swapChannelCredentials(ChannelCredentials channelCreds) {
            return null;
        }

        public void close() {
            if (this.usingSharedScheduler) {
                SharedResourceHolder.release((SharedResourceHolder.Resource)GrpcUtil.TIMER_SERVICE, (Object)this.timeoutService);
            }
        }

        public Collection<Class<? extends SocketAddress>> getSupportedSocketAddressTypes() {
            return Collections.singleton(InetSocketAddress.class);
        }
    }

    public static abstract class StreamBuilderFactory {
        public abstract BidirectionalStream.Builder newBidirectionalStreamBuilder(String var1, BidirectionalStream.Callback var2, Executor var3);
    }
}

