/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.cronet;

import android.util.Log;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import io.grpc.Attributes;
import io.grpc.CallOptions;
import io.grpc.InternalMetadata;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.cronet.CronetChannelBuilder;
import io.grpc.cronet.CronetClientTransport;
import io.grpc.cronet.CronetWritableBuffer;
import io.grpc.cronet.CronetWritableBufferAllocator;
import io.grpc.internal.AbstractClientStream;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.Http2ClientStreamTransportState;
import io.grpc.internal.ReadableBuffers;
import io.grpc.internal.StatsTraceContext;
import io.grpc.internal.TransportFrameUtil;
import io.grpc.internal.TransportTracer;
import io.grpc.internal.WritableBuffer;
import io.grpc.internal.WritableBufferAllocator;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.chromium.net.BidirectionalStream;
import org.chromium.net.CronetException;
import org.chromium.net.ExperimentalBidirectionalStream;
import org.chromium.net.UrlResponseInfo;

class CronetClientStream
extends AbstractClientStream {
    private static final int READ_BUFFER_CAPACITY = 4096;
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocateDirect(0);
    private static final String LOG_TAG = "grpc-java-cronet";
    private static volatile boolean loadAddRequestAnnotationAttempted;
    private static volatile Method addRequestAnnotationMethod;
    @Deprecated
    static final CallOptions.Key<Object> CRONET_ANNOTATION_KEY;
    static final CallOptions.Key<Collection<Object>> CRONET_ANNOTATIONS_KEY;
    private final String url;
    private final String userAgent;
    private final StatsTraceContext statsTraceCtx;
    private final Executor executor;
    private final Metadata headers;
    private final CronetClientTransport transport;
    private final Runnable startCallback;
    @VisibleForTesting
    final boolean idempotent;
    private BidirectionalStream stream;
    private final boolean delayRequestHeader;
    private final Object annotation;
    private final Collection<Object> annotations;
    private final TransportState state;
    private final Sink sink = new Sink();
    private CronetChannelBuilder.StreamBuilderFactory streamFactory;

    CronetClientStream(String url, @Nullable String userAgent, Executor executor, Metadata headers, CronetClientTransport transport, Runnable startCallback, Object lock, int maxMessageSize, boolean alwaysUsePut, MethodDescriptor<?, ?> method, StatsTraceContext statsTraceCtx, CallOptions callOptions, TransportTracer transportTracer, boolean useGetForSafeMethods, boolean usePutForIdempotentMethods) {
        super((WritableBufferAllocator)new CronetWritableBufferAllocator(), statsTraceCtx, transportTracer, headers, callOptions, useGetForSafeMethods && method.isSafe());
        this.url = (String)Preconditions.checkNotNull((Object)url, (Object)"url");
        this.userAgent = (String)Preconditions.checkNotNull((Object)userAgent, (Object)"userAgent");
        this.statsTraceCtx = (StatsTraceContext)Preconditions.checkNotNull((Object)statsTraceCtx, (Object)"statsTraceCtx");
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor, (Object)"executor");
        this.headers = (Metadata)Preconditions.checkNotNull((Object)headers, (Object)"headers");
        this.transport = (CronetClientTransport)Preconditions.checkNotNull((Object)transport, (Object)"transport");
        this.startCallback = (Runnable)Preconditions.checkNotNull((Object)startCallback, (Object)"startCallback");
        this.idempotent = usePutForIdempotentMethods && method.isIdempotent() || alwaysUsePut;
        this.delayRequestHeader = method.getType() == MethodDescriptor.MethodType.UNARY;
        this.annotation = callOptions.getOption(CRONET_ANNOTATION_KEY);
        this.annotations = (Collection)callOptions.getOption(CRONET_ANNOTATIONS_KEY);
        this.state = new TransportState(maxMessageSize, statsTraceCtx, lock, transportTracer);
        this.optimizeForDirectExecutor();
    }

    protected TransportState transportState() {
        return this.state;
    }

    protected Sink abstractClientStreamSink() {
        return this.sink;
    }

    public void setAuthority(String authority) {
        throw new UnsupportedOperationException("Cronet does not support overriding authority");
    }

    static CallOptions withAnnotation(CallOptions callOptions, Object annotation) {
        Collection existingAnnotations = (Collection)callOptions.getOption(CRONET_ANNOTATIONS_KEY);
        ArrayList<Object> newAnnotations = existingAnnotations == null ? new ArrayList<Object>() : new ArrayList(existingAnnotations);
        newAnnotations.add(annotation);
        return callOptions.withOption(CRONET_ANNOTATIONS_KEY, Collections.unmodifiableList(newAnnotations));
    }

    private static boolean isApplicationHeader(String key) {
        return !GrpcUtil.CONTENT_TYPE_KEY.name().equalsIgnoreCase(key) && !GrpcUtil.USER_AGENT_KEY.name().equalsIgnoreCase(key) && !GrpcUtil.TE_HEADER.name().equalsIgnoreCase(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static void addRequestAnnotation(ExperimentalBidirectionalStream.Builder builder, Object annotation) {
        if (!loadAddRequestAnnotationAttempted) {
            Class<CronetClientStream> clazz = CronetClientStream.class;
            // MONITORENTER : io.grpc.cronet.CronetClientStream.class
            if (!loadAddRequestAnnotationAttempted) {
                try {
                    addRequestAnnotationMethod = ExperimentalBidirectionalStream.Builder.class.getMethod("addRequestAnnotation", Object.class);
                }
                catch (NoSuchMethodException e) {
                    Log.w((String)LOG_TAG, (String)"Failed to load method ExperimentalBidirectionalStream.Builder.addRequestAnnotation", (Throwable)e);
                }
                finally {
                    loadAddRequestAnnotationAttempted = true;
                }
            }
            // MONITOREXIT : clazz
        }
        if (addRequestAnnotationMethod == null) return;
        try {
            addRequestAnnotationMethod.invoke((Object)builder, annotation);
            return;
        }
        catch (InvocationTargetException e) {
            Throwable throwable;
            if (e.getCause() == null) {
                throwable = e.getTargetException();
                throw new RuntimeException(throwable);
            }
            throwable = e.getCause();
            throw new RuntimeException(throwable);
        }
        catch (IllegalAccessException e) {
            Log.w((String)LOG_TAG, (String)("Failed to add request annotation: " + annotation), (Throwable)e);
        }
    }

    private void setGrpcHeaders(BidirectionalStream.Builder builder) {
        builder.addHeader(GrpcUtil.USER_AGENT_KEY.name(), this.userAgent);
        builder.addHeader(GrpcUtil.CONTENT_TYPE_KEY.name(), "application/grpc");
        builder.addHeader("te", "trailers");
        byte[][] serializedHeaders = TransportFrameUtil.toHttp2Headers((Metadata)this.headers);
        for (int i = 0; i < serializedHeaders.length; i += 2) {
            String key = new String(serializedHeaders[i], Charset.forName("UTF-8"));
            if (!CronetClientStream.isApplicationHeader(key)) continue;
            String value = new String(serializedHeaders[i + 1], Charset.forName("UTF-8"));
            builder.addHeader(key, value);
        }
    }

    private void streamWrite(ByteBuffer buffer, boolean endOfStream, boolean flush) {
        if (this.stream == null) {
            return;
        }
        if (Log.isLoggable((String)LOG_TAG, (int)2)) {
            Log.v((String)LOG_TAG, (String)"BidirectionalStream.write");
        }
        this.stream.write(buffer, endOfStream);
        if (flush) {
            if (Log.isLoggable((String)LOG_TAG, (int)2)) {
                Log.v((String)LOG_TAG, (String)"BidirectionalStream.flush");
            }
            this.stream.flush();
        }
    }

    private void finishStream(Status status) {
        this.transport.finishStream(this, status);
    }

    public Attributes getAttributes() {
        return Attributes.EMPTY;
    }

    static {
        CRONET_ANNOTATION_KEY = CallOptions.Key.create((String)"cronet-annotation");
        CRONET_ANNOTATIONS_KEY = CallOptions.Key.create((String)"cronet-annotations");
    }

    private static class PendingData {
        ByteBuffer buffer;
        boolean endOfStream;
        boolean flush;

        PendingData(ByteBuffer buffer, boolean endOfStream, boolean flush) {
            this.buffer = buffer;
            this.endOfStream = endOfStream;
            this.flush = flush;
        }
    }

    class BidirectionalStreamCallback
    extends BidirectionalStream.Callback {
        private List<Map.Entry<String, String>> trailerList;

        BidirectionalStreamCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onStreamReady(BidirectionalStream stream) {
            if (Log.isLoggable((String)CronetClientStream.LOG_TAG, (int)2)) {
                Log.v((String)CronetClientStream.LOG_TAG, (String)"onStreamReady");
            }
            Object object = CronetClientStream.this.state.lock;
            synchronized (object) {
                CronetClientStream.this.state.onStreamAllocated();
                CronetClientStream.this.state.streamReady = true;
                CronetClientStream.this.state.writeAllPendingData();
            }
        }

        public void onResponseHeadersReceived(BidirectionalStream stream, UrlResponseInfo info) {
            if (Log.isLoggable((String)CronetClientStream.LOG_TAG, (int)2)) {
                Log.v((String)CronetClientStream.LOG_TAG, (String)("onResponseHeadersReceived. Header=" + info.getAllHeadersAsList()));
                Log.v((String)CronetClientStream.LOG_TAG, (String)"BidirectionalStream.read");
            }
            this.reportHeaders(info.getAllHeadersAsList(), false);
            stream.read(ByteBuffer.allocateDirect(4096));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReadCompleted(BidirectionalStream stream, UrlResponseInfo info, ByteBuffer buffer, boolean endOfStream) {
            ((Buffer)buffer).flip();
            if (Log.isLoggable((String)CronetClientStream.LOG_TAG, (int)2)) {
                Log.v((String)CronetClientStream.LOG_TAG, (String)("onReadCompleted. Size=" + buffer.remaining()));
            }
            Object object = CronetClientStream.this.state.lock;
            synchronized (object) {
                CronetClientStream.this.state.readClosed = endOfStream;
                if (buffer.remaining() != 0) {
                    CronetClientStream.this.state.transportDataReceived(buffer, false);
                }
            }
            if (endOfStream && this.trailerList != null) {
                this.reportHeaders(this.trailerList, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onWriteCompleted(BidirectionalStream stream, UrlResponseInfo info, ByteBuffer buffer, boolean endOfStream) {
            if (Log.isLoggable((String)CronetClientStream.LOG_TAG, (int)2)) {
                Log.v((String)CronetClientStream.LOG_TAG, (String)"onWriteCompleted");
            }
            Object object = CronetClientStream.this.state.lock;
            synchronized (object) {
                if (!CronetClientStream.this.state.firstWriteComplete) {
                    CronetClientStream.this.state.firstWriteComplete = true;
                    CronetClientStream.this.statsTraceCtx.clientOutboundHeaders();
                }
                CronetClientStream.this.state.onSentBytes(buffer.position());
            }
        }

        public void onResponseTrailersReceived(BidirectionalStream stream, UrlResponseInfo info, UrlResponseInfo.HeaderBlock trailers) {
            this.processTrailers(trailers.getAsList());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @VisibleForTesting
        void processTrailers(List<Map.Entry<String, String>> trailerList) {
            boolean readClosed;
            this.trailerList = trailerList;
            Object object = CronetClientStream.this.state.lock;
            synchronized (object) {
                readClosed = CronetClientStream.this.state.readClosed;
            }
            if (readClosed) {
                this.reportHeaders(trailerList, true);
            }
            if (Log.isLoggable((String)CronetClientStream.LOG_TAG, (int)2)) {
                Log.v((String)CronetClientStream.LOG_TAG, (String)("onResponseTrailersReceived. Trailer=" + trailerList.toString()));
            }
        }

        public void onSucceeded(BidirectionalStream stream, UrlResponseInfo info) {
            if (Log.isLoggable((String)CronetClientStream.LOG_TAG, (int)2)) {
                Log.v((String)CronetClientStream.LOG_TAG, (String)"onSucceeded");
            }
            if (!this.haveTrailersBeenReported()) {
                if (this.trailerList != null) {
                    this.reportHeaders(this.trailerList, true);
                } else if (info != null) {
                    this.reportHeaders(info.getAllHeadersAsList(), true);
                } else {
                    throw new AssertionError((Object)"No response header or trailer");
                }
            }
            CronetClientStream.this.finishStream(this.toGrpcStatus(info));
        }

        public void onFailed(BidirectionalStream stream, UrlResponseInfo info, CronetException error) {
            if (Log.isLoggable((String)CronetClientStream.LOG_TAG, (int)2)) {
                Log.v((String)CronetClientStream.LOG_TAG, (String)"onFailed");
            }
            CronetClientStream.this.finishStream(Status.UNAVAILABLE.withCause((Throwable)error));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCanceled(BidirectionalStream stream, UrlResponseInfo info) {
            Status status;
            if (Log.isLoggable((String)CronetClientStream.LOG_TAG, (int)2)) {
                Log.v((String)CronetClientStream.LOG_TAG, (String)"onCanceled");
            }
            Object object = CronetClientStream.this.state.lock;
            synchronized (object) {
                status = CronetClientStream.this.state.cancelReason != null ? CronetClientStream.this.state.cancelReason : (info != null ? this.toGrpcStatus(info) : Status.CANCELLED.withDescription("stream cancelled without reason"));
            }
            CronetClientStream.this.finishStream(status);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reportHeaders(List<Map.Entry<String, String>> headers, boolean endOfStream) {
            ArrayList<String> headerList = new ArrayList<String>();
            for (Map.Entry<String, String> entry : headers) {
                headerList.add(entry.getKey());
                headerList.add(entry.getValue());
            }
            byte[][] headerValues = new byte[headerList.size()][];
            for (int i = 0; i < headerList.size(); i += 2) {
                headerValues[i] = ((String)headerList.get(i)).getBytes(Charset.forName("UTF-8"));
                headerValues[i + 1] = ((String)headerList.get(i + 1)).getBytes(Charset.forName("UTF-8"));
            }
            Metadata metadata = InternalMetadata.newMetadata((byte[][])TransportFrameUtil.toRawSerializedHeaders((byte[][])headerValues));
            Object object = CronetClientStream.this.state.lock;
            synchronized (object) {
                CronetClientStream.this.state.transportHeadersReceived(metadata, endOfStream);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean haveTrailersBeenReported() {
            Object object = CronetClientStream.this.state.lock;
            synchronized (object) {
                return this.trailerList != null && CronetClientStream.this.state.readClosed;
            }
        }

        private Status toGrpcStatus(UrlResponseInfo info) {
            return GrpcUtil.httpStatusToGrpcStatus((int)info.getHttpStatusCode());
        }
    }

    class TransportState
    extends Http2ClientStreamTransportState {
        private final Object lock;
        @GuardedBy(value="lock")
        private Collection<PendingData> pendingData;
        @GuardedBy(value="lock")
        private boolean streamReady;
        @GuardedBy(value="lock")
        private boolean cancelSent;
        @GuardedBy(value="lock")
        private int bytesPendingProcess;
        @GuardedBy(value="lock")
        private Status cancelReason;
        @GuardedBy(value="lock")
        private boolean readClosed;
        @GuardedBy(value="lock")
        private boolean firstWriteComplete;

        public TransportState(int maxMessageSize, StatsTraceContext statsTraceCtx, Object lock, TransportTracer transportTracer) {
            super(maxMessageSize, statsTraceCtx, transportTracer);
            this.pendingData = new ArrayList<PendingData>();
            this.cancelSent = false;
            this.lock = Preconditions.checkNotNull((Object)lock, (Object)"lock");
        }

        @GuardedBy(value="lock")
        public void start(CronetChannelBuilder.StreamBuilderFactory factory) {
            CronetClientStream.this.streamFactory = factory;
        }

        @GuardedBy(value="lock")
        protected void onStreamAllocated() {
            super.onStreamAllocated();
        }

        @GuardedBy(value="lock")
        protected void http2ProcessingFailed(Status status, boolean stopDelivery, Metadata trailers) {
            Preconditions.checkNotNull((Object)CronetClientStream.this.stream, (Object)"stream must not be null");
            CronetClientStream.this.stream.cancel();
            this.transportReportStatus(status, stopDelivery, trailers);
        }

        @GuardedBy(value="lock")
        public void deframeFailed(Throwable cause) {
            this.http2ProcessingFailed(Status.fromThrowable((Throwable)cause), true, new Metadata());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runOnTransportThread(Runnable r) {
            Object object = this.lock;
            synchronized (object) {
                r.run();
            }
        }

        @GuardedBy(value="lock")
        public void bytesRead(int processedBytes) {
            Preconditions.checkNotNull((Object)CronetClientStream.this.stream, (Object)"stream must not be null");
            this.bytesPendingProcess -= processedBytes;
            if (this.bytesPendingProcess == 0 && !this.readClosed) {
                if (Log.isLoggable((String)CronetClientStream.LOG_TAG, (int)2)) {
                    Log.v((String)CronetClientStream.LOG_TAG, (String)"BidirectionalStream.read");
                }
                CronetClientStream.this.stream.read(ByteBuffer.allocateDirect(4096));
            }
        }

        @GuardedBy(value="lock")
        private void transportHeadersReceived(Metadata metadata, boolean endOfStream) {
            if (endOfStream) {
                this.transportTrailersReceived(metadata);
            } else {
                this.transportHeadersReceived(metadata);
            }
        }

        @GuardedBy(value="lock")
        private void transportDataReceived(ByteBuffer buffer, boolean endOfStream) {
            this.bytesPendingProcess += buffer.remaining();
            super.transportDataReceived(ReadableBuffers.wrap((ByteBuffer)buffer), endOfStream);
        }

        @GuardedBy(value="lock")
        private void clearPendingData() {
            for (PendingData data : this.pendingData) {
                data.buffer.clear();
            }
            this.pendingData.clear();
        }

        @GuardedBy(value="lock")
        private void enqueuePendingData(PendingData data) {
            this.pendingData.add(data);
        }

        @GuardedBy(value="lock")
        private void writeAllPendingData() {
            for (PendingData data : this.pendingData) {
                CronetClientStream.this.streamWrite(data.buffer, data.endOfStream, data.flush);
            }
            this.pendingData.clear();
        }
    }

    class Sink
    implements AbstractClientStream.Sink {
        Sink() {
        }

        public void writeHeaders(Metadata metadata, byte[] payload) {
            CronetClientStream.this.startCallback.run();
            if (CronetClientStream.this.streamFactory == null) {
                return;
            }
            BidirectionalStreamCallback callback = new BidirectionalStreamCallback();
            String path = CronetClientStream.this.url;
            if (payload != null) {
                path = path + "?" + BaseEncoding.base64().encode(payload);
            }
            BidirectionalStream.Builder builder = CronetClientStream.this.streamFactory.newBidirectionalStreamBuilder(path, callback, CronetClientStream.this.executor);
            if (payload != null) {
                builder.setHttpMethod("GET");
            } else if (CronetClientStream.this.idempotent) {
                builder.setHttpMethod("PUT");
            }
            if (CronetClientStream.this.delayRequestHeader) {
                builder.delayRequestHeadersUntilFirstFlush(true);
            }
            if (CronetClientStream.this.annotation != null || CronetClientStream.this.annotations != null) {
                ExperimentalBidirectionalStream.Builder expBidiStreamBuilder = (ExperimentalBidirectionalStream.Builder)builder;
                if (CronetClientStream.this.annotation != null) {
                    CronetClientStream.addRequestAnnotation(expBidiStreamBuilder, CronetClientStream.this.annotation);
                }
                if (CronetClientStream.this.annotations != null) {
                    for (Object o : CronetClientStream.this.annotations) {
                        CronetClientStream.addRequestAnnotation(expBidiStreamBuilder, o);
                    }
                }
            }
            CronetClientStream.this.setGrpcHeaders(builder);
            CronetClientStream.this.stream = builder.build();
            CronetClientStream.this.stream.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeFrame(WritableBuffer buffer, boolean endOfStream, boolean flush, int numMessages) {
            Object object = CronetClientStream.this.state.lock;
            synchronized (object) {
                ByteBuffer byteBuffer;
                if (CronetClientStream.this.state.cancelSent) {
                    return;
                }
                if (buffer != null) {
                    byteBuffer = ((CronetWritableBuffer)buffer).buffer();
                    ((Buffer)byteBuffer).flip();
                } else {
                    byteBuffer = EMPTY_BUFFER;
                }
                CronetClientStream.this.onSendingBytes(byteBuffer.remaining());
                if (!CronetClientStream.this.state.streamReady) {
                    CronetClientStream.this.state.enqueuePendingData(new PendingData(byteBuffer, endOfStream, flush));
                } else {
                    CronetClientStream.this.streamWrite(byteBuffer, endOfStream, flush);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel(Status reason) {
            Object object = CronetClientStream.this.state.lock;
            synchronized (object) {
                if (CronetClientStream.this.state.cancelSent) {
                    return;
                }
                CronetClientStream.this.state.cancelSent = true;
                CronetClientStream.this.state.cancelReason = reason;
                CronetClientStream.this.state.clearPendingData();
                if (CronetClientStream.this.stream != null) {
                    CronetClientStream.this.stream.cancel();
                } else {
                    CronetClientStream.this.transport.finishStream(CronetClientStream.this, reason);
                }
            }
        }
    }
}

