/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.cronet;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.grpc.Attributes;
import io.grpc.CallOptions;
import io.grpc.ClientStreamTracer;
import io.grpc.InternalChannelz;
import io.grpc.InternalLogId;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.SecurityLevel;
import io.grpc.Status;
import io.grpc.cronet.CronetChannelBuilder;
import io.grpc.cronet.CronetClientStream;
import io.grpc.internal.ClientTransport;
import io.grpc.internal.ConnectionClientTransport;
import io.grpc.internal.GrpcAttributes;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.ManagedClientTransport;
import io.grpc.internal.StatsTraceContext;
import io.grpc.internal.TransportTracer;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

class CronetClientTransport
implements ConnectionClientTransport {
    private final InternalLogId logId;
    private final InetSocketAddress address;
    private final String authority;
    private final String userAgent;
    private ManagedClientTransport.Listener listener;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private final Set<CronetClientStream> streams = Collections.newSetFromMap(new IdentityHashMap());
    private final Executor executor;
    private final int maxMessageSize;
    private final boolean alwaysUsePut;
    private final TransportTracer transportTracer;
    private final Attributes attrs;
    private final boolean useGetForSafeMethods;
    private final boolean usePutForIdempotentMethods;
    @GuardedBy(value="lock")
    private boolean goAway;
    @GuardedBy(value="lock")
    private boolean startedGoAway;
    @GuardedBy(value="lock")
    private Status goAwayStatus;
    @GuardedBy(value="lock")
    private boolean stopped;
    @GuardedBy(value="lock")
    private boolean started;
    private CronetChannelBuilder.StreamBuilderFactory streamFactory;

    CronetClientTransport(CronetChannelBuilder.StreamBuilderFactory streamFactory, InetSocketAddress address, String authority, @Nullable String userAgent, Attributes eagAttrs, Executor executor, int maxMessageSize, boolean alwaysUsePut, TransportTracer transportTracer, boolean useGetForSafeMethods, boolean usePutForIdempotentMethods) {
        this.address = (InetSocketAddress)Preconditions.checkNotNull((Object)address, (Object)"address");
        this.logId = InternalLogId.allocate(this.getClass(), (String)address.toString());
        this.authority = authority;
        this.userAgent = GrpcUtil.getGrpcUserAgent((String)"cronet", (String)userAgent);
        this.maxMessageSize = maxMessageSize;
        this.alwaysUsePut = alwaysUsePut;
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor, (Object)"executor");
        this.streamFactory = (CronetChannelBuilder.StreamBuilderFactory)Preconditions.checkNotNull((Object)streamFactory, (Object)"streamFactory");
        this.transportTracer = (TransportTracer)Preconditions.checkNotNull((Object)transportTracer, (Object)"transportTracer");
        this.attrs = Attributes.newBuilder().set(GrpcAttributes.ATTR_SECURITY_LEVEL, (Object)SecurityLevel.PRIVACY_AND_INTEGRITY).set(GrpcAttributes.ATTR_CLIENT_EAG_ATTRS, (Object)eagAttrs).build();
        this.useGetForSafeMethods = useGetForSafeMethods;
        this.usePutForIdempotentMethods = usePutForIdempotentMethods;
    }

    public ListenableFuture<InternalChannelz.SocketStats> getStats() {
        SettableFuture f = SettableFuture.create();
        f.set(null);
        return f;
    }

    public CronetClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers, CallOptions callOptions, ClientStreamTracer[] tracers) {
        Preconditions.checkNotNull(method, (Object)"method");
        Preconditions.checkNotNull((Object)headers, (Object)"headers");
        String defaultPath = "/" + method.getFullMethodName();
        String url = "https://" + this.authority + defaultPath;
        StatsTraceContext statsTraceCtx = StatsTraceContext.newClientContext((ClientStreamTracer[])tracers, (Attributes)this.attrs, (Metadata)headers);
        class StartCallback
        implements Runnable {
            final CronetClientStream clientStream;
            final /* synthetic */ String val$url;
            final /* synthetic */ Metadata val$headers;
            final /* synthetic */ MethodDescriptor val$method;
            final /* synthetic */ StatsTraceContext val$statsTraceCtx;
            final /* synthetic */ CallOptions val$callOptions;

            StartCallback() {
                this.val$url = string;
                this.val$headers = metadata;
                this.val$method = methodDescriptor;
                this.val$statsTraceCtx = statsTraceContext;
                this.val$callOptions = callOptions;
                this.clientStream = new CronetClientStream(this.val$url, CronetClientTransport.this.userAgent, CronetClientTransport.this.executor, this.val$headers, CronetClientTransport.this, this, CronetClientTransport.this.lock, CronetClientTransport.this.maxMessageSize, CronetClientTransport.this.alwaysUsePut, this.val$method, this.val$statsTraceCtx, this.val$callOptions, CronetClientTransport.this.transportTracer, CronetClientTransport.this.useGetForSafeMethods, CronetClientTransport.this.usePutForIdempotentMethods);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = CronetClientTransport.this.lock;
                synchronized (object) {
                    if (CronetClientTransport.this.goAway) {
                        this.clientStream.transportState().transportReportStatus(CronetClientTransport.this.goAwayStatus, true, new Metadata());
                    } else if (CronetClientTransport.this.started) {
                        CronetClientTransport.this.startStream(this.clientStream);
                    } else {
                        throw new AssertionError((Object)"Transport is not started");
                    }
                }
            }
        }
        return (CronetClientTransport)this.new StartCallback().clientStream;
    }

    @GuardedBy(value="lock")
    private void startStream(CronetClientStream stream) {
        this.streams.add(stream);
        stream.transportState().start(this.streamFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Runnable start(ManagedClientTransport.Listener listener) {
        this.listener = (ManagedClientTransport.Listener)Preconditions.checkNotNull((Object)listener, (Object)"listener");
        Object object = this.lock;
        synchronized (object) {
            this.started = true;
        }
        return new Runnable(){

            @Override
            public void run() {
                CronetClientTransport.this.listener.transportReady();
            }
        };
    }

    public String toString() {
        return super.toString() + "(" + this.address + ")";
    }

    public void shutdown() {
        this.shutdown(Status.UNAVAILABLE.withDescription("Transport stopped"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(Status status) {
        Object object = this.lock;
        synchronized (object) {
            if (this.goAway) {
                return;
            }
        }
        this.startGoAway(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownNow(Status status) {
        ArrayList<CronetClientStream> streamsCopy;
        this.shutdown(status);
        Object object = this.lock;
        synchronized (object) {
            streamsCopy = new ArrayList<CronetClientStream>(this.streams);
        }
        for (int i = 0; i < streamsCopy.size(); ++i) {
            streamsCopy.get(i).cancel(status);
        }
        this.stopIfNecessary();
    }

    public Attributes getAttributes() {
        return this.attrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startGoAway(Status status) {
        Object object = this.lock;
        synchronized (object) {
            if (this.startedGoAway) {
                return;
            }
            this.startedGoAway = true;
        }
        this.listener.transportShutdown(status);
        object = this.lock;
        synchronized (object) {
            this.goAway = true;
            this.goAwayStatus = status;
        }
        this.stopIfNecessary();
    }

    public void ping(ClientTransport.PingCallback callback, Executor executor) {
        throw new UnsupportedOperationException();
    }

    public InternalLogId getLogId() {
        return this.logId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopIfNecessary() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.goAway || this.stopped || this.streams.size() != 0) {
                return;
            }
            this.stopped = true;
        }
        this.listener.transportTerminated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishStream(CronetClientStream stream, Status status) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.streams.remove((Object)stream)) {
                return;
            }
            boolean isCancelled = status.getCode() == Status.Code.CANCELLED || status.getCode() == Status.Code.DEADLINE_EXCEEDED;
            stream.transportState().transportReportStatus(status, isCancelled, new Metadata());
        }
        this.stopIfNecessary();
    }
}

