/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.cronet;

import com.google.common.base.Preconditions;
import io.grpc.internal.WritableBuffer;
import java.nio.ByteBuffer;

class CronetWritableBuffer
implements WritableBuffer {
    private final ByteBuffer buffer;

    public CronetWritableBuffer(ByteBuffer buffer, int capacity) {
        this.buffer = (ByteBuffer)Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
    }

    public void write(byte[] src, int srcIndex, int length) {
        this.buffer.put(src, srcIndex, length);
    }

    public void write(byte b) {
        this.buffer.put(b);
    }

    public int writableBytes() {
        return this.buffer.remaining();
    }

    public int readableBytes() {
        return this.buffer.position();
    }

    public void release() {
    }

    ByteBuffer buffer() {
        return this.buffer;
    }
}

