/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.gcp.observability;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.ExperimentalApi;
import io.grpc.gcp.observability.GlobalLoggingTags;
import io.grpc.gcp.observability.LoggingChannelProvider;
import io.grpc.gcp.observability.LoggingServerProvider;
import io.grpc.gcp.observability.ObservabilityConfigImpl;
import io.grpc.gcp.observability.interceptors.ConfigFilterHelper;
import io.grpc.gcp.observability.interceptors.InternalLoggingChannelInterceptor;
import io.grpc.gcp.observability.interceptors.InternalLoggingServerInterceptor;
import io.grpc.gcp.observability.interceptors.LogHelper;
import io.grpc.gcp.observability.logging.GcpLogSink;
import io.grpc.gcp.observability.logging.Sink;
import io.grpc.internal.TimeProvider;
import java.io.IOException;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/8869")
public final class GcpObservability
implements AutoCloseable {
    private static GcpObservability instance = null;
    private final Sink sink;

    public static synchronized GcpObservability grpcInit() throws IOException {
        if (instance == null) {
            GlobalLoggingTags globalLoggingTags = new GlobalLoggingTags();
            ObservabilityConfigImpl observabilityConfig = ObservabilityConfigImpl.getInstance();
            GcpLogSink sink = new GcpLogSink(observabilityConfig.getDestinationProjectId(), globalLoggingTags.getLocationTags(), globalLoggingTags.getCustomTags(), observabilityConfig.getFlushMessageCount());
            LogHelper helper = new LogHelper(sink, TimeProvider.SYSTEM_TIME_PROVIDER);
            ConfigFilterHelper configFilterHelper = ConfigFilterHelper.factory(observabilityConfig);
            instance = GcpObservability.grpcInit(sink, new InternalLoggingChannelInterceptor.FactoryImpl(helper, configFilterHelper), new InternalLoggingServerInterceptor.FactoryImpl(helper, configFilterHelper));
        }
        return instance;
    }

    @VisibleForTesting
    static GcpObservability grpcInit(Sink sink, InternalLoggingChannelInterceptor.Factory channelInterceptorFactory, InternalLoggingServerInterceptor.Factory serverInterceptorFactory) {
        if (instance == null) {
            instance = new GcpObservability(sink, channelInterceptorFactory, serverInterceptorFactory);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Class<GcpObservability> clazz = GcpObservability.class;
        synchronized (GcpObservability.class) {
            if (instance == null) {
                throw new IllegalStateException("GcpObservability already closed!");
            }
            LoggingChannelProvider.shutdown();
            LoggingServerProvider.shutdown();
            this.sink.close();
            instance = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private GcpObservability(Sink sink, InternalLoggingChannelInterceptor.Factory channelInterceptorFactory, InternalLoggingServerInterceptor.Factory serverInterceptorFactory) {
        this.sink = (Sink)Preconditions.checkNotNull((Object)sink);
        LoggingChannelProvider.init((InternalLoggingChannelInterceptor.Factory)Preconditions.checkNotNull((Object)channelInterceptorFactory));
        LoggingServerProvider.init((InternalLoggingServerInterceptor.Factory)Preconditions.checkNotNull((Object)serverInterceptorFactory));
    }
}

