/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.gcp.observability;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.auth.http.HttpTransportFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

final class MetadataConfig {
    private static final Logger logger = Logger.getLogger(MetadataConfig.class.getName());
    private static final int TIMEOUT_MS = 5000;
    private static final String METADATA_URL = "http://metadata.google.internal/computeMetadata/v1/";
    private HttpRequestFactory requestFactory;
    private HttpTransportFactory transportFactory;

    @VisibleForTesting
    public MetadataConfig(HttpTransportFactory transportFactory) {
        this.transportFactory = transportFactory;
    }

    void init() {
        HttpTransport httpTransport = this.transportFactory.create();
        this.requestFactory = httpTransport.createRequestFactory();
    }

    ImmutableMap<String, String> getAllValues() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.addValueFor((ImmutableMap.Builder<String, String>)builder, "instance/id", "gke_node_id");
        this.addValueFor((ImmutableMap.Builder<String, String>)builder, "project/project-id", "project_id");
        this.addValueFor((ImmutableMap.Builder<String, String>)builder, "project/numeric-project-id", "project_numeric_id");
        this.addValueFor((ImmutableMap.Builder<String, String>)builder, "instance/attributes/cluster-name", "cluster_name");
        this.addValueFor((ImmutableMap.Builder<String, String>)builder, "instance/attributes/cluster-uid", "cluster_uid");
        this.addValueFor((ImmutableMap.Builder<String, String>)builder, "instance/attributes/cluster-location", "location");
        try {
            this.requestFactory.getTransport().shutdown();
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Calling HttpTransport.shutdown()", e);
        }
        return builder.build();
    }

    void addValueFor(ImmutableMap.Builder<String, String> builder, String attribute, String key) {
        try {
            String value = this.getAttribute(attribute);
            if (value != null) {
                builder.put((Object)key, (Object)value);
            }
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Calling getAttribute('" + attribute + "')", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getAttribute(String attributeName) throws IOException {
        GenericUrl url = new GenericUrl(METADATA_URL + attributeName);
        HttpRequest request = this.requestFactory.buildGetRequest(url);
        request = request.setReadTimeout(5000);
        request = request.setConnectTimeout(5000);
        request = request.setHeaders(new HttpHeaders().set("Metadata-Flavor", (Object)"Google"));
        HttpResponse response = null;
        try {
            InputStream stream;
            response = request.execute();
            if (response.getStatusCode() == 200 && (stream = response.getContent()) != null) {
                byte[] bytes = new byte[stream.available()];
                stream.read(bytes);
                String string = new String(bytes, response.getContentCharset());
                return string;
            }
        }
        finally {
            if (response != null) {
                response.disconnect();
            }
        }
        return null;
    }
}

