/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.gcp.observability;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.grpc.gcp.observability.ObservabilityConfig;
import io.grpc.internal.JsonParser;
import io.grpc.internal.JsonUtil;
import io.grpc.observabilitylog.v1.GrpcLogRecord;
import java.io.IOException;
import java.util.List;
import java.util.Map;

final class ObservabilityConfigImpl
implements ObservabilityConfig {
    private static final String CONFIG_ENV_VAR_NAME = "GRPC_CONFIG_OBSERVABILITY";
    private boolean enableCloudLogging = true;
    private String destinationProjectId = null;
    private Long flushMessageCount = null;
    private List<ObservabilityConfig.LogFilter> logFilters;
    private List<GrpcLogRecord.EventType> eventTypes;

    ObservabilityConfigImpl() {
    }

    static ObservabilityConfigImpl getInstance() throws IOException {
        ObservabilityConfigImpl config = new ObservabilityConfigImpl();
        config.parse(System.getenv(CONFIG_ENV_VAR_NAME));
        return config;
    }

    void parse(String config) throws IOException {
        Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)"GRPC_CONFIG_OBSERVABILITY value is null!");
        this.parseLoggingConfig((Map)JsonParser.parse((String)config));
    }

    private void parseLoggingConfig(Map<String, ?> loggingConfig) {
        if (loggingConfig != null) {
            Boolean value = JsonUtil.getBoolean(loggingConfig, (String)"enable_cloud_logging");
            if (value != null) {
                this.enableCloudLogging = value;
            }
            this.destinationProjectId = JsonUtil.getString(loggingConfig, (String)"destination_project_id");
            this.flushMessageCount = JsonUtil.getNumberAsLong(loggingConfig, (String)"flush_message_count");
            List rawList = JsonUtil.getList(loggingConfig, (String)"log_filters");
            if (rawList != null) {
                List jsonLogFilters = JsonUtil.checkObjectList((List)rawList);
                ImmutableList.Builder logFiltersBuilder = new ImmutableList.Builder();
                for (Map jsonLogFilter : jsonLogFilters) {
                    logFiltersBuilder.add((Object)this.parseJsonLogFilter(jsonLogFilter));
                }
                this.logFilters = logFiltersBuilder.build();
            }
            if ((rawList = JsonUtil.getList(loggingConfig, (String)"event_types")) != null) {
                List jsonEventTypes = JsonUtil.checkStringList((List)rawList);
                ImmutableList.Builder eventTypesBuilder = new ImmutableList.Builder();
                for (String jsonEventType : jsonEventTypes) {
                    eventTypesBuilder.add((Object)this.convertEventType(jsonEventType));
                }
                this.eventTypes = eventTypesBuilder.build();
            }
        }
    }

    private GrpcLogRecord.EventType convertEventType(String val) {
        switch (val) {
            case "GRPC_CALL_UNKNOWN": {
                return GrpcLogRecord.EventType.GRPC_CALL_UNKNOWN;
            }
            case "GRPC_CALL_REQUEST_HEADER": {
                return GrpcLogRecord.EventType.GRPC_CALL_REQUEST_HEADER;
            }
            case "GRPC_CALL_RESPONSE_HEADER": {
                return GrpcLogRecord.EventType.GRPC_CALL_RESPONSE_HEADER;
            }
            case "GRPC_CALL_REQUEST_MESSAGE": {
                return GrpcLogRecord.EventType.GRPC_CALL_REQUEST_MESSAGE;
            }
            case "GRPC_CALL_RESPONSE_MESSAGE": {
                return GrpcLogRecord.EventType.GRPC_CALL_RESPONSE_MESSAGE;
            }
            case "GRPC_CALL_TRAILER": {
                return GrpcLogRecord.EventType.GRPC_CALL_TRAILER;
            }
            case "GRPC_CALL_HALF_CLOSE": {
                return GrpcLogRecord.EventType.GRPC_CALL_HALF_CLOSE;
            }
            case "GRPC_CALL_CANCEL": {
                return GrpcLogRecord.EventType.GRPC_CALL_CANCEL;
            }
        }
        throw new IllegalArgumentException("Unknown event type value:" + val);
    }

    private ObservabilityConfig.LogFilter parseJsonLogFilter(Map<String, ?> logFilterMap) {
        return new ObservabilityConfig.LogFilter(JsonUtil.getString(logFilterMap, (String)"pattern"), JsonUtil.getNumberAsInteger(logFilterMap, (String)"header_bytes"), JsonUtil.getNumberAsInteger(logFilterMap, (String)"message_bytes"));
    }

    @Override
    public boolean isEnableCloudLogging() {
        return this.enableCloudLogging;
    }

    @Override
    public String getDestinationProjectId() {
        return this.destinationProjectId;
    }

    @Override
    public Long getFlushMessageCount() {
        return this.flushMessageCount;
    }

    @Override
    public List<ObservabilityConfig.LogFilter> getLogFilters() {
        return this.logFilters;
    }

    @Override
    public List<GrpcLogRecord.EventType> getEventTypes() {
        return this.eventTypes;
    }
}

