/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.gcp.observability.interceptors;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.grpc.Internal;
import io.grpc.MethodDescriptor;
import io.grpc.gcp.observability.ObservabilityConfig;
import io.grpc.gcp.observability.interceptors.AutoValue_ConfigFilterHelper_FilterParams;
import io.grpc.observabilitylog.v1.GrpcLogRecord;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

@Internal
public class ConfigFilterHelper {
    private static final Logger logger = Logger.getLogger(ConfigFilterHelper.class.getName());
    public static final FilterParams NO_FILTER_PARAMS = FilterParams.create(false, 0, 0);
    public static final String globalPattern = "*";
    private final ObservabilityConfig config;
    @VisibleForTesting
    boolean methodOrServiceFilterPresent;
    @VisibleForTesting
    Map<String, FilterParams> perServiceFilters;
    @VisibleForTesting
    Map<String, FilterParams> perMethodFilters;
    @VisibleForTesting
    Set<GrpcLogRecord.EventType> logEventTypeSet;

    @VisibleForTesting
    ConfigFilterHelper(ObservabilityConfig config) {
        this.config = config;
        this.methodOrServiceFilterPresent = false;
        this.perServiceFilters = new HashMap<String, FilterParams>();
        this.perMethodFilters = new HashMap<String, FilterParams>();
    }

    public static ConfigFilterHelper factory(ObservabilityConfig config) {
        ConfigFilterHelper filterHelper = new ConfigFilterHelper(config);
        if (config.isEnableCloudLogging()) {
            filterHelper.setMethodOrServiceFilterMaps();
            filterHelper.setEventFilterSet();
        }
        return filterHelper;
    }

    @VisibleForTesting
    void setMethodOrServiceFilterMaps() {
        List<ObservabilityConfig.LogFilter> logFilters = this.config.getLogFilters();
        if (logFilters == null) {
            return;
        }
        HashMap<String, FilterParams> perServiceFilters = new HashMap<String, FilterParams>();
        HashMap<String, FilterParams> perMethodFilters = new HashMap<String, FilterParams>();
        for (ObservabilityConfig.LogFilter currentFilter : logFilters) {
            FilterParams params;
            int currentMessageBytes;
            String methodOrServicePattern = currentFilter.pattern;
            int currentHeaderBytes = currentFilter.headerBytes != null ? currentFilter.headerBytes : 0;
            int n = currentMessageBytes = currentFilter.messageBytes != null ? currentFilter.messageBytes : 0;
            if (methodOrServicePattern.equals(globalPattern)) {
                if (perServiceFilters.containsKey(globalPattern)) {
                    logger.log(Level.WARNING, "Duplicate entry : {0}", methodOrServicePattern);
                    continue;
                }
                params = FilterParams.create(true, currentHeaderBytes, currentMessageBytes);
                perServiceFilters.put(globalPattern, params);
                continue;
            }
            if (methodOrServicePattern.endsWith("/*")) {
                String service = MethodDescriptor.extractFullServiceName((String)methodOrServicePattern);
                if (perServiceFilters.containsKey(service)) {
                    logger.log(Level.WARNING, "Duplicate entry : {0)", methodOrServicePattern);
                    continue;
                }
                FilterParams params2 = FilterParams.create(true, currentHeaderBytes, currentMessageBytes);
                perServiceFilters.put(service, params2);
                continue;
            }
            if (perMethodFilters.containsKey(methodOrServicePattern)) {
                logger.log(Level.WARNING, "Duplicate entry : {0}", methodOrServicePattern);
                continue;
            }
            params = FilterParams.create(true, currentHeaderBytes, currentMessageBytes);
            perMethodFilters.put(methodOrServicePattern, params);
        }
        this.perServiceFilters = ImmutableMap.copyOf(perServiceFilters);
        this.perMethodFilters = ImmutableMap.copyOf(perMethodFilters);
        if (!perServiceFilters.isEmpty() || !perMethodFilters.isEmpty()) {
            this.methodOrServiceFilterPresent = true;
        }
    }

    @VisibleForTesting
    void setEventFilterSet() {
        List<GrpcLogRecord.EventType> eventFilters = this.config.getEventTypes();
        if (eventFilters == null) {
            return;
        }
        if (eventFilters.isEmpty()) {
            this.logEventTypeSet = ImmutableSet.of();
            return;
        }
        this.logEventTypeSet = ImmutableSet.copyOf(eventFilters);
    }

    public FilterParams isMethodToBeLogged(MethodDescriptor<?, ?> method) {
        FilterParams params = NO_FILTER_PARAMS;
        if (this.methodOrServiceFilterPresent) {
            String fullMethodName = method.getFullMethodName();
            if (this.perMethodFilters.containsKey(fullMethodName)) {
                params = this.perMethodFilters.get(fullMethodName);
            } else {
                String serviceName = method.getServiceName();
                if (this.perServiceFilters.containsKey(serviceName)) {
                    params = this.perServiceFilters.get(serviceName);
                } else if (this.perServiceFilters.containsKey(globalPattern)) {
                    params = this.perServiceFilters.get(globalPattern);
                }
            }
        }
        return params;
    }

    public boolean isEventToBeLogged(GrpcLogRecord.EventType event) {
        if (this.logEventTypeSet == null) {
            return true;
        }
        return this.logEventTypeSet.contains((Object)event);
    }

    @AutoValue
    public static abstract class FilterParams {
        abstract boolean log();

        abstract int headerBytes();

        abstract int messageBytes();

        @VisibleForTesting
        public static FilterParams create(boolean log, int headerBytes, int messageBytes) {
            return new AutoValue_ConfigFilterHelper_FilterParams(log, headerBytes, messageBytes);
        }
    }
}

