/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.gcp.observability.interceptors;

import com.google.protobuf.Duration;
import com.google.protobuf.util.Durations;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.Context;
import io.grpc.Deadline;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Internal;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.gcp.observability.interceptors.ConfigFilterHelper;
import io.grpc.gcp.observability.interceptors.LogHelper;
import io.grpc.observabilitylog.v1.GrpcLogRecord;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

@Internal
public final class InternalLoggingChannelInterceptor
implements ClientInterceptor {
    private static final Logger logger = Logger.getLogger(InternalLoggingChannelInterceptor.class.getName());
    private final LogHelper helper;
    private final ConfigFilterHelper filterHelper;

    private InternalLoggingChannelInterceptor(LogHelper helper, ConfigFilterHelper filterHelper) {
        this.helper = helper;
        this.filterHelper = filterHelper;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        final AtomicLong seq = new AtomicLong(1L);
        final String rpcId = UUID.randomUUID().toString();
        final String authority = next.authority();
        final String serviceName = method.getServiceName();
        final String methodName = method.getBareMethodName();
        final Deadline deadline = LogHelper.min(callOptions.getDeadline(), Context.current().getDeadline());
        ConfigFilterHelper.FilterParams filterParams = this.filterHelper.isMethodToBeLogged(method);
        if (!filterParams.log()) {
            return next.newCall(method, callOptions);
        }
        final int maxHeaderBytes = filterParams.headerBytes();
        final int maxMessageBytes = filterParams.messageBytes();
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                Duration timeout;
                Duration duration = timeout = deadline == null ? null : Durations.fromNanos((long)deadline.timeRemaining(TimeUnit.NANOSECONDS));
                if (InternalLoggingChannelInterceptor.this.filterHelper.isEventToBeLogged(GrpcLogRecord.EventType.GRPC_CALL_REQUEST_HEADER)) {
                    try {
                        InternalLoggingChannelInterceptor.this.helper.logRequestHeader(seq.getAndIncrement(), serviceName, methodName, authority, timeout, headers, maxHeaderBytes, GrpcLogRecord.EventLogger.LOGGER_CLIENT, rpcId, null);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Unable to log request header", e);
                    }
                }
                ForwardingClientCallListener.SimpleForwardingClientCallListener observabilityListener = new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                    public void onMessage(RespT message) {
                        GrpcLogRecord.EventType responseMessageType = GrpcLogRecord.EventType.GRPC_CALL_RESPONSE_MESSAGE;
                        if (InternalLoggingChannelInterceptor.this.filterHelper.isEventToBeLogged(responseMessageType)) {
                            try {
                                InternalLoggingChannelInterceptor.this.helper.logRpcMessage(seq.getAndIncrement(), serviceName, methodName, responseMessageType, message, maxMessageBytes, GrpcLogRecord.EventLogger.LOGGER_CLIENT, rpcId);
                            }
                            catch (Exception e) {
                                logger.log(Level.SEVERE, "Unable to log response message", e);
                            }
                        }
                        super.onMessage(message);
                    }

                    public void onHeaders(Metadata headers) {
                        if (InternalLoggingChannelInterceptor.this.filterHelper.isEventToBeLogged(GrpcLogRecord.EventType.GRPC_CALL_RESPONSE_HEADER)) {
                            try {
                                InternalLoggingChannelInterceptor.this.helper.logResponseHeader(seq.getAndIncrement(), serviceName, methodName, headers, maxHeaderBytes, GrpcLogRecord.EventLogger.LOGGER_CLIENT, rpcId, LogHelper.getPeerAddress(this.getAttributes()));
                            }
                            catch (Exception e) {
                                logger.log(Level.SEVERE, "Unable to log response header", e);
                            }
                        }
                        super.onHeaders(headers);
                    }

                    public void onClose(Status status, Metadata trailers) {
                        if (InternalLoggingChannelInterceptor.this.filterHelper.isEventToBeLogged(GrpcLogRecord.EventType.GRPC_CALL_TRAILER)) {
                            try {
                                InternalLoggingChannelInterceptor.this.helper.logTrailer(seq.getAndIncrement(), serviceName, methodName, status, trailers, maxHeaderBytes, GrpcLogRecord.EventLogger.LOGGER_CLIENT, rpcId, LogHelper.getPeerAddress(this.getAttributes()));
                            }
                            catch (Exception e) {
                                logger.log(Level.SEVERE, "Unable to log trailer", e);
                            }
                        }
                        super.onClose(status, trailers);
                    }
                };
                super.start((ClientCall.Listener)observabilityListener, headers);
            }

            public void sendMessage(ReqT message) {
                GrpcLogRecord.EventType requestMessageType = GrpcLogRecord.EventType.GRPC_CALL_REQUEST_MESSAGE;
                if (InternalLoggingChannelInterceptor.this.filterHelper.isEventToBeLogged(requestMessageType)) {
                    try {
                        InternalLoggingChannelInterceptor.this.helper.logRpcMessage(seq.getAndIncrement(), serviceName, methodName, requestMessageType, message, maxMessageBytes, GrpcLogRecord.EventLogger.LOGGER_CLIENT, rpcId);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Unable to log request message", e);
                    }
                }
                super.sendMessage(message);
            }

            public void halfClose() {
                if (InternalLoggingChannelInterceptor.this.filterHelper.isEventToBeLogged(GrpcLogRecord.EventType.GRPC_CALL_HALF_CLOSE)) {
                    try {
                        InternalLoggingChannelInterceptor.this.helper.logHalfClose(seq.getAndIncrement(), serviceName, methodName, GrpcLogRecord.EventLogger.LOGGER_CLIENT, rpcId);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Unable to log half close", e);
                    }
                }
                super.halfClose();
            }

            public void cancel(String message, Throwable cause) {
                if (InternalLoggingChannelInterceptor.this.filterHelper.isEventToBeLogged(GrpcLogRecord.EventType.GRPC_CALL_CANCEL)) {
                    try {
                        InternalLoggingChannelInterceptor.this.helper.logCancel(seq.getAndIncrement(), serviceName, methodName, GrpcLogRecord.EventLogger.LOGGER_CLIENT, rpcId);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Unable to log cancel", e);
                    }
                }
                super.cancel(message, cause);
            }
        };
    }

    public static class FactoryImpl
    implements Factory {
        private final LogHelper helper;
        private final ConfigFilterHelper filterHelper;

        public FactoryImpl(LogHelper helper, ConfigFilterHelper filterHelper) {
            this.helper = helper;
            this.filterHelper = filterHelper;
        }

        @Override
        public ClientInterceptor create() {
            return new InternalLoggingChannelInterceptor(this.helper, this.filterHelper);
        }
    }

    public static interface Factory {
        public ClientInterceptor create();
    }
}

