/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.gcp.observability.interceptors;

import com.google.protobuf.Duration;
import com.google.protobuf.util.Durations;
import io.grpc.Context;
import io.grpc.Deadline;
import io.grpc.ForwardingServerCall;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Internal;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import io.grpc.gcp.observability.interceptors.ConfigFilterHelper;
import io.grpc.gcp.observability.interceptors.LogHelper;
import io.grpc.observabilitylog.v1.GrpcLogRecord;
import java.net.SocketAddress;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

@Internal
public final class InternalLoggingServerInterceptor
implements ServerInterceptor {
    private static final Logger logger = Logger.getLogger(InternalLoggingServerInterceptor.class.getName());
    private final LogHelper helper;
    private final ConfigFilterHelper filterHelper;

    private InternalLoggingServerInterceptor(LogHelper helper, ConfigFilterHelper filterHelper) {
        this.helper = helper;
        this.filterHelper = filterHelper;
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        final AtomicLong seq = new AtomicLong(1L);
        final String rpcId = UUID.randomUUID().toString();
        String authority = call.getAuthority();
        final String serviceName = call.getMethodDescriptor().getServiceName();
        final String methodName = call.getMethodDescriptor().getBareMethodName();
        SocketAddress peerAddress = LogHelper.getPeerAddress(call.getAttributes());
        Deadline deadline = Context.current().getDeadline();
        Duration timeout = deadline == null ? null : Durations.fromNanos((long)deadline.timeRemaining(TimeUnit.NANOSECONDS));
        ConfigFilterHelper.FilterParams filterParams = this.filterHelper.isMethodToBeLogged(call.getMethodDescriptor());
        if (!filterParams.log()) {
            return next.startCall(call, headers);
        }
        final int maxHeaderBytes = filterParams.headerBytes();
        final int maxMessageBytes = filterParams.messageBytes();
        if (this.filterHelper.isEventToBeLogged(GrpcLogRecord.EventType.GRPC_CALL_REQUEST_HEADER)) {
            try {
                this.helper.logRequestHeader(seq.getAndIncrement(), serviceName, methodName, authority, timeout, headers, maxHeaderBytes, GrpcLogRecord.EventLogger.LOGGER_SERVER, rpcId, peerAddress);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Unable to log request header", e);
            }
        }
        ForwardingServerCall.SimpleForwardingServerCall wrapperCall = new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(call){

            public void sendHeaders(Metadata headers) {
                if (InternalLoggingServerInterceptor.this.filterHelper.isEventToBeLogged(GrpcLogRecord.EventType.GRPC_CALL_RESPONSE_HEADER)) {
                    try {
                        InternalLoggingServerInterceptor.this.helper.logResponseHeader(seq.getAndIncrement(), serviceName, methodName, headers, maxHeaderBytes, GrpcLogRecord.EventLogger.LOGGER_SERVER, rpcId, null);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Unable to log response header", e);
                    }
                }
                super.sendHeaders(headers);
            }

            public void sendMessage(RespT message) {
                GrpcLogRecord.EventType responseMessageType = GrpcLogRecord.EventType.GRPC_CALL_RESPONSE_MESSAGE;
                if (InternalLoggingServerInterceptor.this.filterHelper.isEventToBeLogged(responseMessageType)) {
                    try {
                        InternalLoggingServerInterceptor.this.helper.logRpcMessage(seq.getAndIncrement(), serviceName, methodName, responseMessageType, message, maxMessageBytes, GrpcLogRecord.EventLogger.LOGGER_SERVER, rpcId);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Unable to log response message", e);
                    }
                }
                super.sendMessage(message);
            }

            public void close(Status status, Metadata trailers) {
                if (InternalLoggingServerInterceptor.this.filterHelper.isEventToBeLogged(GrpcLogRecord.EventType.GRPC_CALL_TRAILER)) {
                    try {
                        InternalLoggingServerInterceptor.this.helper.logTrailer(seq.getAndIncrement(), serviceName, methodName, status, trailers, maxHeaderBytes, GrpcLogRecord.EventLogger.LOGGER_SERVER, rpcId, null);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Unable to log trailer", e);
                    }
                }
                super.close(status, trailers);
            }
        };
        ServerCall.Listener listener = next.startCall((ServerCall)wrapperCall, headers);
        return new ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT>(listener){

            public void onMessage(ReqT message) {
                GrpcLogRecord.EventType requestMessageType = GrpcLogRecord.EventType.GRPC_CALL_REQUEST_MESSAGE;
                if (InternalLoggingServerInterceptor.this.filterHelper.isEventToBeLogged(requestMessageType)) {
                    try {
                        InternalLoggingServerInterceptor.this.helper.logRpcMessage(seq.getAndIncrement(), serviceName, methodName, requestMessageType, message, maxMessageBytes, GrpcLogRecord.EventLogger.LOGGER_SERVER, rpcId);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Unable to log request message", e);
                    }
                }
                super.onMessage(message);
            }

            public void onHalfClose() {
                if (InternalLoggingServerInterceptor.this.filterHelper.isEventToBeLogged(GrpcLogRecord.EventType.GRPC_CALL_HALF_CLOSE)) {
                    try {
                        InternalLoggingServerInterceptor.this.helper.logHalfClose(seq.getAndIncrement(), serviceName, methodName, GrpcLogRecord.EventLogger.LOGGER_SERVER, rpcId);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Unable to log half close", e);
                    }
                }
                super.onHalfClose();
            }

            public void onCancel() {
                if (InternalLoggingServerInterceptor.this.filterHelper.isEventToBeLogged(GrpcLogRecord.EventType.GRPC_CALL_CANCEL)) {
                    try {
                        InternalLoggingServerInterceptor.this.helper.logCancel(seq.getAndIncrement(), serviceName, methodName, GrpcLogRecord.EventLogger.LOGGER_SERVER, rpcId);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Unable to log cancel", e);
                    }
                }
                super.onCancel();
            }
        };
    }

    public static class FactoryImpl
    implements Factory {
        private final LogHelper helper;
        private final ConfigFilterHelper filterHelper;

        public FactoryImpl(LogHelper helper, ConfigFilterHelper filterHelper) {
            this.helper = helper;
            this.filterHelper = filterHelper;
        }

        @Override
        public ServerInterceptor create() {
            return new InternalLoggingServerInterceptor(this.helper, this.filterHelper);
        }
    }

    public static interface Factory {
        public ServerInterceptor create();
    }
}

