/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.gcp.observability.interceptors;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import com.google.protobuf.Duration;
import com.google.protobuf.Message;
import com.google.protobuf.util.Timestamps;
import io.grpc.Attributes;
import io.grpc.Deadline;
import io.grpc.Grpc;
import io.grpc.Internal;
import io.grpc.InternalMetadata;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.gcp.observability.interceptors.InetAddressUtil;
import io.grpc.gcp.observability.logging.Sink;
import io.grpc.internal.TimeProvider;
import io.grpc.observabilitylog.v1.GrpcLogRecord;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

@Internal
public class LogHelper {
    private static final Logger logger = Logger.getLogger(LogHelper.class.getName());
    static final Metadata.Key<byte[]> STATUS_DETAILS_KEY = Metadata.Key.of((String)"grpc-status-details-bin", (Metadata.BinaryMarshaller)Metadata.BINARY_BYTE_MARSHALLER);
    private final Sink sink;
    private final TimeProvider timeProvider;
    private static final Set<String> NEVER_INCLUDED_METADATA = new HashSet<String>(Collections.singletonList(STATUS_DETAILS_KEY.name()));
    private static final Set<String> ALWAYS_INCLUDED_METADATA = new HashSet<String>(Collections.singletonList("grpc-trace-bin"));

    public LogHelper(Sink sink, TimeProvider timeProvider) {
        this.sink = sink;
        this.timeProvider = timeProvider;
    }

    void logRequestHeader(long seqId, String serviceName, String methodName, String authority, @Nullable Duration timeout, Metadata metadata, int maxHeaderBytes, GrpcLogRecord.EventLogger eventLogger, String rpcId, @Nullable SocketAddress peerAddress) {
        Preconditions.checkNotNull((Object)serviceName, (Object)"serviceName");
        Preconditions.checkNotNull((Object)methodName, (Object)"methodName");
        Preconditions.checkNotNull((Object)rpcId, (Object)"rpcId");
        Preconditions.checkArgument((peerAddress == null || eventLogger == GrpcLogRecord.EventLogger.LOGGER_SERVER ? 1 : 0) != 0, (Object)"peerAddress can only be specified by server");
        PayloadBuilder<GrpcLogRecord.Metadata.Builder> pair = LogHelper.createMetadataProto(metadata, maxHeaderBytes);
        GrpcLogRecord.Builder logEntryBuilder = this.createTimestamp().setSequenceId(seqId).setServiceName(serviceName).setMethodName(methodName).setAuthority(authority).setEventType(GrpcLogRecord.EventType.GRPC_CALL_REQUEST_HEADER).setEventLogger(eventLogger).setLogLevel(GrpcLogRecord.LogLevel.LOG_LEVEL_DEBUG).setMetadata((GrpcLogRecord.Metadata.Builder)pair.payload).setPayloadSize(pair.size).setPayloadTruncated(pair.truncated).setRpcId(rpcId);
        if (timeout != null) {
            logEntryBuilder.setTimeout(timeout);
        }
        if (peerAddress != null) {
            logEntryBuilder.setPeerAddress(LogHelper.socketAddressToProto(peerAddress));
        }
        this.sink.write(logEntryBuilder.build());
    }

    void logResponseHeader(long seqId, String serviceName, String methodName, Metadata metadata, int maxHeaderBytes, GrpcLogRecord.EventLogger eventLogger, String rpcId, @Nullable SocketAddress peerAddress) {
        Preconditions.checkNotNull((Object)serviceName, (Object)"serviceName");
        Preconditions.checkNotNull((Object)methodName, (Object)"methodName");
        Preconditions.checkNotNull((Object)rpcId, (Object)"rpcId");
        Preconditions.checkArgument((peerAddress == null || eventLogger == GrpcLogRecord.EventLogger.LOGGER_CLIENT ? 1 : 0) != 0, (Object)"peerAddress can only be specified for client");
        PayloadBuilder<GrpcLogRecord.Metadata.Builder> pair = LogHelper.createMetadataProto(metadata, maxHeaderBytes);
        GrpcLogRecord.Builder logEntryBuilder = this.createTimestamp().setSequenceId(seqId).setServiceName(serviceName).setMethodName(methodName).setEventType(GrpcLogRecord.EventType.GRPC_CALL_RESPONSE_HEADER).setEventLogger(eventLogger).setLogLevel(GrpcLogRecord.LogLevel.LOG_LEVEL_DEBUG).setMetadata((GrpcLogRecord.Metadata.Builder)pair.payload).setPayloadSize(pair.size).setPayloadTruncated(pair.truncated).setRpcId(rpcId);
        if (peerAddress != null) {
            logEntryBuilder.setPeerAddress(LogHelper.socketAddressToProto(peerAddress));
        }
        this.sink.write(logEntryBuilder.build());
    }

    void logTrailer(long seqId, String serviceName, String methodName, Status status, Metadata metadata, int maxHeaderBytes, GrpcLogRecord.EventLogger eventLogger, String rpcId, @Nullable SocketAddress peerAddress) {
        byte[] statusDetailBytes;
        Preconditions.checkNotNull((Object)serviceName, (Object)"serviceName");
        Preconditions.checkNotNull((Object)methodName, (Object)"methodName");
        Preconditions.checkNotNull((Object)status, (Object)"status");
        Preconditions.checkNotNull((Object)rpcId, (Object)"rpcId");
        Preconditions.checkArgument((peerAddress == null || eventLogger == GrpcLogRecord.EventLogger.LOGGER_CLIENT ? 1 : 0) != 0, (Object)"peerAddress can only be specified for client");
        PayloadBuilder<GrpcLogRecord.Metadata.Builder> pair = LogHelper.createMetadataProto(metadata, maxHeaderBytes);
        GrpcLogRecord.Builder logEntryBuilder = this.createTimestamp().setSequenceId(seqId).setServiceName(serviceName).setMethodName(methodName).setEventType(GrpcLogRecord.EventType.GRPC_CALL_TRAILER).setEventLogger(eventLogger).setLogLevel(GrpcLogRecord.LogLevel.LOG_LEVEL_DEBUG).setMetadata((GrpcLogRecord.Metadata.Builder)pair.payload).setPayloadSize(pair.size).setPayloadTruncated(pair.truncated).setStatusCode(status.getCode().value()).setRpcId(rpcId);
        String statusDescription = status.getDescription();
        if (statusDescription != null) {
            logEntryBuilder.setStatusMessage(statusDescription);
        }
        if ((statusDetailBytes = (byte[])metadata.get(STATUS_DETAILS_KEY)) != null) {
            logEntryBuilder.setStatusDetails(ByteString.copyFrom((byte[])statusDetailBytes));
        }
        if (peerAddress != null) {
            logEntryBuilder.setPeerAddress(LogHelper.socketAddressToProto(peerAddress));
        }
        this.sink.write(logEntryBuilder.build());
    }

    <T> void logRpcMessage(long seqId, String serviceName, String methodName, GrpcLogRecord.EventType eventType, T message, int maxMessageBytes, GrpcLogRecord.EventLogger eventLogger, String rpcId) {
        Preconditions.checkNotNull((Object)serviceName, (Object)"serviceName");
        Preconditions.checkNotNull((Object)methodName, (Object)"methodName");
        Preconditions.checkNotNull((Object)rpcId, (Object)"rpcId");
        Preconditions.checkArgument((eventType == GrpcLogRecord.EventType.GRPC_CALL_REQUEST_MESSAGE || eventType == GrpcLogRecord.EventType.GRPC_CALL_RESPONSE_MESSAGE ? 1 : 0) != 0, (Object)"event type must correspond to client message or server message");
        Preconditions.checkNotNull(message, (Object)"message");
        byte[] messageBytesArray = null;
        if (message instanceof Message) {
            messageBytesArray = ((Message)message).toByteArray();
        } else if (message instanceof byte[]) {
            messageBytesArray = (byte[])message;
        } else {
            logger.log(Level.WARNING, "message is of UNKNOWN type, message and payload_size fieldsof GrpcLogRecord proto will not be logged");
        }
        PayloadBuilder<ByteString> pair = null;
        if (messageBytesArray != null) {
            pair = LogHelper.createMessageProto(messageBytesArray, maxMessageBytes);
        }
        GrpcLogRecord.Builder logEntryBuilder = this.createTimestamp().setSequenceId(seqId).setServiceName(serviceName).setMethodName(methodName).setEventType(eventType).setEventLogger(eventLogger).setLogLevel(GrpcLogRecord.LogLevel.LOG_LEVEL_DEBUG).setRpcId(rpcId);
        if (pair != null && pair.size != 0) {
            logEntryBuilder.setPayloadSize(pair.size);
        }
        if (pair != null && pair.payload != null) {
            logEntryBuilder.setMessage((ByteString)pair.payload).setPayloadTruncated(pair.truncated);
        }
        this.sink.write(logEntryBuilder.build());
    }

    void logHalfClose(long seqId, String serviceName, String methodName, GrpcLogRecord.EventLogger eventLogger, String rpcId) {
        Preconditions.checkNotNull((Object)serviceName, (Object)"serviceName");
        Preconditions.checkNotNull((Object)methodName, (Object)"methodName");
        Preconditions.checkNotNull((Object)rpcId, (Object)"rpcId");
        GrpcLogRecord.Builder logEntryBuilder = this.createTimestamp().setSequenceId(seqId).setServiceName(serviceName).setMethodName(methodName).setEventType(GrpcLogRecord.EventType.GRPC_CALL_HALF_CLOSE).setEventLogger(eventLogger).setLogLevel(GrpcLogRecord.LogLevel.LOG_LEVEL_DEBUG).setRpcId(rpcId);
        this.sink.write(logEntryBuilder.build());
    }

    void logCancel(long seqId, String serviceName, String methodName, GrpcLogRecord.EventLogger eventLogger, String rpcId) {
        Preconditions.checkNotNull((Object)serviceName, (Object)"serviceName");
        Preconditions.checkNotNull((Object)methodName, (Object)"methodName");
        Preconditions.checkNotNull((Object)rpcId, (Object)"rpcId");
        GrpcLogRecord.Builder logEntryBuilder = this.createTimestamp().setSequenceId(seqId).setServiceName(serviceName).setMethodName(methodName).setEventType(GrpcLogRecord.EventType.GRPC_CALL_CANCEL).setEventLogger(eventLogger).setLogLevel(GrpcLogRecord.LogLevel.LOG_LEVEL_DEBUG).setRpcId(rpcId);
        this.sink.write(logEntryBuilder.build());
    }

    GrpcLogRecord.Builder createTimestamp() {
        long nanos = this.timeProvider.currentTimeNanos();
        return GrpcLogRecord.newBuilder().setTimestamp(Timestamps.fromNanos((long)nanos));
    }

    static PayloadBuilder<GrpcLogRecord.Metadata.Builder> createMetadataProto(Metadata metadata, int maxHeaderBytes) {
        Preconditions.checkNotNull((Object)metadata, (Object)"metadata");
        Preconditions.checkArgument((maxHeaderBytes >= 0 ? 1 : 0) != 0, (Object)"maxHeaderBytes must be non negative");
        GrpcLogRecord.Metadata.Builder metadataBuilder = GrpcLogRecord.Metadata.newBuilder();
        byte[][] serialized = InternalMetadata.serialize((Metadata)metadata);
        boolean truncated = false;
        int totalMetadataBytes = 0;
        if (serialized != null) {
            for (int i = 0; i < serialized.length; i += 2) {
                String key = new String(serialized[i], Charsets.UTF_8);
                byte[] value = serialized[i + 1];
                if (NEVER_INCLUDED_METADATA.contains(key)) continue;
                boolean forceInclude = ALWAYS_INCLUDED_METADATA.contains(key);
                int metadataBytesAfterAdd = totalMetadataBytes + key.length() + value.length;
                if (!forceInclude && metadataBytesAfterAdd > maxHeaderBytes) {
                    truncated = true;
                    continue;
                }
                metadataBuilder.addEntryBuilder().setKey(key).setValue(ByteString.copyFrom((byte[])value));
                if (forceInclude) continue;
                totalMetadataBytes = metadataBytesAfterAdd;
            }
        }
        return new PayloadBuilder<GrpcLogRecord.Metadata.Builder>(metadataBuilder, totalMetadataBytes, truncated);
    }

    static PayloadBuilder<ByteString> createMessageProto(byte[] message, int maxMessageBytes) {
        Preconditions.checkArgument((maxMessageBytes >= 0 ? 1 : 0) != 0, (Object)"maxMessageBytes must be non negative");
        int desiredBytes = 0;
        int messageLength = message.length;
        if (maxMessageBytes > 0) {
            desiredBytes = Math.min(maxMessageBytes, messageLength);
        }
        ByteString messageData = ByteString.copyFrom((byte[])message, (int)0, (int)desiredBytes);
        return new PayloadBuilder<ByteString>(messageData, messageLength, maxMessageBytes < message.length);
    }

    static GrpcLogRecord.Address socketAddressToProto(SocketAddress address) {
        Preconditions.checkNotNull((Object)address, (Object)"address");
        GrpcLogRecord.Address.Builder builder = GrpcLogRecord.Address.newBuilder();
        if (address instanceof InetSocketAddress) {
            InetAddress inetAddress = ((InetSocketAddress)address).getAddress();
            if (inetAddress instanceof Inet4Address) {
                builder.setType(GrpcLogRecord.Address.Type.TYPE_IPV4).setAddress(InetAddressUtil.toAddrString(inetAddress));
            } else if (inetAddress instanceof Inet6Address) {
                builder.setType(GrpcLogRecord.Address.Type.TYPE_IPV6).setAddress(InetAddressUtil.toAddrString(inetAddress));
            } else {
                logger.log(Level.SEVERE, "unknown type of InetSocketAddress: {}", address);
                builder.setAddress(address.toString());
            }
            builder.setIpPort(((InetSocketAddress)address).getPort());
        } else if (address.getClass().getName().equals("io.netty.channel.unix.DomainSocketAddress")) {
            builder.setType(GrpcLogRecord.Address.Type.TYPE_UNIX).setAddress(address.toString());
        } else {
            builder.setType(GrpcLogRecord.Address.Type.TYPE_UNKNOWN).setAddress(address.toString());
        }
        return builder.build();
    }

    static SocketAddress getPeerAddress(Attributes streamAttributes) {
        return (SocketAddress)streamAttributes.get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR);
    }

    static Deadline min(@Nullable Deadline deadline0, @Nullable Deadline deadline1) {
        if (deadline0 == null) {
            return deadline1;
        }
        if (deadline1 == null) {
            return deadline0;
        }
        return deadline0.minimum(deadline1);
    }

    static final class PayloadBuilder<T> {
        T payload;
        int size;
        boolean truncated;

        private PayloadBuilder(T payload, int size, boolean truncated) {
            this.payload = payload;
            this.size = size;
            this.truncated = truncated;
        }
    }
}

