/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.gcp.observability.interceptors;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.Internal;
import io.grpc.gcp.observability.ObservabilityConfig;
import io.grpc.gcp.observability.interceptors.AutoValue_ConfigFilterHelper_FilterParams;
import java.util.List;

@Internal
public class ConfigFilterHelper {
    public static final FilterParams NO_FILTER_PARAMS = FilterParams.create(false, 0, 0);
    private final ObservabilityConfig config;

    private ConfigFilterHelper(ObservabilityConfig config) {
        this.config = config;
    }

    public static ConfigFilterHelper getInstance(ObservabilityConfig config) {
        return new ConfigFilterHelper(config);
    }

    public FilterParams logRpcMethod(String fullMethodName, boolean client) {
        FilterParams params = NO_FILTER_PARAMS;
        int index = ((String)Preconditions.checkNotNull((Object)fullMethodName, (Object)"fullMethodName")).lastIndexOf(47);
        String serviceName = fullMethodName.substring(0, index);
        List<ObservabilityConfig.LogFilter> logFilters = client ? this.config.getClientLogFilters() : this.config.getServerLogFilters();
        for (ObservabilityConfig.LogFilter logFilter : logFilters) {
            if (!logFilter.matchAll && !logFilter.services.contains(serviceName) && !logFilter.methods.contains(fullMethodName)) continue;
            if (logFilter.excludePattern) {
                return params;
            }
            int currentHeaderBytes = logFilter.headerBytes;
            int currentMessageBytes = logFilter.messageBytes;
            return FilterParams.create(true, currentHeaderBytes, currentMessageBytes);
        }
        return params;
    }

    @AutoValue
    public static abstract class FilterParams {
        abstract boolean log();

        abstract int headerBytes();

        abstract int messageBytes();

        @VisibleForTesting
        public static FilterParams create(boolean log, int headerBytes, int messageBytes) {
            return new AutoValue_ConfigFilterHelper_FilterParams(log, headerBytes, messageBytes);
        }
    }
}

