/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.grpclb;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import io.grpc.EquivalentAddressGroup;
import io.grpc.TransportManager;
import io.grpc.internal.ClientTransport;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class RoundRobinServerList {
    private final TransportManager tm;
    private final List<EquivalentAddressGroup> list;
    private final Iterator<EquivalentAddressGroup> cyclingIter;

    private RoundRobinServerList(TransportManager tm, List<EquivalentAddressGroup> list) {
        this.tm = tm;
        this.list = list;
        this.cyclingIter = Iterables.cycle(list).iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ListenableFuture<ClientTransport> getTransportForNextServer() {
        EquivalentAddressGroup currentServer;
        Iterator<EquivalentAddressGroup> iterator = this.cyclingIter;
        synchronized (iterator) {
            currentServer = this.cyclingIter.next();
        }
        if (currentServer == null) {
            throw new UnsupportedOperationException("server dropping not implemented yet");
        }
        return (ListenableFuture)Preconditions.checkNotNull((Object)this.tm.getTransport(currentServer), (String)"TransportManager returned null for %s", (Object[])new Object[]{currentServer});
    }

    @VisibleForTesting
    List<EquivalentAddressGroup> getList() {
        return this.list;
    }

    int size() {
        return this.list.size();
    }

    @NotThreadSafe
    static class Builder {
        private final ImmutableList.Builder<EquivalentAddressGroup> listBuilder = ImmutableList.builder();
        private final TransportManager tm;

        Builder(TransportManager tm) {
            this.tm = tm;
        }

        void add(@Nullable InetSocketAddress addr) {
            this.listBuilder.add((Object)new EquivalentAddressGroup((SocketAddress)addr));
        }

        RoundRobinServerList build() {
            return new RoundRobinServerList(this.tm, (List)this.listBuilder.build());
        }
    }
}

