/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.grpclb;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.grpc.Attributes;
import io.grpc.Channel;
import io.grpc.EquivalentAddressGroup;
import io.grpc.LoadBalancer;
import io.grpc.RequestKey;
import io.grpc.ResolvedServerInfo;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.TransportManager;
import io.grpc.grpclb.InitialLoadBalanceRequest;
import io.grpc.grpclb.InitialLoadBalanceResponse;
import io.grpc.grpclb.LoadBalanceRequest;
import io.grpc.grpclb.LoadBalanceResponse;
import io.grpc.grpclb.LoadBalancerGrpc;
import io.grpc.grpclb.RoundRobinServerList;
import io.grpc.grpclb.Server;
import io.grpc.grpclb.ServerList;
import io.grpc.internal.BlankFutureProvider;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.SharedResourceHolder;
import io.grpc.stub.StreamObserver;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

class GrpclbLoadBalancer<T>
extends LoadBalancer<T> {
    private static final Logger logger = Logger.getLogger(GrpclbLoadBalancer.class.getName());
    private final Object lock = new Object();
    private final String serviceName;
    private final TransportManager<T> tm;
    @GuardedBy(value="lock")
    private final BlankFutureProvider<T> pendingPicks = new BlankFutureProvider();
    @GuardedBy(value="lock")
    private Throwable lastError;
    @GuardedBy(value="lock")
    private boolean closed;
    @GuardedBy(value="lock")
    private EquivalentAddressGroup lbAddresses;
    @GuardedBy(value="lock")
    private T lbTransport;
    @GuardedBy(value="lock")
    private ListenableFuture<T> directTransport;
    @GuardedBy(value="lock")
    private StreamObserver<LoadBalanceResponse> lbResponseObserver;
    @GuardedBy(value="lock")
    private StreamObserver<LoadBalanceRequest> lbRequestWriter;
    @GuardedBy(value="lock")
    private HashMap<SocketAddress, ResolvedServerInfo> servers;
    @GuardedBy(value="lock")
    @VisibleForTesting
    private RoundRobinServerList<T> roundRobinServerList;
    private ExecutorService executor;

    GrpclbLoadBalancer(String serviceName, TransportManager<T> tm) {
        this.serviceName = serviceName;
        this.tm = tm;
        this.executor = (ExecutorService)SharedResourceHolder.get((SharedResourceHolder.Resource)GrpcUtil.SHARED_CHANNEL_EXECUTOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    StreamObserver<LoadBalanceResponse> getLbResponseObserver() {
        Object object = this.lock;
        synchronized (object) {
            return this.lbResponseObserver;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    RoundRobinServerList<T> getRoundRobinServerList() {
        Object object = this.lock;
        synchronized (object) {
            return this.roundRobinServerList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<T> pickTransport(@Nullable RequestKey requestKey) {
        RoundRobinServerList<T> serverListCopy;
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"already closed");
            if (this.directTransport != null) {
                return this.directTransport;
            }
            if (this.roundRobinServerList == null) {
                if (this.lastError == null) {
                    return this.pendingPicks.newBlankFuture();
                }
                return Futures.immediateFailedFuture((Throwable)this.lastError);
            }
            serverListCopy = this.roundRobinServerList;
        }
        return serverListCopy.getTransportForNextServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleResolvedAddresses(List<ResolvedServerInfo> updatedServers, Attributes config) {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<SocketAddress> addrs = new ArrayList<SocketAddress>(updatedServers.size());
            for (ResolvedServerInfo serverInfo : updatedServers) {
                addrs.add(serverInfo.getAddress());
            }
            EquivalentAddressGroup newLbAddresses = new EquivalentAddressGroup(addrs);
            if (!newLbAddresses.equals((Object)this.lbAddresses)) {
                this.lbAddresses = newLbAddresses;
                this.connectToLb();
            }
        }
        this.updateRetainedTransports();
    }

    @GuardedBy(value="lock")
    private void connectToLb() {
        this.directTransport = null;
        if (this.closed) {
            return;
        }
        this.lbResponseObserver = null;
        Preconditions.checkNotNull((Object)this.lbAddresses, (Object)"lbAddresses");
        ListenableFuture transportFuture = this.tm.getTransport(this.lbAddresses);
        Futures.addCallback((ListenableFuture)((ListenableFuture)Preconditions.checkNotNull((Object)transportFuture)), (FutureCallback)new FutureCallback<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSuccess(T transport) {
                Object object = GrpclbLoadBalancer.this.lock;
                synchronized (object) {
                    if (GrpclbLoadBalancer.this.closed) {
                        return;
                    }
                    GrpclbLoadBalancer.this.lbTransport = transport;
                    GrpclbLoadBalancer.this.startNegotiation();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onFailure(Throwable t) {
                AssertionError error = new AssertionError("The future from TransportManager failed, but it shouldn't", t);
                Object object = GrpclbLoadBalancer.this.lock;
                synchronized (object) {
                    GrpclbLoadBalancer.this.lastError = (Throwable)((Object)error);
                }
                throw error;
            }
        }, (Executor)this.executor);
    }

    @GuardedBy(value="lock")
    private void startNegotiation() {
        if (this.closed) {
            return;
        }
        Preconditions.checkState((this.lbTransport != null ? 1 : 0) != 0, (Object)"currentLbTransport must be available");
        logger.info("Starting LB negotiation");
        LoadBalanceRequest initRequest = LoadBalanceRequest.newBuilder().setInitialRequest(InitialLoadBalanceRequest.newBuilder().setName(this.serviceName).build()).build();
        this.lbResponseObserver = new LbResponseObserver();
        this.sendLbRequest(this.lbTransport, initRequest);
    }

    @VisibleForTesting
    @GuardedBy(value="lock")
    void sendLbRequest(T transport, LoadBalanceRequest request) {
        Channel channel = this.tm.makeChannel(transport);
        LoadBalancerGrpc.LoadBalancerStub stub = LoadBalancerGrpc.newStub(channel);
        this.lbRequestWriter = stub.balanceLoad(this.lbResponseObserver);
        this.lbRequestWriter.onNext((Object)request);
    }

    public void handleNameResolutionError(Status error) {
        this.handleError(error.augmentDescription("Name resolution failed"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.lbRequestWriter != null) {
                this.lbRequestWriter.onCompleted();
            }
            this.executor = (ExecutorService)SharedResourceHolder.release((SharedResourceHolder.Resource)GrpcUtil.SHARED_CHANNEL_EXECUTOR, (Object)this.executor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transportShutdown(EquivalentAddressGroup addressGroup, T transport, Status status) {
        this.handleError(status.augmentDescription("Transport to LB server closed"));
        Object object = this.lock;
        synchronized (object) {
            if (transport == this.lbTransport) {
                this.connectToLb();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleError(Status error) {
        BlankFutureProvider.FulfillmentBatch pendingPicksFulfillmentBatch;
        StatusException statusException = error.asException();
        Object object = this.lock;
        synchronized (object) {
            this.lastError = statusException;
            pendingPicksFulfillmentBatch = this.pendingPicks.createFulfillmentBatch();
        }
        pendingPicksFulfillmentBatch.fail((Throwable)statusException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRetainedTransports() {
        HashSet<EquivalentAddressGroup> addresses = new HashSet<EquivalentAddressGroup>();
        Object object = this.lock;
        synchronized (object) {
            if (this.lbAddresses != null) {
                addresses.add(this.lbAddresses);
            }
            if (this.servers != null) {
                for (SocketAddress addr : this.servers.keySet()) {
                    addresses.add(new EquivalentAddressGroup(addr));
                }
            }
        }
        this.tm.updateRetainedTransports(addresses);
    }

    private class LbResponseObserver
    implements StreamObserver<LoadBalanceResponse> {
        private LbResponseObserver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(LoadBalanceResponse response) {
            BlankFutureProvider.FulfillmentBatch pendingPicksFulfillmentBatch;
            logger.info("Got a LB response: " + response);
            InitialLoadBalanceResponse initialResponse = response.getInitialResponse();
            RoundRobinServerList.Builder listBuilder = new RoundRobinServerList.Builder(GrpclbLoadBalancer.this.tm);
            ServerList serverList = response.getServerList();
            HashMap<InetSocketAddress, ResolvedServerInfo> newServerMap = new HashMap<InetSocketAddress, ResolvedServerInfo>();
            for (Server server : serverList.getServersList()) {
                if (server.getDropRequest()) {
                    listBuilder.add(null);
                    continue;
                }
                InetSocketAddress address = new InetSocketAddress(server.getIpAddress(), server.getPort());
                listBuilder.add(address);
                if (newServerMap.containsKey(address)) continue;
                newServerMap.put(address, new ResolvedServerInfo((SocketAddress)address, Attributes.EMPTY));
            }
            final RoundRobinServerList newRoundRobinServerList = listBuilder.build();
            if (newRoundRobinServerList.size() == 0) {
                return;
            }
            Object object = GrpclbLoadBalancer.this.lock;
            synchronized (object) {
                if (GrpclbLoadBalancer.this.lbResponseObserver != this) {
                    return;
                }
                GrpclbLoadBalancer.this.roundRobinServerList = newRoundRobinServerList;
                GrpclbLoadBalancer.this.servers = newServerMap;
                pendingPicksFulfillmentBatch = GrpclbLoadBalancer.this.pendingPicks.createFulfillmentBatch();
            }
            GrpclbLoadBalancer.this.updateRetainedTransports();
            pendingPicksFulfillmentBatch.link(new Supplier<ListenableFuture<T>>(){

                public ListenableFuture<T> get() {
                    return newRoundRobinServerList.getTransportForNextServer();
                }
            });
        }

        public void onError(Throwable error) {
            this.onStreamClosed(Status.fromThrowable((Throwable)error).augmentDescription("Stream to GRPCLB LoadBalancer had an error"));
        }

        public void onCompleted() {
            this.onStreamClosed(Status.UNAVAILABLE.augmentDescription("Stream to GRPCLB LoadBalancer was closed"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onStreamClosed(Status status) {
            if (status.getCode() == Status.Code.UNIMPLEMENTED) {
                BlankFutureProvider.FulfillmentBatch pendingPicksFulfillmentBatch;
                ListenableFuture transportFuture;
                Object object = GrpclbLoadBalancer.this.lock;
                synchronized (object) {
                    if (GrpclbLoadBalancer.this.lbResponseObserver != this) {
                        return;
                    }
                    transportFuture = Futures.immediateFuture((Object)GrpclbLoadBalancer.this.lbTransport);
                    GrpclbLoadBalancer.this.directTransport = transportFuture;
                    pendingPicksFulfillmentBatch = GrpclbLoadBalancer.this.pendingPicks.createFulfillmentBatch();
                }
                pendingPicksFulfillmentBatch.link(Suppliers.ofInstance((Object)transportFuture));
            } else {
                GrpclbLoadBalancer.this.handleError(status);
                Object object = GrpclbLoadBalancer.this.lock;
                synchronized (object) {
                    if (GrpclbLoadBalancer.this.lbResponseObserver != this) {
                        return;
                    }
                    GrpclbLoadBalancer.this.startNegotiation();
                }
            }
        }
    }
}

