/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.grpclb;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.Channel;
import io.grpc.ConnectivityState;
import io.grpc.ConnectivityStateInfo;
import io.grpc.EquivalentAddressGroup;
import io.grpc.LoadBalancer2;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.ResolvedServerInfoGroup;
import io.grpc.Status;
import io.grpc.grpclb.GrpclbConstants;
import io.grpc.grpclb.InitialLoadBalanceRequest;
import io.grpc.grpclb.LbAddressGroup;
import io.grpc.grpclb.LoadBalanceRequest;
import io.grpc.grpclb.LoadBalanceResponse;
import io.grpc.grpclb.LoadBalancerGrpc;
import io.grpc.grpclb.Server;
import io.grpc.grpclb.ServerList;
import io.grpc.internal.LogId;
import io.grpc.internal.WithLogId;
import io.grpc.stub.StreamObserver;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

class GrpclbLoadBalancer2
extends LoadBalancer2
implements WithLogId {
    private static final Logger logger = Logger.getLogger(GrpclbLoadBalancer2.class.getName());
    @VisibleForTesting
    static final LoadBalancer2.SubchannelPicker BUFFER_PICKER = new LoadBalancer2.SubchannelPicker(){

        public LoadBalancer2.PickResult pickSubchannel(Attributes affinity, Metadata headers) {
            return LoadBalancer2.PickResult.withNoResult();
        }
    };
    private final LogId logId = LogId.allocate((String)((Object)((Object)this)).getClass().getName());
    private final String serviceName;
    private final LoadBalancer2.Helper helper;
    private final LoadBalancer2.Factory pickFirstBalancerFactory;
    private final LoadBalancer2.Factory roundRobinBalancerFactory;
    private static final Attributes.Key<AtomicReference<ConnectivityStateInfo>> STATE_INFO = Attributes.Key.of((String)"io.grpc.grpclb.GrpclbLoadBalancer.stateInfo");
    @VisibleForTesting
    static final LoadBalancer2.PickResult THROTTLED_RESULT = LoadBalancer2.PickResult.withError((Status)Status.UNAVAILABLE.withDescription("Throttled by LB"));
    @Nullable
    private LoadBalancer2 delegate;
    private GrpclbConstants.LbPolicy lbPolicy;
    @Nullable
    private List<LbAddressGroup> lbAddressGroups;
    @Nullable
    private ManagedChannel lbCommChannel;
    private int currentLbIndex;
    @Nullable
    private LbResponseObserver lbResponseObserver;
    @Nullable
    private StreamObserver<LoadBalanceRequest> lbRequestWriter;
    private Map<EquivalentAddressGroup, LoadBalancer2.Subchannel> subchannels = Collections.emptyMap();
    private List<EquivalentAddressGroup> roundRobinList = Collections.emptyList();

    GrpclbLoadBalancer2(LoadBalancer2.Helper helper, LoadBalancer2.Factory pickFirstBalancerFactory, LoadBalancer2.Factory roundRobinBalancerFactory) {
        this.helper = (LoadBalancer2.Helper)Preconditions.checkNotNull((Object)helper, (Object)"helper");
        this.serviceName = (String)Preconditions.checkNotNull((Object)helper.getAuthority(), (Object)"helper returns null authority");
        this.pickFirstBalancerFactory = (LoadBalancer2.Factory)Preconditions.checkNotNull((Object)pickFirstBalancerFactory, (Object)"pickFirstBalancerFactory");
        this.roundRobinBalancerFactory = (LoadBalancer2.Factory)Preconditions.checkNotNull((Object)roundRobinBalancerFactory, (Object)"roundRobinBalancerFactory");
    }

    public LogId getLogId() {
        return this.logId;
    }

    public void handleSubchannelState(LoadBalancer2.Subchannel subchannel, ConnectivityStateInfo newState) {
        if (this.delegate != null) {
            this.delegate.handleSubchannelState(subchannel, newState);
            return;
        }
        if (newState.getState() == ConnectivityState.SHUTDOWN || !this.subchannels.values().contains(subchannel)) {
            return;
        }
        if (newState.getState() == ConnectivityState.IDLE) {
            subchannel.requestConnection();
        }
        ((AtomicReference)subchannel.getAttributes().get(STATE_INFO)).set(newState);
        this.helper.updatePicker(this.makePicker());
    }

    public void handleResolvedAddresses(List<ResolvedServerInfoGroup> updatedServers, Attributes attributes) {
        GrpclbConstants.LbPolicy newLbPolicy = (GrpclbConstants.LbPolicy)((Object)attributes.get(GrpclbConstants.ATTR_LB_POLICY));
        ArrayList<LbAddressGroup> newLbAddressGroups = new ArrayList<LbAddressGroup>();
        ArrayList<ResolvedServerInfoGroup> newBackendServerInfoGroups = new ArrayList<ResolvedServerInfoGroup>();
        for (ResolvedServerInfoGroup serverInfoGroup : updatedServers) {
            String lbAddrAuthority = (String)serverInfoGroup.getAttributes().get(GrpclbConstants.ATTR_LB_ADDR_AUTHORITY);
            EquivalentAddressGroup eag = serverInfoGroup.toEquivalentAddressGroup();
            if (lbAddrAuthority != null) {
                newLbAddressGroups.add(new LbAddressGroup(eag, lbAddrAuthority));
                continue;
            }
            newBackendServerInfoGroups.add(serverInfoGroup);
        }
        if (newBackendServerInfoGroups.isEmpty()) {
            Preconditions.checkState((!newLbAddressGroups.isEmpty() ? 1 : 0) != 0, (String)"No backend address nor LB address.  updatedServers=%s", updatedServers);
            if (newLbPolicy != GrpclbConstants.LbPolicy.GRPCLB) {
                newLbPolicy = GrpclbConstants.LbPolicy.GRPCLB;
                logger.log(Level.FINE, "[{0}] Switching to GRPCLB because all addresses are balancers", this.logId);
            }
        }
        if (newLbPolicy == null) {
            logger.log(Level.FINE, "[{0}] New config missing policy. Using PICK_FIRST", this.logId);
            newLbPolicy = GrpclbConstants.LbPolicy.PICK_FIRST;
        }
        if (newLbPolicy != this.lbPolicy) {
            this.shutdownDelegate();
            this.shutdownLbComm();
            this.lbAddressGroups = null;
            this.currentLbIndex = 0;
            switch (newLbPolicy) {
                case PICK_FIRST: {
                    this.delegate = (LoadBalancer2)Preconditions.checkNotNull((Object)this.pickFirstBalancerFactory.newLoadBalancer(this.helper), (Object)"pickFirstBalancerFactory.newLoadBalancer()");
                    break;
                }
                case ROUND_ROBIN: {
                    this.delegate = (LoadBalancer2)Preconditions.checkNotNull((Object)this.roundRobinBalancerFactory.newLoadBalancer(this.helper), (Object)"roundRobinBalancerFactory.newLoadBalancer()");
                    break;
                }
            }
        }
        this.lbPolicy = newLbPolicy;
        switch (this.lbPolicy) {
            case PICK_FIRST: 
            case ROUND_ROBIN: {
                Preconditions.checkNotNull((Object)this.delegate, (Object)("delegate should not be null. newLbPolicy=" + (Object)((Object)newLbPolicy)));
                this.delegate.handleResolvedAddresses(newBackendServerInfoGroups, attributes);
                break;
            }
            case GRPCLB: {
                if (newLbAddressGroups.isEmpty()) {
                    this.shutdownLbComm();
                    this.lbAddressGroups = null;
                    this.handleGrpclbError(Status.UNAVAILABLE.withDescription("NameResolver returned no LB address while asking for GRPCLB"));
                    break;
                }
                int newIndexOfCurrentLb = -1;
                if (this.lbAddressGroups != null) {
                    LbAddressGroup currentLb = this.lbAddressGroups.get(this.currentLbIndex);
                    newIndexOfCurrentLb = newLbAddressGroups.indexOf(currentLb);
                }
                this.lbAddressGroups = newLbAddressGroups;
                if (newIndexOfCurrentLb == -1) {
                    this.shutdownLbComm();
                    this.currentLbIndex = 0;
                    this.startLbComm();
                    break;
                }
                this.currentLbIndex = newIndexOfCurrentLb;
                break;
            }
        }
    }

    private void shutdownLbComm() {
        if (this.lbCommChannel != null) {
            this.lbCommChannel.shutdown();
            this.lbCommChannel = null;
        }
        if (this.lbRequestWriter != null) {
            this.lbRequestWriter.onCompleted();
            this.lbRequestWriter = null;
        }
        if (this.lbResponseObserver != null) {
            this.lbResponseObserver.dismissed = true;
            this.lbResponseObserver = null;
        }
    }

    private void startLbComm() {
        Preconditions.checkState((this.lbCommChannel == null ? 1 : 0) != 0, (Object)"previous lbCommChannel has not been closed yet");
        Preconditions.checkState((this.lbRequestWriter == null ? 1 : 0) != 0, (Object)"previous lbRequestWriter has not been cleared yet");
        Preconditions.checkState((this.lbResponseObserver == null ? 1 : 0) != 0, (Object)"previous lbResponseObserver has not been cleared yet");
        LbAddressGroup currentLb = this.lbAddressGroups.get(this.currentLbIndex);
        this.lbCommChannel = this.helper.createOobChannel(currentLb.getAddresses(), currentLb.getAuthority());
        LoadBalancerGrpc.LoadBalancerStub stub = LoadBalancerGrpc.newStub((Channel)this.lbCommChannel);
        this.lbResponseObserver = new LbResponseObserver();
        this.lbRequestWriter = stub.balanceLoad(this.lbResponseObserver);
        LoadBalanceRequest initRequest = LoadBalanceRequest.newBuilder().setInitialRequest(InitialLoadBalanceRequest.newBuilder().setName(this.serviceName).build()).build();
        this.lbRequestWriter.onNext((Object)initRequest);
    }

    private void shutdownDelegate() {
        if (this.delegate != null) {
            this.delegate.shutdown();
            this.delegate = null;
        }
    }

    public void shutdown() {
        this.shutdownDelegate();
        this.shutdownLbComm();
        for (LoadBalancer2.Subchannel subchannel : this.subchannels.values()) {
            subchannel.shutdown();
        }
        this.subchannels = Collections.emptyMap();
    }

    private void handleGrpclbError(Status status) {
        logger.log(Level.FINE, "[{0}] Had an error: {1}; roundRobinList={2}", new Object[]{this.logId, status, this.roundRobinList});
        if (this.roundRobinList.isEmpty()) {
            this.helper.updatePicker((LoadBalancer2.SubchannelPicker)new ErrorPicker(status));
        }
    }

    public void handleNameResolutionError(Status error) {
        if (this.delegate != null) {
            this.delegate.handleNameResolutionError(error);
        } else {
            this.handleGrpclbError(error);
        }
    }

    private LoadBalancer2.SubchannelPicker makePicker() {
        ArrayList<LoadBalancer2.PickResult> resultList = new ArrayList<LoadBalancer2.PickResult>();
        Status error = null;
        for (EquivalentAddressGroup eag : this.roundRobinList) {
            if (eag == null) {
                resultList.add(THROTTLED_RESULT);
                continue;
            }
            LoadBalancer2.Subchannel subchannel = this.subchannels.get(eag);
            Preconditions.checkNotNull((Object)subchannel, (String)"Subchannel for %s not found", (Object)eag);
            Attributes attrs = subchannel.getAttributes();
            ConnectivityStateInfo stateInfo = (ConnectivityStateInfo)((AtomicReference)attrs.get(STATE_INFO)).get();
            if (stateInfo.getState() == ConnectivityState.READY) {
                resultList.add(LoadBalancer2.PickResult.withSubchannel((LoadBalancer2.Subchannel)subchannel));
                continue;
            }
            if (stateInfo.getState() != ConnectivityState.TRANSIENT_FAILURE) continue;
            error = stateInfo.getStatus();
        }
        if (resultList.isEmpty()) {
            if (error != null) {
                logger.log(Level.FINE, "[{0}] No ready Subchannel. Using error: {1}", new Object[]{this.logId, error});
                return new ErrorPicker(error);
            }
            logger.log(Level.FINE, "[{0}] No ready Subchannel and no error", this.logId);
            return BUFFER_PICKER;
        }
        logger.log(Level.FINE, "[{0}] Using list {1}", new Object[]{this.logId, resultList});
        return new RoundRobinPicker(resultList);
    }

    @VisibleForTesting
    LoadBalancer2 getDelegate() {
        return this.delegate;
    }

    @VisibleForTesting
    GrpclbConstants.LbPolicy getLbPolicy() {
        return this.lbPolicy;
    }

    @VisibleForTesting
    static final class RoundRobinPicker
    extends LoadBalancer2.SubchannelPicker {
        final List<LoadBalancer2.PickResult> list;
        int index;

        RoundRobinPicker(List<LoadBalancer2.PickResult> resultList) {
            Preconditions.checkArgument((!resultList.isEmpty() ? 1 : 0) != 0, (Object)"resultList is empty");
            this.list = resultList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LoadBalancer2.PickResult pickSubchannel(Attributes affinity, Metadata headers) {
            List<LoadBalancer2.PickResult> list = this.list;
            synchronized (list) {
                LoadBalancer2.PickResult result = this.list.get(this.index);
                ++this.index;
                if (this.index == this.list.size()) {
                    this.index = 0;
                }
                return result;
            }
        }
    }

    @VisibleForTesting
    static final class ErrorPicker
    extends LoadBalancer2.SubchannelPicker {
        final LoadBalancer2.PickResult result;

        ErrorPicker(Status status) {
            this.result = LoadBalancer2.PickResult.withError((Status)status);
        }

        public LoadBalancer2.PickResult pickSubchannel(Attributes affinity, Metadata headers) {
            return this.result;
        }
    }

    private class LbResponseObserver
    implements StreamObserver<LoadBalanceResponse> {
        boolean dismissed;

        private LbResponseObserver() {
        }

        public void onNext(final LoadBalanceResponse response) {
            GrpclbLoadBalancer2.this.helper.runSerialized(new Runnable(){

                @Override
                public void run() {
                    LbResponseObserver.this.handleResponse(response);
                }
            });
        }

        private void handleResponse(LoadBalanceResponse response) {
            if (this.dismissed) {
                return;
            }
            logger.log(Level.FINE, "[{0}] Got an LB response: {1}", new Object[]{GrpclbLoadBalancer2.this.logId, response});
            ServerList serverList = response.getServerList();
            HashMap<EquivalentAddressGroup, LoadBalancer2.Subchannel> newSubchannelMap = new HashMap<EquivalentAddressGroup, LoadBalancer2.Subchannel>();
            ArrayList<EquivalentAddressGroup> newRoundRobinList = new ArrayList<EquivalentAddressGroup>();
            for (Server server : serverList.getServersList()) {
                InetSocketAddress address;
                if (server.getDropRequest()) {
                    newRoundRobinList.add(null);
                    continue;
                }
                try {
                    address = new InetSocketAddress(InetAddress.getByAddress(server.getIpAddress().toByteArray()), server.getPort());
                }
                catch (UnknownHostException e) {
                    GrpclbLoadBalancer2.this.handleGrpclbError(Status.UNAVAILABLE.withCause((Throwable)e));
                    continue;
                }
                EquivalentAddressGroup eag = new EquivalentAddressGroup((SocketAddress)address);
                if (!newSubchannelMap.containsKey(eag)) {
                    Attributes subchannelAttrs = Attributes.newBuilder().set(STATE_INFO, new AtomicReference<ConnectivityStateInfo>(ConnectivityStateInfo.forNonError((ConnectivityState)ConnectivityState.IDLE))).build();
                    LoadBalancer2.Subchannel subchannel = GrpclbLoadBalancer2.this.helper.createSubchannel(eag, subchannelAttrs);
                    subchannel.requestConnection();
                    newSubchannelMap.put(eag, subchannel);
                }
                newRoundRobinList.add(eag);
            }
            for (Map.Entry entry : GrpclbLoadBalancer2.this.subchannels.entrySet()) {
                EquivalentAddressGroup eag = (EquivalentAddressGroup)entry.getKey();
                if (newSubchannelMap.containsKey(eag)) continue;
                ((LoadBalancer2.Subchannel)entry.getValue()).shutdown();
            }
            GrpclbLoadBalancer2.this.subchannels = newSubchannelMap;
            GrpclbLoadBalancer2.this.roundRobinList = newRoundRobinList;
            GrpclbLoadBalancer2.this.helper.updatePicker(GrpclbLoadBalancer2.this.makePicker());
        }

        public void onError(final Throwable error) {
            GrpclbLoadBalancer2.this.helper.runSerialized(new Runnable(){

                @Override
                public void run() {
                    LbResponseObserver.this.handleStreamClosed(Status.fromThrowable((Throwable)error).augmentDescription("Stream to GRPCLB LoadBalancer had an error"));
                }
            });
        }

        public void onCompleted() {
            GrpclbLoadBalancer2.this.helper.runSerialized(new Runnable(){

                @Override
                public void run() {
                    LbResponseObserver.this.handleStreamClosed(Status.UNAVAILABLE.augmentDescription("Stream to GRPCLB LoadBalancer was closed"));
                }
            });
        }

        private void handleStreamClosed(Status status) {
            if (this.dismissed) {
                return;
            }
            GrpclbLoadBalancer2.this.lbRequestWriter = null;
            GrpclbLoadBalancer2.this.handleGrpclbError(status);
            GrpclbLoadBalancer2.this.shutdownLbComm();
            GrpclbLoadBalancer2.this.currentLbIndex = (GrpclbLoadBalancer2.this.currentLbIndex + 1) % GrpclbLoadBalancer2.this.lbAddressGroups.size();
            GrpclbLoadBalancer2.this.startLbComm();
        }
    }
}

