/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.grpclb;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.ConnectivityStateInfo;
import io.grpc.EquivalentAddressGroup;
import io.grpc.LoadBalancer;
import io.grpc.Status;
import io.grpc.grpclb.GrpclbConstants;
import io.grpc.grpclb.GrpclbState;
import io.grpc.grpclb.LbAddressGroup;
import io.grpc.grpclb.SubchannelPool;
import io.grpc.grpclb.TimeProvider;
import io.grpc.internal.GrpcAttributes;
import io.grpc.internal.LogId;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.WithLogId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

class GrpclbLoadBalancer
extends LoadBalancer
implements WithLogId {
    private static final Logger logger = Logger.getLogger(GrpclbLoadBalancer.class.getName());
    private final LogId logId = LogId.allocate((String)((Object)((Object)this)).getClass().getName());
    private final LoadBalancer.Helper helper;
    private final SubchannelPool subchannelPool;
    private final LoadBalancer.Factory pickFirstBalancerFactory;
    private final LoadBalancer.Factory roundRobinBalancerFactory;
    private final ObjectPool<ScheduledExecutorService> timerServicePool;
    private final TimeProvider time;
    private ScheduledExecutorService timerService;
    @Nullable
    private LoadBalancer delegate;
    private GrpclbConstants.LbPolicy lbPolicy;
    @Nullable
    private GrpclbState grpclbState;

    GrpclbLoadBalancer(LoadBalancer.Helper helper, SubchannelPool subchannelPool, LoadBalancer.Factory pickFirstBalancerFactory, LoadBalancer.Factory roundRobinBalancerFactory, ObjectPool<ScheduledExecutorService> timerServicePool, TimeProvider time) {
        this.helper = (LoadBalancer.Helper)Preconditions.checkNotNull((Object)helper, (Object)"helper");
        this.pickFirstBalancerFactory = (LoadBalancer.Factory)Preconditions.checkNotNull((Object)pickFirstBalancerFactory, (Object)"pickFirstBalancerFactory");
        this.roundRobinBalancerFactory = (LoadBalancer.Factory)Preconditions.checkNotNull((Object)roundRobinBalancerFactory, (Object)"roundRobinBalancerFactory");
        this.timerServicePool = (ObjectPool)Preconditions.checkNotNull(timerServicePool, (Object)"timerServicePool");
        this.timerService = (ScheduledExecutorService)Preconditions.checkNotNull((Object)timerServicePool.getObject(), (Object)"timerService");
        this.time = (TimeProvider)Preconditions.checkNotNull((Object)time, (Object)"time provider");
        this.subchannelPool = (SubchannelPool)Preconditions.checkNotNull((Object)subchannelPool, (Object)"subchannelPool");
        this.subchannelPool.init(helper, this.timerService);
        this.setLbPolicy(GrpclbConstants.LbPolicy.GRPCLB);
    }

    public LogId getLogId() {
        return this.logId;
    }

    public void handleSubchannelState(LoadBalancer.Subchannel subchannel, ConnectivityStateInfo newState) {
        if (this.delegate != null) {
            this.delegate.handleSubchannelState(subchannel, newState);
            return;
        }
        if (this.grpclbState != null) {
            this.grpclbState.handleSubchannelState(subchannel, newState);
        }
    }

    public void handleResolvedAddressGroups(List<EquivalentAddressGroup> updatedServers, Attributes attributes) {
        GrpclbConstants.LbPolicy newLbPolicy = (GrpclbConstants.LbPolicy)((Object)attributes.get(GrpclbConstants.ATTR_LB_POLICY));
        List<LbAddressGroup> newLbAddressGroups = new ArrayList();
        List<EquivalentAddressGroup> newBackendServers = new ArrayList();
        for (EquivalentAddressGroup server : updatedServers) {
            String lbAddrAuthority = (String)server.getAttributes().get(GrpcAttributes.ATTR_LB_ADDR_AUTHORITY);
            if (lbAddrAuthority != null) {
                newLbAddressGroups.add(new LbAddressGroup(server, lbAddrAuthority));
                continue;
            }
            newBackendServers.add(server);
        }
        newLbAddressGroups = Collections.unmodifiableList(newLbAddressGroups);
        newBackendServers = Collections.unmodifiableList(newBackendServers);
        if (!newLbAddressGroups.isEmpty() && newLbPolicy != GrpclbConstants.LbPolicy.GRPCLB) {
            newLbPolicy = GrpclbConstants.LbPolicy.GRPCLB;
            logger.log(Level.FINE, "[{0}] Switching to GRPCLB because there is at least one balancer", this.logId);
        }
        if (newLbPolicy == null) {
            logger.log(Level.FINE, "[{0}] New config missing policy. Using PICK_FIRST", this.logId);
            newLbPolicy = GrpclbConstants.LbPolicy.PICK_FIRST;
        }
        this.setLbPolicy(newLbPolicy);
        switch (this.lbPolicy) {
            case PICK_FIRST: 
            case ROUND_ROBIN: {
                Preconditions.checkNotNull((Object)this.delegate, (Object)("delegate should not be null. newLbPolicy=" + (Object)((Object)newLbPolicy)));
                this.delegate.handleResolvedAddressGroups(newBackendServers, attributes);
                break;
            }
            case GRPCLB: {
                this.grpclbState.handleAddresses(newLbAddressGroups, newBackendServers);
                break;
            }
        }
    }

    private void setLbPolicy(GrpclbConstants.LbPolicy newLbPolicy) {
        if (newLbPolicy != this.lbPolicy) {
            this.resetStates();
            switch (newLbPolicy) {
                case PICK_FIRST: {
                    this.delegate = (LoadBalancer)Preconditions.checkNotNull((Object)this.pickFirstBalancerFactory.newLoadBalancer(this.helper), (Object)"pickFirstBalancerFactory.newLoadBalancer()");
                    break;
                }
                case ROUND_ROBIN: {
                    this.delegate = (LoadBalancer)Preconditions.checkNotNull((Object)this.roundRobinBalancerFactory.newLoadBalancer(this.helper), (Object)"roundRobinBalancerFactory.newLoadBalancer()");
                    break;
                }
                case GRPCLB: {
                    this.grpclbState = new GrpclbState(this.helper, this.subchannelPool, this.time, this.timerService, this.logId);
                    break;
                }
            }
        }
        this.lbPolicy = newLbPolicy;
    }

    private void resetStates() {
        if (this.delegate != null) {
            this.delegate.shutdown();
            this.delegate = null;
        }
        if (this.grpclbState != null) {
            this.grpclbState.shutdown();
            this.grpclbState = null;
        }
    }

    public void shutdown() {
        this.resetStates();
        this.timerService = (ScheduledExecutorService)this.timerServicePool.returnObject((Object)this.timerService);
    }

    public void handleNameResolutionError(Status error) {
        if (this.delegate != null) {
            this.delegate.handleNameResolutionError(error);
        }
        if (this.grpclbState != null) {
            this.grpclbState.propagateError(error);
        }
    }

    @Nullable
    @VisibleForTesting
    GrpclbState getGrpclbState() {
        return this.grpclbState;
    }

    @VisibleForTesting
    LoadBalancer getDelegate() {
        return this.delegate;
    }

    @VisibleForTesting
    GrpclbConstants.LbPolicy getLbPolicy() {
        return this.lbPolicy;
    }
}

