/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.grpclb;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import io.grpc.Attributes;
import io.grpc.ChannelLogger;
import io.grpc.EquivalentAddressGroup;
import io.grpc.LoadBalancer;
import io.grpc.Status;
import io.grpc.grpclb.GrpclbConfig;
import io.grpc.grpclb.GrpclbConstants;
import io.grpc.grpclb.GrpclbState;
import io.grpc.grpclb.LbAddressGroup;
import io.grpc.grpclb.SubchannelPool;
import io.grpc.internal.BackoffPolicy;
import io.grpc.internal.TimeProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

class GrpclbLoadBalancer
extends LoadBalancer {
    private static final GrpclbConfig DEFAULT_CONFIG = GrpclbConfig.create(GrpclbState.Mode.ROUND_ROBIN);
    private final LoadBalancer.Helper helper;
    private final TimeProvider time;
    private final Stopwatch stopwatch;
    private final SubchannelPool subchannelPool;
    private final BackoffPolicy.Provider backoffPolicyProvider;
    private GrpclbConfig config = DEFAULT_CONFIG;
    @Nullable
    private GrpclbState grpclbState;

    GrpclbLoadBalancer(LoadBalancer.Helper helper, SubchannelPool subchannelPool, TimeProvider time, Stopwatch stopwatch, BackoffPolicy.Provider backoffPolicyProvider) {
        this.helper = (LoadBalancer.Helper)Preconditions.checkNotNull((Object)helper, (Object)"helper");
        this.time = (TimeProvider)Preconditions.checkNotNull((Object)time, (Object)"time provider");
        this.stopwatch = (Stopwatch)Preconditions.checkNotNull((Object)stopwatch, (Object)"stopwatch");
        this.backoffPolicyProvider = (BackoffPolicy.Provider)Preconditions.checkNotNull((Object)backoffPolicyProvider, (Object)"backoffPolicyProvider");
        this.subchannelPool = (SubchannelPool)Preconditions.checkNotNull((Object)subchannelPool, (Object)"subchannelPool");
        this.recreateStates();
        Preconditions.checkNotNull((Object)this.grpclbState, (Object)"grpclbState");
    }

    public void handleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        Attributes attributes = resolvedAddresses.getAttributes();
        List newLbAddresses = (List)attributes.get(GrpclbConstants.ATTR_LB_ADDRS);
        if ((newLbAddresses == null || newLbAddresses.isEmpty()) && resolvedAddresses.getAddresses().isEmpty()) {
            this.handleNameResolutionError(Status.UNAVAILABLE.withDescription("No backend or balancer addresses found"));
            return;
        }
        ArrayList<LbAddressGroup> newLbAddressGroups = new ArrayList();
        if (newLbAddresses != null) {
            for (EquivalentAddressGroup lbAddr : newLbAddresses) {
                String lbAddrAuthority = (String)lbAddr.getAttributes().get(GrpclbConstants.ATTR_LB_ADDR_AUTHORITY);
                if (lbAddrAuthority == null) {
                    throw new AssertionError((Object)("This is a bug: LB address " + lbAddr + " does not have an authority."));
                }
                newLbAddressGroups.add(new LbAddressGroup(lbAddr, lbAddrAuthority));
            }
        }
        newLbAddressGroups = Collections.unmodifiableList(newLbAddressGroups);
        List<EquivalentAddressGroup> newBackendServers = Collections.unmodifiableList(resolvedAddresses.getAddresses());
        GrpclbConfig newConfig = (GrpclbConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
        if (newConfig == null) {
            newConfig = DEFAULT_CONFIG;
        }
        if (!this.config.equals(newConfig)) {
            this.config = newConfig;
            this.helper.getChannelLogger().log(ChannelLogger.ChannelLogLevel.INFO, "Config: " + newConfig);
            this.recreateStates();
        }
        this.grpclbState.handleAddresses(newLbAddressGroups, newBackendServers);
    }

    public void requestConnection() {
        if (this.grpclbState != null) {
            this.grpclbState.requestConnection();
        }
    }

    private void resetStates() {
        if (this.grpclbState != null) {
            this.grpclbState.shutdown();
            this.grpclbState = null;
        }
    }

    private void recreateStates() {
        this.resetStates();
        Preconditions.checkState((this.grpclbState == null ? 1 : 0) != 0, (Object)"Should've been cleared");
        this.grpclbState = new GrpclbState(this.config, this.helper, this.subchannelPool, this.time, this.stopwatch, this.backoffPolicyProvider);
    }

    public void shutdown() {
        this.resetStates();
    }

    public void handleNameResolutionError(Status error) {
        if (this.grpclbState != null) {
            this.grpclbState.propagateError(error);
        }
    }

    public boolean canHandleEmptyAddressListFromNameResolution() {
        return true;
    }

    @Nullable
    @VisibleForTesting
    GrpclbState getGrpclbState() {
        return this.grpclbState;
    }
}

