/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.alts;

import io.grpc.BindableService;
import io.grpc.Channel;
import io.grpc.CompressorRegistry;
import io.grpc.DecompressorRegistry;
import io.grpc.ExperimentalApi;
import io.grpc.HandlerRegistry;
import io.grpc.Metadata;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServerStreamTracer;
import io.grpc.ServerTransportFilter;
import io.grpc.Status;
import io.grpc.alts.CheckGcpEnvironment;
import io.grpc.alts.HandshakerServiceChannel;
import io.grpc.alts.internal.AltsProtocolNegotiator;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.SharedResourcePool;
import io.grpc.netty.NettyServerBuilder;
import io.grpc.netty.ProtocolNegotiator;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4151")
public final class AltsServerBuilder
extends ServerBuilder<AltsServerBuilder> {
    private static final Logger logger = Logger.getLogger(AltsServerBuilder.class.getName());
    private final NettyServerBuilder delegate;
    private ObjectPool<Channel> handshakerChannelPool = SharedResourcePool.forResource(HandshakerServiceChannel.SHARED_HANDSHAKER_CHANNEL);
    private boolean enableUntrustedAlts;

    private AltsServerBuilder(NettyServerBuilder nettyDelegate) {
        this.delegate = nettyDelegate;
    }

    public static AltsServerBuilder forPort(int port) {
        NettyServerBuilder nettyDelegate = NettyServerBuilder.forAddress((SocketAddress)new InetSocketAddress(port));
        return new AltsServerBuilder(nettyDelegate);
    }

    public AltsServerBuilder enableUntrustedAltsForTesting() {
        this.enableUntrustedAlts = true;
        return this;
    }

    public AltsServerBuilder setHandshakerAddressForTesting(String handshakerAddress) {
        this.handshakerChannelPool = SharedResourcePool.forResource(HandshakerServiceChannel.getHandshakerChannelForTesting(handshakerAddress));
        return this;
    }

    public AltsServerBuilder handshakeTimeout(long timeout, TimeUnit unit) {
        this.delegate.handshakeTimeout(timeout, unit);
        return this;
    }

    public AltsServerBuilder directExecutor() {
        this.delegate.directExecutor();
        return this;
    }

    public AltsServerBuilder addStreamTracerFactory(ServerStreamTracer.Factory factory) {
        this.delegate.addStreamTracerFactory(factory);
        return this;
    }

    public AltsServerBuilder addTransportFilter(ServerTransportFilter filter) {
        this.delegate.addTransportFilter(filter);
        return this;
    }

    public AltsServerBuilder executor(Executor executor) {
        this.delegate.executor(executor);
        return this;
    }

    public AltsServerBuilder addService(ServerServiceDefinition service) {
        this.delegate.addService(service);
        return this;
    }

    public AltsServerBuilder addService(BindableService bindableService) {
        this.delegate.addService(bindableService);
        return this;
    }

    public AltsServerBuilder fallbackHandlerRegistry(HandlerRegistry fallbackRegistry) {
        this.delegate.fallbackHandlerRegistry(fallbackRegistry);
        return this;
    }

    public AltsServerBuilder useTransportSecurity(File certChain, File privateKey) {
        throw new UnsupportedOperationException("Can't set TLS settings for ALTS");
    }

    public AltsServerBuilder decompressorRegistry(DecompressorRegistry registry) {
        this.delegate.decompressorRegistry(registry);
        return this;
    }

    public AltsServerBuilder compressorRegistry(CompressorRegistry registry) {
        this.delegate.compressorRegistry(registry);
        return this;
    }

    public AltsServerBuilder intercept(ServerInterceptor interceptor) {
        this.delegate.intercept(interceptor);
        return this;
    }

    public Server build() {
        if (!CheckGcpEnvironment.isOnGcp()) {
            if (this.enableUntrustedAlts) {
                logger.log(Level.WARNING, "Untrusted ALTS mode is enabled and we cannot guarantee the trustworthiness of the ALTS handshaker service");
            } else {
                Status status = Status.INTERNAL.withDescription("ALTS is only allowed to run on Google Cloud Platform");
                this.delegate.intercept((ServerInterceptor)new FailingServerInterceptor(status));
            }
        }
        this.delegate.protocolNegotiator((ProtocolNegotiator)AltsProtocolNegotiator.serverAltsProtocolNegotiator(this.handshakerChannelPool));
        return this.delegate.build();
    }

    static final class FailingServerInterceptor
    implements ServerInterceptor {
        private final Status status;

        public FailingServerInterceptor(Status status) {
            this.status = status;
        }

        public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> serverCall, Metadata metadata, ServerCallHandler<ReqT, RespT> nextHandler) {
            serverCall.close(this.status, new Metadata());
            return new ServerCall.Listener<ReqT>(){};
        }
    }
}

