/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.alpn.agent;

import org.mortbay.jetty.alpn.agent.JavaVersion;

final class VersionMapping {
    static final VersionMapping LAST = new VersionMapping(null, 1, 8, 0, 252);
    private final String artifactVersion;
    private final int major;
    private final int minor;
    private final int micro;
    private final int startPatch;

    VersionMapping(String artifactVersion, int major, int minor, int micro, int startPatch) {
        this.artifactVersion = artifactVersion;
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.startPatch = startPatch;
    }

    String artifactVersion() {
        return this.artifactVersion;
    }

    boolean matches() {
        if (JavaVersion.major() != this.major) {
            return false;
        }
        if (JavaVersion.minor() != this.minor) {
            return false;
        }
        if (JavaVersion.micro() != this.micro) {
            return false;
        }
        return JavaVersion.patch() >= this.startPatch;
    }

    public String toString() {
        return this.artifactVersion + ": " + this.major + '.' + this.minor + '.' + this.micro + '_' + this.startPatch + '~';
    }
}

