/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.annotations.checkers;

import com.google.common.base.Preconditions;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Types;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;

abstract class AnnotationChecker
extends BugChecker
implements BugChecker.IdentifierTreeMatcher,
BugChecker.MemberSelectTreeMatcher {
    private final String annotationType;
    private final boolean requireAnnotationOnMethodHierarchy;

    AnnotationChecker(String annotationType) {
        this(annotationType, false);
    }

    AnnotationChecker(String annotationType, boolean requireAnnotationOnMethodHierarchy) {
        this.annotationType = (String)Preconditions.checkNotNull((Object)annotationType, (Object)"annotationType");
        this.requireAnnotationOnMethodHierarchy = requireAnnotationOnMethodHierarchy;
    }

    private AnnotationMirror findAnnotatedApi(Symbol symbol) {
        if (symbol == null) {
            return null;
        }
        for (AnnotationMirror annotation : symbol.getAnnotationMirrors()) {
            if (!annotation.getAnnotationType().toString().equals(this.annotationType)) continue;
            return annotation;
        }
        return this.findAnnotatedApi(symbol.owner);
    }

    private Description match(Tree tree, VisitorState state) {
        Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
        if (symbol == null) {
            return Description.NO_MATCH;
        }
        AnnotationMirror annotation = this.findAnnotatedApi(symbol);
        if (annotation == null) {
            return Description.NO_MATCH;
        }
        if (this.requireAnnotationOnMethodHierarchy && symbol instanceof Symbol.MethodSymbol) {
            Set superMethods = ASTHelpers.findSuperMethods((Symbol.MethodSymbol)((Symbol.MethodSymbol)symbol), (Types)state.getTypes());
            for (Symbol.MethodSymbol superMethod : superMethods) {
                AnnotationMirror superAnnotation = this.findAnnotatedApi(superMethod);
                if (superAnnotation != null) continue;
                return Description.NO_MATCH;
            }
        }
        return this.describe(tree, annotation);
    }

    protected abstract Description describe(Tree var1, AnnotationMirror var2);

    public Description matchIdentifier(IdentifierTree tree, VisitorState state) {
        return this.match(tree, state);
    }

    public Description matchMemberSelect(MemberSelectTree tree, VisitorState state) {
        return this.match(tree, state);
    }
}

