/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.annotations.checkers;

import com.google.errorprone.BugPattern;
import com.google.errorprone.matchers.Description;
import com.sun.source.tree.Tree;
import io.grpc.annotations.checkers.AnnotationChecker;
import java.util.Iterator;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;

@BugPattern(name="GrpcExperimentalApi", summary="@ExperimentalApi should not be used in application code", explanation="@ExperimentalApi should not be used in application code", severity=BugPattern.SeverityLevel.ERROR, linkType=BugPattern.LinkType.CUSTOM, link="https://github.com/grpc/grpc-java")
public final class ExperimentalApiChecker
extends AnnotationChecker {
    public ExperimentalApiChecker() {
        super("io.grpc.ExperimentalApi");
    }

    private String findLink(AnnotationMirror annotation) {
        Iterator<Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>> iterator = annotation.getElementValues().entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry = iterator.next();
            return entry.getValue().toString();
        }
        return null;
    }

    @Override
    protected Description describe(Tree tree, AnnotationMirror annotation) {
        String link = this.findLink(annotation);
        return Description.builder((Tree)tree, (String)this.canonicalName(), (String)(link == null ? this.linkUrl() : link), (BugPattern.SeverityLevel)this.defaultSeverity(), (String)this.message()).build();
    }
}

